/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bsz.dc.service.receipt.fetch;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.BankReceiptInfoRequestImpl;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.OPCB000016_ReceiveItem;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankReceiptInfoRequestImpl bankReceiptInfoRequest = new BankReceiptInfoRequestImpl();
        String requestStr = "";
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(request.getTransDate()).accNo(request.getAccNo()).requestStr(requestStr).build();
        List<OPCB000016_ReceiveItem> opcb000016_receiveItems = bankReceiptInfoRequest.queryReceiptList(bankReceiptRequest);
        if (opcb000016_receiveItems.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]));
        }
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        for (OPCB000016_ReceiveItem opcb000016_receiveItem : opcb000016_receiveItems) {
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            String amount = opcb000016_receiveItem.getTRAN_AMT();
            String cdFlag = opcb000016_receiveItem.getDR_CR_FLAG();
            String seqNo = opcb000016_receiveItem.getCORE_SEQ_NO();
            cdFlag = Objects.equals(cdFlag, PropertiesConstantsUtils.getValue((String)"CD_CREDIT")) ? "D" : "C";
            StringBuilder fileName = new StringBuilder();
            fileName.append(accNo).append("_");
            fileName.append(transDateStr).append("_");
            fileName.append(seqNo).append("_");
            fileName.append(amount).append("_");
            fileName.append(cdFlag).append(".pdf");
            downloadListDetail.setFileLink(opcb000016_receiveItem.getRECEIPT_NO());
            downloadListDetail.setFileName(fileName.toString());
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }
}

