/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nhb.dc.receipt.service.api;

import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.nhb.dc.receipt.service.utils.Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class ReceiptPrintApi
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptPrintApi.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActTrsPrint";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = Packer.createHead("B2EActTrsPrint");
        String transDateStr = LocalDateUtil.formatDate((LocalDate)bankReceiptRequest.getTransDate());
        JDomUtils.addChild((Element)root, (Element)head);
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)bankReceiptRequest.getAccNo());
        JDomUtils.addChild((Element)body, (String)"TransDate", (String)transDateStr);
        JDomUtils.addChild((Element)body, (String)"SerialNo", (String)bankReceiptRequest.getRequestStr());
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element head = root.getChild("Head");
        String iBSReturnCode = head.getChildTextTrim("IBSReturnCode");
        String iBSReturnMsg = head.getChildTextTrim("IBSReturnMsg");
        if (!"000000".equals(iBSReturnCode)) {
            logger.info(responseStr);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u67e5\u8be2\u6253\u5370\u5931\u8d25 :%s\u3002", (String)"ReceiptPrintApi_0", (String)"ebg-receipt-banks-nhb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{iBSReturnCode, iBSReturnMsg})));
        }
        Element body = root.getChild("Body");
        String base64Content = body.getChildTextTrim("Base64Content");
        if (EBGStringUtils.isEmpty((String)base64Content)) {
            logger.info(responseStr);
            return BankReceiptResponseEB.fail((String)StringUtils.catWithSpace((String[])new String[]{iBSReturnCode, iBSReturnMsg}));
        }
        responseStr = ReceiptPrintApi.getXmlLog(responseStr, "Base64Content");
        logger.info(responseStr);
        return BankReceiptResponseEB.success((Object)base64Content);
    }

    public static String getXmlLog(String sendMsg, String bankKey) {
        String target;
        int startNo = sendMsg.indexOf("<" + bankKey + ">");
        int endNo = sendMsg.indexOf("</" + bankKey + ">");
        if (startNo != -1 && endNo != -1 && !EBGStringUtils.isEmpty((String)(target = sendMsg.substring(startNo, endNo)))) {
            String regix = "<" + bankKey + ">...";
            sendMsg = sendMsg.replace(target, regix);
        }
        return sendMsg;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri(Packer.getUrl(this.getBizCode()));
    }
}

