/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ghb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ghb.dc.constants.GhbDcConstants;
import kd.ebg.receipt.banks.ghb.dc.service.receipt.api.DetailInfo;
import kd.ebg.receipt.banks.ghb.dc.service.receipt.api.ReceiptFileDownloadImpl;
import kd.ebg.receipt.banks.ghb.dc.service.receipt.api.ReceiptQueryImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate(), (String)"yyyyMMdd");
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"GHB_DC", (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        ReceiptQueryImpl receiptQuery = new ReceiptQueryImpl();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)receiptQuery.doBiz((BankRequest)bankReceiptRequest);
        List detailInfos = (List)receiptResponseEB.getData();
        for (DetailInfo detailInfo : detailInfos) {
            String filePath;
            String TRNDT = detailInfo.getTRNDT();
            String HOSTSEQNO = detailInfo.getHOSTSEQNO();
            String OPPOACCTNO = detailInfo.getOPPOACCTNO();
            String TRNAMT = detailInfo.getTRNAMT();
            String newFileName = accNo + "_" + transDateStr + "_" + HOSTSEQNO + "_" + TRNAMT + ".pdf";
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileName(newFileName);
            result.add(detail);
            ReceiptFileDownloadImpl receiptFileDownload = new ReceiptFileDownloadImpl();
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)4);
            paramMap.put("TRNDT", TRNDT);
            paramMap.put("HOSTSEQNO", HOSTSEQNO);
            paramMap.put("OPPOACCTNO", OPPOACCTNO);
            bankReceiptRequest.setParamsMap((Map)paramMap);
            BankReceiptResponseEB bankReceiptResponseEB = (BankReceiptResponseEB)receiptFileDownload.doBiz((BankRequest)bankReceiptRequest);
            String content = (String)bankReceiptResponseEB.getData();
            if (FileCommonUtils.base64ToFile((String)content, (String)(filePath = bakFilePath + File.separator + newFileName))) continue;
            throw new ReceiptException(ResManager.loadKDString((String)"Base64\u89e3\u7801\u53d1\u751f\u9519\u8bef\uff0c\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-ghb-dc", (Object[])new Object[0]));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-ghb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GHB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return String.format(ResManager.loadKDString((String)"\u83b7\u53d6%s", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-ghb-dc", (Object[])new Object[0]), GhbDcConstants.VERSION_NAME);
    }
}

