/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.ccip.service.receipt.message;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.CCBHCBankResponse;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz.FileInfoNode;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class CommonParser {
    public static CCBHCBankResponse getBankPreResponse(String rspStr) throws Exception {
        CCBHCBankResponse response = new CCBHCBankResponse();
        Document doc = JDomExtUtils.str2DocUTF8((String)rspStr);
        Element root = doc.getRootElement();
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String statusCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_TX_STATUS");
        String bankCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_CODE");
        String bankMsg = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_DESC");
        String errorCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_DESC");
        String errorMsg = JDomExtUtils.getChildText((Element)header, (String)"ERR_DESCRIPTION");
        response.setResponseCode(errorCode);
        response.setResponseMessage(errorMsg);
        response.setSuccess("00".equals(statusCode));
        Element tranResponse = JDomExtUtils.getChildElement((Element)header, (String)"tran_response");
        if (null != tranResponse) {
            String status = JDomExtUtils.getChildText((Element)tranResponse, (String)"status");
            if ("COMPLETE".equals(status)) {
                response.setPaySuccess(true);
            } else if ("FAIL".equals(status)) {
                response.setPaySuccess(false);
            } else {
                response.setUnkown(true);
            }
        } else {
            response.setUnkown(true);
        }
        return response;
    }

    public static List<FileInfoNode> getRespFilesInfos(Element root) throws Exception {
        ArrayList<FileInfoNode> result = new ArrayList<FileInfoNode>(16);
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        Element fileListPack = JDomExtUtils.getChildElement((Element)response, (String)"FILE_LIST_PACK");
        String fileNumStr = JDomExtUtils.getChildText((Element)fileListPack, (String)"FILE_NUM");
        List fileInfo = fileListPack.getChildren("FILE_INFO");
        String acctulySize = fileInfo.size() + "";
        if (!acctulySize.equals(fileNumStr)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6587\u4ef6\u4fe1\u606f\u8282\u70b9\u683c\u5f0f\u4e0d\u5339\u914d\uff0c\u63cf\u8ff0\u4e3a\uff1a%1$s\u4e2a\uff0c\u5b9e\u9645\u4e3a\uff1a%2$s\u4e2a\u3002", (String)"CommonParser_3", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]), fileNumStr, acctulySize));
        }
        for (Element node : fileInfo) {
            FileInfoNode info = new FileInfoNode();
            String fileName = JDomExtUtils.getChildText((Element)node, (String)"FILE_NAME");
            String fileMD5 = JDomExtUtils.getChildText((Element)node, (String)"Msg_Smy");
            info.setFileName(fileName);
            info.setMd5(fileMD5);
            result.add(info);
        }
        return result;
    }

    public static String getFixedFileName(String bankFileName) {
        String[] filePaths = bankFileName.split("\\/");
        String fileName = filePaths[filePaths.length - 1];
        return fileName;
    }
}

