/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bosh.dc.service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.bosh.dc.service.api.receipt.BankReceiptImpl;
import kd.ebg.receipt.banks.bosh.dc.service.api.receipt.NewBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        List datas;
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"BOSH_DC", (String)accNo, (String)transDateStr);
        BankReceiptRequest req = this.buildReq(accNo, transDate);
        String apsNoInterface = RequestContextUtils.getBankParameterValue((String)"apsNoInterface");
        if (apsNoInterface.contains("new")) {
            datas = new NewBankReceiptImpl().process(req);
        } else {
            BankReceiptResponseEB fetchResp = new BankReceiptImpl().doBiz(req);
            datas = (List)fetchResp.getData();
        }
        int count = 1;
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        for (Map data : datas) {
            String dse_sessionId = RequestContextUtils.getRunningParam((String)"dse_sessionId");
            String serialNo = Sequence.gen8Sequence();
            String apsNo = (String)data.get("ApsNo");
            String OppAcctNo = (String)data.get("OppAcctNo");
            String Amount = (String)data.get("Amount");
            String Balance = (String)data.get("Balance");
            String DbCrdtFlg = (String)data.get("DbCrdtFlg");
            String fileName = apsNo + "_" + accNo + "_" + transDate + "_" + OppAcctNo + "_" + Amount + "_" + Balance + "_" + DbCrdtFlg + ".pdf";
            logger.info(String.format("\u6587\u4ef6\u540d%s,\u5f53\u524d\u4e0b\u8f7d\u7f16\u53f7>%s", fileName, count++));
            String url = "http://" + ip + ":" + port + "/CM/APINewReceiptPdfDownLoadServlet?dse_sessionId=" + dse_sessionId + "&serialNo=" + serialNo + "&ApsNo=" + apsNo;
            try {
                DownloadUtils.download((String)url, (String)fileName, (String)bakFilePath);
                logger.info("\u4e0b\u8f7d\u6210\u529f");
            }
            catch (Exception e) {
                logger.info("\u4e0b\u8f7d\u5f02\u5e38\uff0c\u9519\u8bef\u539f\u56e0" + e.getMessage());
            }
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(fileName);
            detail.setFileName(fileName);
            result.add(detail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankReceiptRequest buildReq(String accNo, LocalDate localDate) {
        return BankReceiptRequest.builder().accNo(accNo).transDate(localDate).build();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BOSH_BankReceiptFetchListAndDownloadTheList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]);
    }
}

