/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bosh.dc.service.api.receipt;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bosh.dc.service.api.login.LoginAndOut;
import kd.ebg.receipt.banks.bosh.dc.service.api.utils.Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Element;

public class BankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String squence = Sequence.genSequence();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String curDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Element root = JDomExtUtils.createRoot((String)"BOSEBankData");
        Element opReq = JDomExtUtils.addChild((Element)root, (String)"opReq");
        JDomExtUtils.addChild((Element)opReq, (String)"serialNo", (String)squence);
        JDomExtUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomExtUtils.addChild((Element)ReqParam, (String)"AcctNo", (String)bankReceiptRequest.getAccNo());
        JDomExtUtils.addChild((Element)ReqParam, (String)"BeginDate", (String)curDate);
        JDomExtUtils.addChild((Element)ReqParam, (String)"EndDate", (String)curDate);
        JDomExtUtils.addChild((Element)ReqParam, (String)"CurrentIndex", (String)"");
        JDomExtUtils.addChild((Element)ReqParam, (String)"PageSize", (String)"");
        String reqStr = JDomUtils.root2String((Element)root, (String)"GBK");
        String session = "";
        try {
            session = LoginAndOut.login4GetSession();
            RequestContextUtils.setRunningParam((String)"dse_sessionId", (String)session);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return Packer.getCommonBizReqData(session, "MCAcctTxnRcrdQry1_1Op", reqStr);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        ArrayList result = new ArrayList(8);
        Element BOSEBankData = JDomUtils.string2Root((String)s, (String)"GBK");
        Element opRep = JDomUtils.getUnNullChildElement((Element)BOSEBankData, (String)"opRep");
        String retCode = JDomUtils.getUnNullChildText((Element)opRep, (String)"retCode");
        String errMsg = JDomUtils.getUnNullChildText((Element)opRep, (String)"errMsg");
        Element opResult = JDomUtils.getUnNullChildElement((Element)opRep, (String)"opResult");
        String TotalCount = JDomUtils.getUnNullChildText((Element)opResult, (String)"TotalCount");
        if ("".equals(TotalCount) || "0".equals(TotalCount) || TotalCount == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u67e5\u8be2\u201cMCAcctTxnRcrdQry1_1Op\u201d\u8fd4\u56de\u8bb0\u5f55\u6570\u4e3a0\u3002", (String)"BankReceiptImpl_0", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]));
        }
        if ("0".equalsIgnoreCase(retCode)) {
            Element opResultSet = JDomUtils.getUnNullChildElement((Element)opRep, (String)"opResultSet");
            List opResults = opResultSet.getChildren("opResult");
            opResults.forEach(e -> {
                HashMap<String, String> map = new HashMap<String, String>();
                String OppAcctNo = JDomUtils.getUnNullChildText((Element)e, (String)"OppAcctNo");
                String Amount = JDomUtils.getUnNullChildText((Element)e, (String)"Amount");
                double amount = Double.parseDouble(Amount);
                Amount = String.format("%.2f", amount);
                String ApsNo = JDomUtils.getUnNullChildText((Element)e, (String)"ApsNo");
                if (StringUtils.isEmpty((String)ApsNo)) {
                    logger.info("\u4e0a\u6d77\u94f6\u884c \u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u67e5\u8be2\u201cMCAcctTxnRcrdQry1_1Op\u201d \u54cd\u5e94\u4e2d\uff1a" + e.getText() + "\u6b64\u7b14\u4ea4\u6613\u56de\u5355\u7f16\u53f7\u8fd4\u56de\u4e3a\u7a7a\uff01");
                    return;
                }
                String Balance = JDomUtils.getUnNullChildText((Element)e, (String)"Balance");
                if (!StringUtils.isEmpty((String)Balance)) {
                    try {
                        double bal = Double.parseDouble(Balance);
                        Balance = String.format("%.2f", bal);
                    }
                    catch (NumberFormatException | IllegalFormatException ex) {
                        logger.error("\u4f59\u989d\u683c\u5f0f\u6709\u8bef", (Throwable)ex);
                    }
                }
                String DbCrdtFlg = JDomUtils.getUnNullChildText((Element)e, (String)"DbCrdtFlg");
                map.put("ApsNo", ApsNo);
                map.put("OppAcctNo", OppAcctNo);
                map.put("Amount", Amount);
                map.put("Balance", Balance);
                map.put("DbCrdtFlg", DbCrdtFlg);
                result.add(map);
            });
            return BankReceiptResponseEB.success(result);
        }
        throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u8fd4\u56de\u7801\uff1a%s\u3002", (String)"BankReceiptImpl_4", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]), retCode) + String.format(ResManager.loadKDString((String)"\u9519\u8bef\u63cf\u8ff0\uff1a%s", (String)"BankReceiptImpl_5", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]), errMsg)));
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "0095";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u6587\u4ef6\u6d41", (String)"BankReceiptImpl_3", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
    }
}

