/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbcb.dc.services.receipt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.nbcb.dc.services.receipt.NBCBDcCommConfig;
import kd.ebg.receipt.banks.nbcb.dc.services.receipt.api.ReceiptResultQueryImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"NBCB_DC", (String)accNo, (String)transDateStr);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        String bankLoginId = request.getBankLoginId();
        NBCBDcCommConfig nbcbDcCommConfig = (NBCBDcCommConfig)EBConfigBuilder.getInstance().buildConfig(NBCBDcCommConfig.class, bankLoginId);
        String urlPre = nbcbDcCommConfig.getUrlPre();
        ArrayList<Long> ids = new ArrayList<Long>(1);
        for (DownloadListDetail detail : downloadListDetails) {
            if (!detail.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".zip")) {
                ids.add(detail.getId());
                continue;
            }
            String serialNo = detail.getFileLink();
            bankReceiptRequest.setRequestStr(serialNo);
            ReceiptResultQueryImpl accountReceiptQuery = new ReceiptResultQueryImpl();
            BankReceiptResponseEB bankReceiptResponseEB = (BankReceiptResponseEB)accountReceiptQuery.doBiz((BankRequest)bankReceiptRequest);
            String filePath = (String)bankReceiptResponseEB.getData();
            if (EBGStringUtils.isEmpty((String)filePath)) {
                logger.info("srv194_queryReceiptOrder\u63a5\u53e3\u8fd4\u56de\u7684WJDZ\u5b57\u6bb5\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8054\u7cfb\u94f6\u884c\u6392\u67e5");
                continue;
            }
            String url = urlPre + filePath;
            String fileName = detail.getFileName();
            if (url.contains("HTTPS")) {
                RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"HTTPS");
            } else {
                RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"HTTP");
            }
            logger.info("\u7b2c\u4e00\u79cd\u65b9\u5f0f\u4e0b\u8f7d------GET");
            DownloadUtils.download((String)url, (String)fileName, (String)bakFilePath);
            File zipName = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
            if (!zipName.exists()) {
                logger.info("\u5b81\u6ce2\u94f6\u884c\u673a\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d-{}-{}-\u56de\u5355\u6587\u4ef6\u540d\uff1a{}-\u8bf7\u6c42\u5730\u5740\uff1a{} \u538b\u7f29\u5305\u4e0d\u5b58\u5728", new Object[]{accNo, transDateStr, fileName, url});
            }
            if (!GZFileUtils.unZipFiles((String)(bakFilePath + File.separator + fileName), (String)bakFilePath)) continue;
            File file = FileCommonUtils.getFileByPath((String)bakFilePath);
            String unZipFilePath = bakFilePath + File.separator + fileName.replace(".zip", "");
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory() || file2.listFiles().length <= 0) continue;
                unZipFilePath = file2.getPath();
            }
            String fileNamePath = bakFilePath + File.separator + "receipt.txt";
            File receiptTxtFile = FileCommonUtils.getFileByPath((String)fileNamePath);
            if (receiptTxtFile.exists()) {
                unZipFilePath = bakFilePath;
            }
            List<Map<String, String>> receiptDetail = BankReceiptDownloadImpl.parseFileContent(unZipFilePath);
            for (Map<String, String> map : receiptDetail) {
                String receiptName = map.get("fileName");
                String newFileName = accNo + "_" + transDate + "_" + map.get("receiptNo") + "_" + map.get("amount") + "_" + map.get("seqNum") + ".pdf";
                File receiptFile = FileCommonUtils.getFileByPath((String)(unZipFilePath + File.separator + receiptName));
                if (receiptFile.exists()) {
                    DownloadListDetail receiptInfo = new DownloadListDetail();
                    receiptInfo.setFileLink(serialNo);
                    receiptInfo.setFileName(newFileName);
                    result.add(receiptInfo);
                    boolean isMove = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)newFileName);
                    logger.info("\u6587\u4ef6\uff1a{} \u91cd\u547d\u540d\uff1a{} \u662f\u5426\u6210\u529f\uff1a{}", new Object[]{receiptName, newFileName, isMove});
                    continue;
                }
                logger.info("\u538b\u7f29\u5305\u4e2d\u4e0d\u5305\u542b\u6587\u4ef6\u540d\uff1a{}\u7684\u6587\u4ef6\uff0c\u4f46\u662f\u6982\u8981\u6587\u4ef6\u4e2d\u6709\u8be5\u56de\u5355\u6587\u4ef6\u7684\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u63a8\u9001\u8be5\u6587\u4ef6\u540d\u7684\u6587\u4ef6\uff01");
            }
            boolean bl = zipName.delete();
            logger.info("\u8d26\u53f7\uff1a{}-\u65e5\u671f\uff1a{}-\u56de\u5355\u6587\u4ef6\uff1a{} \u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{accNo, transDateStr, fileName, bl});
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]));
        }
        if (!ids.isEmpty()) {
            this.downloadListDetailService.deleteAll(ids);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public static List<Map<String, String>> parseFileContent(String bakFilePath) {
        String storageRootPath;
        String fileNamePath = bakFilePath + File.separator + "receipt.txt";
        if (!fileNamePath.startsWith(storageRootPath = FileCommonUtils.checkPath((String)System.getProperty("user.dir")))) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u8bbf\u95ee\u8def\u5f84\uff1a%s", (String)"BankReceiptDownloadImpl_8", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), storageRootPath));
        }
        File file = FileCommonUtils.getFileByPath((String)fileNamePath);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(16);
        if (file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);
                 InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                 BufferedReader br = new BufferedReader(isr);){
                String fileContent = "";
                while ((fileContent = br.readLine()) != null) {
                    logger.info(fileContent);
                    String fileName = fileContent.split("@\\\\\\|")[11];
                    String amount = fileContent.split("@\\\\\\|")[3];
                    String account = fileContent.split("@\\\\\\|")[6];
                    String reciptNo = fileContent.split("@\\\\\\|")[10];
                    String transType = fileContent.split("@\\\\\\|")[9];
                    String seqNum = fileContent.split("@\\\\\\|")[0];
                    transType = EBGStringUtils.isNotEmpty((String)transType) ? (transType.equals(PropertiesConstantsUtils.getValue((String)"REFERENCE_RELEASE")) ? "C" : (transType.equals(PropertiesConstantsUtils.getValue((String)"TRANSFER_WITHDRAWAL")) ? "D" : "UNKONW")) : "UNKONW";
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("fileName", fileName);
                    map.put("amount", amount);
                    map.put("account", account);
                    map.put("receiptNo", reciptNo);
                    map.put("transType", transType);
                    map.put("seqNum", seqNum);
                    list.add(map);
                }
                logger.info("\u8bfb\u53d6\u6982\u8981\u6587\u4ef6" + file.getName() + "\u5b8c\u6210");
            }
            catch (Exception e) {
                logger.info("\u5b81\u6ce2\u94f6\u884c\u89e3\u6790\u56de\u5355\u6982\u8981\u6587\u4ef6\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002{}", (Object)e.getMessage());
                throw new ReceiptException(ResManager.loadKDString((String)"\u6267\u884c\u83b7\u53d6\u89e3\u6790\u56de\u5355\u6982\u8981\u6587\u4ef6\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), (Throwable)e);
            }
            boolean isDelete = file.delete();
            if (isDelete) {
                logger.info("\u6982\u8981\u6587\u4ef6" + file + "\u5220\u9664\u6210\u529f");
            }
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6982\u8981\u6587\u4ef6%s\u4e0d\u5b58\u5728\u3002\u8bf7\u548c\u94f6\u884c\u786e\u8ba4\u63a8\u9001\u8def\u5f84\uff0c\u548c\u94f6\u884c\u662f\u5426\u63a8\u9001\u6587\u4ef6\u3002", (String)"BankReceiptDownloadImpl_9", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), file));
        }
        return list;
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "NBCB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_6", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]);
    }
}

