/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbcb.dc.services.receipt.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.nbcb.dc.services.NBCBEBankDataHelper;
import kd.ebg.receipt.banks.nbcb.dc.services.login.LoginAndOut;
import kd.ebg.receipt.banks.nbcb.dc.services.sign.SignService;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class ReceiptResultQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptResultQueryImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String sessionId = LoginAndOut.getLoginAndOut().loginSessionId4Query();
        String userID = RequestContextUtils.getBankParameterValue((String)"userID");
        String serialNo = bankReceiptRequest.getRequestStr();
        String requestStr = ReceiptResultQueryImpl.receiptDownloadPack(userID, sessionId, serialNo);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String detailPars = this.receiptDownloadPars(responseStr);
        return BankReceiptResponseEB.success((Object)detailPars);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "srv194_queryReceiptOrder";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u751f\u6210\u7ed3\u679c\u67e5\u8be2", (String)"ReceiptResultQueryImpl_0", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]);
    }

    public static String receiptDownloadPack(String userID, String sessionId, String serialNo) {
        Element root = ReceiptResultQueryImpl.getRoot(userID, sessionId, "srv194_queryReceiptOrder", "02", "receiptDownload");
        Element opReq = JDomUtils.addChild((Element)root, (String)"opReq");
        String serialNoNew = Sequence.gen16Sequence();
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNoNew);
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"JYXH", (String)serialNo);
        String signData = SignService.sign(opReq);
        JDomUtils.addChild((Element)root, (String)"signData", (String)signData);
        return JDomUtils.doc2Str((Document)new Document(root), (String)"", (String)"UTF-8", (boolean)false);
    }

    private static Element getRoot(String userID, String sessionId, String serviceId, String functionId, String functionName) {
        Element root = JDomExtUtils.createRoot((String)"NBCBEBankData");
        JDomUtils.addChild((Element)root, (String)"sessionId", (String)sessionId);
        JDomUtils.addChild((Element)root, (String)"serviceId", (String)serviceId);
        JDomUtils.addChild((Element)root, (String)"customerId", (String)userID);
        JDomUtils.addChild((Element)root, (String)"softwareId", (String)"002");
        JDomUtils.addChild((Element)root, (String)"functionId", (String)functionId);
        JDomUtils.addChild((Element)root, (String)"functionName", (String)functionName);
        return root;
    }

    public String receiptDownloadPars(String response) {
        if ("".equals(response)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u94f6\u884c\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a%s", (String)"ReceiptResultQueryImpl_5", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), this.getBizCode()));
        }
        Element root = JDomUtils.str2DocUTF8((String)response).getRootElement();
        String retCode = JDomUtils.getUnNullChildText((Element)root, (String)"retCode");
        String errorMsg = JDomUtils.getUnNullChildText((Element)root, (String)"errorMsg");
        if ("0000".equals(retCode) || "000000".equals(retCode)) {
            Element opRep = JDomUtils.getUnNullChildElement((Element)root, (String)"opRep");
            Element opResult = JDomUtils.getUnNullChildElement((Element)opRep, (String)"opResult");
            String ZLZT = JDomUtils.getUnNullChildText((Element)opResult, (String)"ZLZT");
            String WJDZ = JDomUtils.getUnNullChildText((Element)opResult, (String)"WJDZ");
            if ("0".equalsIgnoreCase(ZLZT)) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u5df2\u53d1\u8d77\u56de\u5355\u6587\u4ef6\u751f\u6210\u8bf7\u6c42\uff0c\u94f6\u884c\u5904\u7406\u4e2d\u3002", (String)"ReceiptResultQueryImpl_2", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]));
            }
            if ("2".equalsIgnoreCase(ZLZT)) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u751f\u6210\u72b6\u6001\u67e5\u8be2\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a%s\u3002", (String)"ReceiptResultQueryImpl_6", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), retCode) + String.format(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"ReceiptResultQueryImpl_7", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), errorMsg));
            }
            return WJDZ;
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u751f\u6210\u72b6\u6001\u67e5\u8be2\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a%s\u3002", (String)"ReceiptResultQueryImpl_6", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), retCode) + String.format(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"ReceiptResultQueryImpl_7", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), errorMsg));
    }

    public void configFactory(ConnectionFactory factory) {
        NBCBEBankDataHelper.configConnection(factory);
    }
}

