/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zzb.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLogin = request.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"ZZB_DC", (String)accNo, (String)transDateStr);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp();
        }
        boolean isLastFile = false;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            boolean flag;
            DownloadListDetail detail = (DownloadListDetail)downloadListDetails.get(i);
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            if (!(flag = this.download(detail, bakFilePath, isLastFile, bankFtpProperties, sftp))) continue;
            result.add(detail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String destFolder, boolean isLastFile, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        String localDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        boolean result = false;
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        if (fileName != null && fileName.length() > 0) {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                String ftpPath = bankFtpProperties.getFtpPath();
                ftpPath = StringUtils.isEmpty((String)ftpPath) ? "/" + localDate : ftpPath + "/" + localDate;
                result = this.ftpDownload(destFolder, fileName, isLastFile, ftpPath, newFileName, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                String ftpPath = bankFtpProperties.getFrontProxyPath();
                ftpPath = StringUtils.isEmpty((String)ftpPath) ? "/" + localDate : ftpPath + "/" + localDate;
                result = this.localDownload(ftpPath, destFolder, fileName, detail.getAccNo(), detail.getTransDate());
                File file = FileCommonUtils.getFileByPath((String)(destFolder + File.separator + fileName));
                if (file.exists()) {
                    FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newFileName);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ftpDownload(String destFolder, String orgFileName, boolean isLastFile, String ftpPath, String newFileName, ChannelSftp sftp) {
        boolean result;
        logger.info("\u4e0b\u8f7d\u90d1\u5dde\u94f6\u884c\u6587\u4ef6\u540d\uff1a" + orgFileName);
        try {
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            result = SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
            File file = FileCommonUtils.getFileByPath((String)(destFolder + File.separator + orgFileName));
            if (file.exists()) {
                FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newFileName);
            }
        }
        catch (Exception e) {
            result = false;
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u540d\uff1a" + orgFileName, new Object[]{e.getMessage()});
        }
        finally {
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
        return result;
    }

    private boolean localDownload(String ftpPath, String savePath, String orgFileName, String accNo, LocalDate transDate) {
        logger.info("\u4e0b\u8f7d\u90d1\u5dde\u94f6\u884c\u6587\u4ef6\u540d\uff1a" + orgFileName);
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, orgFileName, savePath);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ZZB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u90d1\u5dde\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-zzb-dc", (Object[])new Object[0]);
    }
}

