/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hzyq.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long taskId = request.getTaskId();
        String bankLogin = request.getBankLoginId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp") && SFTPUtils.getInstance().isAbort(sftp)) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        boolean isLastFile = false;
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
            result.addAll(this.download(downloadListDetail, bakFilePath, bankLogin, isLastFile, sftp, bankFtpProperties));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, String destFolder, String bankLogin, boolean isLastFile, ChannelSftp sftp, BankFtpProperties bankFtpProperties) {
        String accNo = detail.getAccNo();
        String accNoInEndFour = accNo.substring(accNo.length() - 4);
        LocalDate transDate = detail.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate, (String)"yyyyMMdd");
        String sftp_path = bankFtpProperties.getFtpPath();
        sftp_path = StringUtils.isEmpty((String)sftp_path) ? "/" : sftp_path;
        String newFileName = detail.getFileLink();
        ArrayList<DownloadListDetail> downloadListDetailList = new ArrayList<DownloadListDetail>(16);
        File oldZipFile = FileCommonUtils.getFileByPath((String)(destFolder + File.separator + newFileName));
        boolean result = false;
        if (!oldZipFile.exists()) {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                }
                result = SFTPUtils.getInstance().downloadSingleFile(sftp_path, detail.getFileLink(), destFolder, sftp);
                if (isLastFile) {
                    SFTPUtils.getInstance().close(sftp);
                }
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                String receiptPath = bankFtpProperties.getFrontProxyPath();
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                result = bankReceiptApiUtil.downloadReceiptFileWithPath(receiptPath, detail.getFileLink(), destFolder);
            }
        } else {
            result = true;
        }
        if (result) {
            RequestContextUtils.setZipName((String)newFileName);
            String zipPath = destFolder + File.separator + newFileName;
            String tempPath = destFolder + File.separator + "temp";
            if (GZFileUtils.unZipFiles((String)zipPath, (String)tempPath)) {
                File[] listFiles;
                File unZipFile = FileCommonUtils.getFileByPath((String)tempPath);
                for (File file : listFiles = unZipFile.listFiles()) {
                    logger.info("\u676d\u5dde\u94f6\u884c-{}-{}-\u56de\u5355\u538b\u7f29\u5305\u76ee\u5f55\u7ed3\u6784\uff1a{}", new Object[]{accNo, transDateStr, file.getPath()});
                    if (file.isDirectory()) {
                        File[] receiptFiles;
                        for (File receiptFile : receiptFiles = file.listFiles()) {
                            logger.info("\u676d\u5dde\u94f6\u884c-{}-{}-\u56de\u5355\u538b\u7f29\u5305\u76ee\u5f55\u7ed3\u6784\uff1a{}", new Object[]{accNo, transDateStr, file.getPath()});
                            this.parseReceiptFile(destFolder, accNo, transDateStr, newFileName, downloadListDetailList, receiptFile);
                        }
                        continue;
                    }
                    this.parseReceiptFile(destFolder, accNo, transDateStr, newFileName, downloadListDetailList, file);
                }
            }
        }
        return downloadListDetailList;
    }

    public void parseReceiptFile(String destFolder, String accNo, String transDateStr, String newFileName, List<DownloadListDetail> downloadListDetailList, File file) {
        if (file.getName().endsWith(".pdf")) {
            String fileName = file.getName();
            String receiptNo = fileName.split("_")[2];
            StringBuilder newReceiptFileName = new StringBuilder();
            newReceiptFileName.append(accNo).append("_").append(transDateStr).append("_").append(receiptNo).append(".pdf");
            boolean isMove = FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newReceiptFileName.toString());
            if (isMove) {
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileLink(newFileName);
                downloadListDetail.setFileName(newReceiptFileName.toString());
                downloadListDetailList.add(downloadListDetail);
            }
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "HZYQ_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u676d\u5dde\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]);
    }
}

