/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hzyq.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.hzyq.dc.service.receipt.utils.TCommon;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class BankReceiptQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptQueryImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String compFlowNo = request.getRequestStr();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate, (String)"yyyy-MM-dd");
        Element root = new Element("body");
        Element head = BankReceiptQueryImpl.createHZYQRoot("BY0010");
        Element loopData = new Element("loopData");
        Element map = new Element("map");
        JDomUtils.addChild((Element)map, (String)"compFlowNo", (String)compFlowNo);
        JDomUtils.addChild((Element)map, (String)"beginDate", (String)transDateStr);
        JDomUtils.addChild((Element)map, (String)"endDate", (String)transDateStr);
        Element row = new Element("row");
        JDomUtils.addChild((Element)row, (String)"bankAcc", (String)accNo);
        JDomUtils.addChild((Element)loopData, (Element)row);
        JDomUtils.addChild((Element)root, (Element)head);
        JDomUtils.addChild((Element)root, (Element)map);
        JDomUtils.addChild((Element)root, (Element)loopData);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String rspMsg = BankReceiptQueryImpl.headNumber("BY0010") + RspMsg;
        String requestStr = TCommon.createCommonMsg(rspMsg);
        logger.info("\u676d\u5dde\u94f6\u884c\u56de\u5355\u4fe1\u606f\u67e5\u8be2(BY0010) \u8bf7\u6c42\uff1a{}", (Object)rspMsg);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        logger.info("\u676d\u5dde\u94f6\u884c\u56de\u5355\u5355\u7b14\u4fe1\u606f\u67e5\u8be2(BY0010) \u54cd\u5e94\uff1a{}", (Object)responseStr);
        return BankReceiptResponseEB.success((Object)BankReceiptQueryImpl.receiptResponse(responseStr, request));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BY0010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u676d\u5dde\u94f6\u884c\u56de\u5355\u4fe1\u606f\u67e5\u8be2\u8bf7\u6c42", (String)"BankReceiptQueryImpl_0", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String uri = "";
        try {
            uri = RequestContextUtils.getBankParameterValue((String)"uri");
        }
        catch (Exception e) {
            logger.error("\u676d\u5dde\u94f6\u4f01\u83b7\u53d6uri\u5f02\u5e38", (Throwable)e);
        }
        logger.info("\u676d\u5dde\u8d22\u653f\u7cfb\u7edfURI\u8def\u5f84:{}", (Object)uri);
        factory.setUri(uri);
        factory.setHttpHeader("Content-Type", "application/xml");
    }

    public static Element createHZYQRoot(String tradeName) throws EBServiceException {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"erpSysCode", (String)RequestContextUtils.getBankParameterValue((String)"erpSysCode"));
        JDomUtils.addChild((Element)head, (String)"custNo", (String)RequestContextUtils.getBankParameterValue((String)"custNo"));
        JDomUtils.addChild((Element)head, (String)"tradeName", (String)tradeName);
        return head;
    }

    public static String headNumber(String tradeName) {
        int i = 2;
        String lx = tradeName.substring(tradeName.length() - i, tradeName.length());
        return lx + tradeName;
    }

    public static String receiptResponse(String response, BankReceiptRequest request) {
        if (response == null || response.trim().length() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"BankReceiptQueryImpl_1", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]));
        }
        Element root = JDomUtils.str2DocGBK((String)response).getRootElement();
        Element head = JDomUtils.getUnNullChildElement((Element)root, (String)"head");
        String retCode = JDomUtils.getUnNullChildText((Element)head, (String)"retCode");
        String retMsg = JDomUtils.getUnNullChildText((Element)head, (String)"retMsg");
        String compFlowNo = request.getRequestStr();
        if ("0".equalsIgnoreCase(retCode)) {
            Element map = JDomUtils.getUnNullChildElement((Element)root, (String)"map");
            String totalNum = JDomUtils.getUnNullChildText((Element)map, (String)"recordTotal");
            logger.info("\u676d\u5dde\u94f6\u884c\u672c\u6b21\u83b7\u53d6\u56de\u5355\u6570\u91cf\uff1a" + totalNum);
            Element loopData = JDomUtils.getUnNullChildElement((Element)root, (String)"loopData");
            List rows = JDomExtUtils.getChildrenElement((Element)loopData, (String)"row");
            for (Element e : rows) {
                String[] strings;
                String orderSTT = JDomUtils.getUnNullChildText((Element)e, (String)"orderSTT");
                String orderSRR = JDomUtils.getUnNullChildText((Element)e, (String)"orderSRR");
                if (!Objects.equals(orderSTT, "9") && !Objects.equals(orderSTT, "91")) continue;
                if (StringUtils.isNotEmpty((String)orderSRR) && orderSRR.contains(PropertiesConstantsUtils.getValue((String)"HZYQ_RECEIPT_EXIST_SERIAL")) && (strings = orderSRR.split(PropertiesConstantsUtils.getValue((String)"HZYQ_RECEIPT_EXIST_SERIAL") + ":")).length > 1) {
                    compFlowNo = strings[1].substring(1, strings[1].indexOf("]"));
                    return compFlowNo;
                }
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u5904\u7406\u5931\u8d25\uff0c\u94f6\u884c\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\u7801\u4e3a[%1$s]\uff0c\u54cd\u5e94\u8bf4\u660e\u4e3a\uff1a[%2$s]\u3002", (String)"BankReceiptQueryImpl_8", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]), orderSTT, orderSRR));
            }
            return compFlowNo;
        }
        if ("9".equalsIgnoreCase(retCode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u901a\u8baf\u8d85\u65f6\u6216\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"BankReceiptQueryImpl_9", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]), retCode, retMsg));
        }
        if ("2".equalsIgnoreCase(retCode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"BankReceiptQueryImpl_10", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]), retCode, retMsg));
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"BankReceiptQueryImpl_10", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]), retCode, retMsg));
    }
}

