/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdcb.cms.service.api;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cdcb.cms.utils.Packer;
import kd.ebg.receipt.banks.cdcb.cms.utils.Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfoList = new ArrayList(8);
        this.setCurrentPage("1");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse bizRsp = this.doBiz(request);
            detailInfoList.addAll(bizRsp.getDetails());
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    public String pack(BankDetailRequest request) {
        Element ap = Packer.creatHead("03020101A0007", Sequence.gen18Sequence());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"currency", (String)request.getAcnt().getCurrency());
        JDomUtils.addChild((Element)body, (String)"startDate", (String)LocalDateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)LocalDateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"start", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"size", (String)"20");
        String msg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return Packer.createCommonMsg(msg);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        this.setLastPage(true);
        Element element = Parser.getResponseElement(responseStr);
        Parser.resSuccessCheck(element);
        Element body = element.getChild("body");
        this.setLastPage(this.isLastPage(body));
        this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 20);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element array = body.getChild("array");
        List dtoList = array.getChildren("dto");
        String accNo = request.getAcnt().getAccNo();
        LocalDate startDate = request.getStartDate();
        String transDate = startDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        for (Element dto : dtoList) {
            DetailInfo detailInfo = new DetailInfo();
            StringBuilder fileName = new StringBuilder();
            String hostSerialNo = dto.getChildTextTrim("hostSerialNo");
            fileName.append(accNo).append("_").append(transDate).append("_").append(hostSerialNo).append(".pdf");
            detailInfo.setReceiptNo(hostSerialNo);
            detailInfo.setUniqueSeq(fileName.toString());
            detailList.add(detailInfo);
        }
        log.info("\u8fd4\u56de\u4ea4\u6613\u660e\u7ec6{}\u6761", (Object)detailList.size());
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "03020101A0007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-receipt-banks-cdcb-cms", (Object[])new Object[0]);
    }

    public boolean isLastPage(Element body) {
        int sizeCount;
        String total = body.getChildText("total");
        if (StrUtil.isEmpty((String)total)) {
            return true;
        }
        int totalCount = Integer.parseInt(total);
        int startCount = Integer.parseInt(this.getCurrentPage());
        return startCount + (sizeCount = 20) - 1 >= totalCount;
    }
}

