/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.eves.dc.receipt.helper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class GmUtil {
    private static X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static ECDomainParameters ecDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static final int RS_LEN = 32;
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER;

    public static byte[] signSm3WithSm2(byte[] msg, byte[] userId, PrivateKey privateKey) {
        return GmUtil.rsAsn1ToPlainByteArray(GmUtil.signSm3WithSm2Asn1Rs(msg, userId, privateKey));
    }

    public static byte[] signSm3WithSm2Asn1Rs(byte[] msg, byte[] userId, PrivateKey privateKey) {
        try {
            SM2ParameterSpec parameterSpec = new SM2ParameterSpec(userId);
            Signature signer = Signature.getInstance("SM3withSM2", "BC");
            signer.setParameter((AlgorithmParameterSpec)parameterSpec);
            signer.initSign(privateKey, new SecureRandom());
            signer.update(msg, 0, msg.length);
            byte[] sig = signer.sign();
            return sig;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifySm3WithSm2(byte[] msg, byte[] userId, byte[] rs, PublicKey publicKey) {
        if (rs == null || msg == null || userId == null) {
            return false;
        }
        if (rs.length != 64) {
            return false;
        }
        return GmUtil.verifySm3WithSm2Asn1Rs(msg, userId, GmUtil.rsPlainByteArrayToAsn1(rs), publicKey);
    }

    public static boolean verifySm3WithSm2Asn1Rs(byte[] msg, byte[] userId, byte[] rs, PublicKey publicKey) {
        try {
            SM2ParameterSpec parameterSpec = new SM2ParameterSpec(userId);
            Signature verifier = Signature.getInstance("SM3withSM2", "BC");
            verifier.setParameter((AlgorithmParameterSpec)parameterSpec);
            verifier.initVerify(publicKey);
            verifier.update(msg, 0, msg.length);
            return verifier.verify(rs);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static byte[] bigIntToFixexLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange((byte[])rs, (int)1, (int)33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill((byte[])result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new RuntimeException("err rs: " + Hex.toHexString((byte[])rs));
    }

    private static byte[] rsAsn1ToPlainByteArray(byte[] rsDer) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)rsDer);
        byte[] r = GmUtil.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue());
        byte[] s = GmUtil.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    private static byte[] rsPlainByteArrayToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new RuntimeException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)0, (int)32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)32, (int)64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance("EC", "BC");
            kpGen.initialize((AlgorithmParameterSpec)ecParameterSpec, new SecureRandom());
            KeyPair kp = kpGen.generateKeyPair();
            return kp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BCECPrivateKey getPrivatekeyFromD(BigInteger d) {
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        return new BCECPrivateKey("EC", ecPrivateKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static BCECPublicKey getPublickeyFromXY(BigInteger x, BigInteger y) {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), ecParameterSpec);
        return new BCECPublicKey("EC", ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static void main(String[] args) throws Exception, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CertPathBuilderException, InvalidKeyException, SignatureException, CertificateException {
        KeyPair kp = GmUtil.generateKeyPair();
        System.out.println("private:" + Hex.toHexString((byte[])kp.getPrivate().getEncoded()));
        System.out.println("public:" + Hex.toHexString((byte[])kp.getPublic().getEncoded()));
        System.out.println("private key d: " + ((BCECPrivateKey)kp.getPrivate()).getD());
        String hexPrivateKey = Hex.toHexString((byte[])((BCECPrivateKey)kp.getPrivate()).getD().toByteArray());
        System.out.println("private key: " + hexPrivateKey);
        System.out.println("public key q:" + ((BCECPublicKey)kp.getPublic()).getQ());
        BigInteger d = new BigInteger(hexPrivateKey, 16);
        BCECPrivateKey PrivateKey1 = GmUtil.getPrivatekeyFromD(d);
        System.out.println("public key X:" + ((BCECPublicKey)kp.getPublic()).getQ().getXCoord());
        System.out.println("public key Y:" + ((BCECPublicKey)kp.getPublic()).getQ().getYCoord());
        System.out.println("public key(X+Y) :" + ((BCECPublicKey)kp.getPublic()).getQ().getXCoord() + ((BCECPublicKey)kp.getPublic()).getQ().getYCoord());
        byte[] msg = "message digest".getBytes();
        byte[] userId = "1234567812345678".getBytes();
        String privateKeyStr = "MIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgOSVcSnF/EA/H4GjyCa+e4FwYIPhUV8sgWiqVivbBXyOgCgYIKoEcz1UBgi2hRANCAAQvUekZKFCRbDF4r/vvUKMMFu6ObfZQV1C7q0S7Cyhx/jEMys1MrIGROSxIMt52oLy5rg8oYnyf4I3QhhdvIojo";
        privateKeyStr = privateKeyStr.replaceAll("-----BEGIN PRIVATE KEY-----", "");
        privateKeyStr = privateKeyStr.replaceAll("-----END PRIVATE KEY-----", "");
        privateKeyStr = privateKeyStr.replaceAll("\r", "");
        privateKeyStr = privateKeyStr.replaceAll("\n", "");
        PrivateKey privatekeyFromD = GmUtil.privateKeyFromBytes(Base64.decode((String)privateKeyStr));
        byte[] signSm3WithSm2 = GmUtil.signSm3WithSm2(msg, userId, privatekeyFromD);
        System.out.println("sign:" + Hex.toHexString((byte[])signSm3WithSm2));
        String publicKeyStr = "-----BEGIN CERTIFICATE-----\nMIIC+zCCAp6gAwIBAgIFQFeTIkIwDAYIKoEcz1UBg3UFADBhMQswCQYDVQQGEwJD\nTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9y\naXR5MSAwHgYDVQQDDBdDRkNBIEFDUyBURVNUIFNNMiBPQ0EzMTAeFw0yMzA2MTkw\nNzI3NDNaFw0yNjA2MTkwNzI3NDNaMIGlMQswCQYDVQQGEwJDTjEgMB4GA1UECgwX\nQ0ZDQSBBQ1MgVEVTVCBTTTIgT0NBMzExDjAMBgNVBAsMBU5GUk1DMRkwFwYDVQQL\nDBBPcmdhbml6YXRpb25hbC0yMUkwRwYDVQQDDEBORlJNQ0Dph5Honbbova/ku7bv\nvIjkuK3lm73vvInmnInpmZDlhazlj7hATjkxNDQwMzAwNjE4ODM5MjU0MEAxMFkw\nEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEL1HpGShQkWwxeK/771CjDBbujm32UFdQ\nu6tEuwsocf4xDMrNTKyBkTksSDLedqC8ua4PKGJ8n+CN0IYXbyKI6KOB+zCB+DA/\nBggrBgEFBQcBAQQzMDEwLwYIKwYBBQUHMAGGI2h0dHA6Ly9vY3NwdGVzdC5jZmNh\nLmNvbS5jbjo4MC9vY3NwMB8GA1UdIwQYMBaAFATHvPlZAWk+jDQ2IGIYPN68tbsM\nMAwGA1UdEwEB/wQCMAAwOAYDVR0fBDEwLzAtoCugKYYnaHR0cDovLzIxMC43NC40\nMi4zL09DQTMxL1NNMi9jcmwyMTcuY3JsMA4GA1UdDwEB/wQEAwIGwDAdBgNVHQ4E\nFgQUoF+ajwxXGX3ZaxYMNn3XciAqjxgwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsG\nAQUFBwMEMAwGCCqBHM9VAYN1BQADSQAwRgIhAPTzlCHNtgdp5ok5a2Fh1Kp54FsF\naL6ltHK2CRVkn6cSAiEAx15e3svxd4WbF9gnj5CRaUfQZW+Xx/Ff6myYrt/s5lk=\n-----END CERTIFICATE-----";
        PublicKey publicKey = GmUtil.fileToCertificate(publicKeyStr.getBytes());
        String base64String = Base64.toBase64String((byte[])signSm3WithSm2);
        System.out.println("verifsign:" + GmUtil.verifySm3WithSm2(msg, userId, Base64.decode((String)base64String), publicKey));
    }

    public static PrivateKey privateKeyFromBytes(byte[] pkcs8key) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        Security.addProvider((Provider)BOUNCY_CASTLE_PROVIDER);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pkcs8key);
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static PublicKey fileToCertificate(byte[] fileByte) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileByte);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate ca = (X509Certificate)certFactory.generateCertificate(inputStream);
        PublicKey publicKey = ca.getPublicKey();
        return publicKey;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();
    }
}

