/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.abc.dc.service.receipt.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.PDFFilter;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class ReceiptFileConvertUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFileConvertUtils.class);

    public static String fixAccNoTo15Or19(String accNo) {
        String retAccNo = null;
        if (null != accNo) {
            String str2 = accNo.trim();
            retAccNo = str2.length() == 19 ? accNo : (str2.length() == 21 ? str2.substring(2) : ReceiptFileConvertUtils.getLastNString(str2, 15));
        }
        return retAccNo;
    }

    private static String getLastNString(String accNo, int count) {
        String str = accNo;
        if (accNo.length() > count) {
            int i = accNo.length() - count;
            str = accNo.substring(i);
        }
        return str;
    }

    public static List<File> getReceiptFileByAccNoAndAreaCode(String accNo, String transDateStr, String parentPath, String fileType, boolean isPushedFromMaster) {
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        String areaCode = mainAcnt.getAreaCode();
        PDFFilter filter = new PDFFilter(accNo, transDateStr, fileType);
        ArrayList<File> files = new ArrayList<File>(1);
        if (!isPushedFromMaster) {
            File parentFile = FileCommonUtils.getFileByPath((String)parentPath);
            return ReceiptFileConvertUtils.getReceiptFileByFilter(parentFile, filter);
        }
        File accNoPathFile = FileCommonUtils.getFileByPath((String)(parentPath + File.separator + accNo));
        if (accNoPathFile.exists() && accNoPathFile.isDirectory()) {
            logger.info("\u5f55\u5165\u7684\u8d26\u53f7\u5305\u542b\u5730\u533a\u7801");
            return ReceiptFileConvertUtils.getReceiptFileByFilter(accNoPathFile, filter);
        }
        File accNoAndAreaCodePathFile = FileCommonUtils.getFileByPath((String)(parentPath + File.separator + areaCode + accNo));
        if (accNoAndAreaCodePathFile.exists() && accNoAndAreaCodePathFile.isDirectory()) {
            logger.info("\u5f55\u5165\u7684\u8d26\u53f7\u4e0d\u5305\u542b\u5730\u533a\u7801");
            return ReceiptFileConvertUtils.getReceiptFileByFilter(accNoAndAreaCodePathFile, filter);
        }
        return files;
    }

    public static List<File> getReceiptFileByFilter(File parentFile, PDFFilter filter) {
        ArrayList<File> files = new ArrayList<File>(1);
        File[] receiptFiles = parentFile.listFiles(filter);
        if (receiptFiles != null && receiptFiles.length > 0) {
            return Arrays.asList(receiptFiles);
        }
        return files;
    }

    public static List<DownloadListDetail> handReceiptList(List<File> receiptFiles, String bakPath) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        String parentPath = "";
        for (File file : receiptFiles) {
            if (EBGStringUtils.isEmpty((String)parentPath)) {
                parentPath = file.getParent();
            }
            if (!FileCommonUtils.moveFile((File)file, (String)bakPath, (String)file.getName())) continue;
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileName(file.getName());
            detail.setFileLink(file.getName());
            result.add(detail);
        }
        if (result.size() > 0) {
            FileCommonUtils.getFileByPath((String)parentPath).delete();
        }
        return result;
    }
}

