/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzc.dc.services.receipt;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.gzc.dc.constants.Constants;
import kd.ebg.receipt.banks.gzc.dc.services.detail.DetailImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    private String reciptTypeList;
    public DownloadListDetailService downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        List<DetailInfo> detailInfos = BankReceiptFetchListImpl.getDetailList(accNo, transDate);
        if (detailInfos.size() == 0) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff1a\u67e5\u8be2\u65e5\u671f[%s]\u7684\u4ea4\u6613\u660e\u7ec6\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]), transDate));
        }
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        for (DetailInfo detail : detailInfos) {
            String TransSeq = detail.getPayBankDetailSeqID();
            String DcFlag = detail.getExplanation();
            String amount = detail.getUseCN();
            String oppAccNo = detail.getOppAccNo();
            String fileName = accNo + Constants.RECEIPTSEPERATOR + transDateStr + Constants.RECEIPTSEPERATOR + TransSeq + Constants.RECEIPTSEPERATOR + DcFlag + Constants.RECEIPTSEPERATOR + amount + Constants.RECEIPTSEPERATOR + oppAccNo + ".pdf";
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("TransSeq", (Object)TransSeq);
            jsonObject.put("DcFlag", (Object)DcFlag);
            jsonObject.put("fileName", (Object)fileName);
            downloadListDetail.setFileName(fileName);
            downloadListDetail.setFileLink(jsonObject.toJSONString());
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public static List<DetailInfo> getDetailList(String accNo, LocalDate transDate) {
        DetailImpl detail = new DetailImpl();
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setStartDate(transDate);
        request.setEndDate(transDate);
        EBBankDetailResponse ebBankDetailResponse = detail.detail(request);
        List detailInfos = ebBankDetailResponse.getDetails();
        return detailInfos;
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "GZC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u8d63\u5dde\u94f6\u884c\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_3", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]);
    }
}

