/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.IWorksheets;
import com.grapecity.documents.excel.OpenFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.Tuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.TaskHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.helper.eas.EasReportHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BalanceCheckDataHelper {
    private static final Log logger = LogFactory.getLog(BalanceCheckDataHelper.class);

    public static DataSet jobSessionCommit(JobSession job, DataSetX allData) {
        RowMeta rowMeta = allData.getRowMeta();
        DataSetOutput out = new DataSetOutput(rowMeta);
        String id = out.getId();
        allData.output((Output)out);
        job.commit(30, TimeUnit.MINUTES);
        return job.readDataSet(id);
    }

    public static DataSet getGlBalanceDataSet(List<Field> fieldList, List<Map<String, Object>> dataList, Map<String, Tuple<String, Map<String, String>>> assistMap, Map<String, Map<String, Object>> accountInfoMap) throws IOException {
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"RulesParamData").createDataSetBuilder(rowMeta);
        int seq = 1;
        for (Map<String, Object> dataMap : dataList) {
            Map<String, Object> accountMap;
            String assgrpJson = "";
            String assgrpName = "";
            String assgrpId = dataMap.get("assgrp").toString();
            if (assistMap.get(assgrpId) != null) {
                Tuple<String, Map<String, String>> tuple = assistMap.get(assgrpId);
                assgrpJson = JSONUtils.toString((Object)tuple.item2);
                assgrpName = (String)tuple.item1;
            }
            if ((accountMap = accountInfoMap.get(dataMap.get("account").toString())) == null) continue;
            dataSetBuilder.append(new Object[]{seq++, dataMap.get("account"), accountMap.get("accountnumber"), accountMap.get("accountname"), accountMap.get("accountdc"), dataMap.get("assgrp"), assgrpJson, assgrpName, dataMap.get("beginfor"), dataMap.get("beginlocal"), dataMap.get("booktype"), dataMap.get("booktype.number"), dataMap.get("debitfor"), dataMap.get("debitlocal"), dataMap.get("creditfor"), dataMap.get("creditlocal"), dataMap.get("currency"), dataMap.get("currency.number"), dataMap.get("currency.name"), dataMap.get("endfor"), dataMap.get("endlocal"), dataMap.get("org"), dataMap.get("org.number"), dataMap.get("period"), dataMap.get("period.number"), dataMap.get("yeardebitfor"), dataMap.get("yeardebitlocal"), dataMap.get("yearcreditfor"), dataMap.get("yearcreditlocal")});
        }
        return dataSetBuilder.build();
    }

    public static long genLongId(String tableName) {
        return DB.genLongId((String)tableName);
    }

    public static boolean execute(DBRoute dbRoute, String sql, Object[] params) {
        return DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
    }

    public static int[] executeBatch(DBRoute dbRoute, String sql, List<Object[]> paramsList) {
        return DB.executeBatch((DBRoute)dbRoute, (String)sql, paramsList);
    }

    public static Map<String, Set<String>> getSheetNameMap(Map<String, List<Map<String, Object>>> attachmentMap) {
        HashMap<String, Set<String>> sheetNameMap = new HashMap<String, Set<String>>(attachmentMap.size());
        for (Map.Entry<String, List<Map<String, Object>>> map : attachmentMap.entrySet()) {
            List<Map<String, Object>> attachmentList = map.getValue();
            if (CollectionUtils.isEmpty(attachmentList)) continue;
            Map<String, Object> valuemap = attachmentList.get(0);
            String filename = (String)valuemap.get("name");
            String type = "\\." + (String)valuemap.get("type");
            filename = filename.split(type)[0];
            String relativeUrl = (String)valuemap.get("relativeUrl");
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                FileServiceFactory.getAttachmentFileService().download(relativeUrl, (OutputStream)outputStream, null);
                XSSFWorkbook xssfWorkbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                Throwable throwable = null;
                try {
                    int sheetNum = xssfWorkbook.getNumberOfSheets();
                    HashSet<String> sheetNameSet = new HashSet<String>(16);
                    for (int i = 0; i < sheetNum; ++i) {
                        boolean sheetHidden = xssfWorkbook.isSheetHidden(i);
                        if (sheetHidden) continue;
                        XSSFSheet sheetAt = xssfWorkbook.getSheetAt(i);
                        sheetNameSet.add(sheetAt.getSheetName());
                    }
                    sheetNameMap.put(map.getKey(), sheetNameSet);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (xssfWorkbook == null) continue;
                    if (throwable != null) {
                        try {
                            xssfWorkbook.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    xssfWorkbook.close();
                }
            }
            catch (Exception e) {
                logger.error(map.getKey(), (Throwable)e);
                throw new DmwBizException(map.getKey(), (Throwable)e);
            }
        }
        return sheetNameMap;
    }

    public static List<Map<Long, String>> getSpreadjsonList(String reportId, Map<String, List<Map<String, Object>>> attachmentMap, Map<Long, String> templateIdMap) throws IOException {
        List<Map<String, Object>> attachmentList = attachmentMap.get(reportId);
        Map<String, Object> valuemap = attachmentList.get(0);
        String filename = (String)valuemap.get("name");
        String type = "\\." + (String)valuemap.get("type");
        filename = filename.split(type)[0];
        String relativeUrl = (String)valuemap.get("relativeUrl");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileServiceFactory.getAttachmentFileService().download(relativeUrl, (OutputStream)outputStream, null);
        Workbook workbook = EasReportHelper.getWorkbook();
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(EasReportHelper.readExcel(new ByteArrayInputStream(outputStream.toByteArray())).toByteArray());){
            workbook.setEnableCalculation(false);
            workbook.open((InputStream)inStream, OpenFileFormat.Xlsx);
        }
        String workbookJson = workbook.toJson();
        IWorksheets worksheets = workbook.getWorksheets();
        ArrayList<Map<Long, String>> spreadjsonList = new ArrayList<Map<Long, String>>(templateIdMap.size());
        block9: for (Map.Entry<Long, String> mapEntry : templateIdMap.entrySet()) {
            for (IWorksheet worksheet : worksheets) {
                if (!mapEntry.getValue().equals(worksheet.getName())) continue;
                String json = BalanceCheckDataHelper.readWorkSheetJson(workbookJson, worksheet.getName());
                byte[] base64Byte = Base64.getEncoder().encode(BalanceCheckDataHelper.compressJson(json));
                HashMap<Long, String> spreadjsonMap = new HashMap<Long, String>(1);
                spreadjsonMap.put(mapEntry.getKey(), "base64" + new String(base64Byte, StandardCharsets.UTF_8));
                spreadjsonList.add(spreadjsonMap);
                continue block9;
            }
        }
        return spreadjsonList;
    }

    private static String readWorkSheetJson(String workBookJson, String sheetName) {
        JsonObject tmp = JsonParser.parseString((String)workBookJson).getAsJsonObject();
        tmp.addProperty("sheetCount", (Number)1);
        JsonObject sheets = tmp.getAsJsonObject("sheets");
        Set keySets = sheets.keySet();
        Iterator iterator = keySets.iterator();
        while (iterator.hasNext()) {
            String currentSheetName = (String)iterator.next();
            if (!sheetName.equalsIgnoreCase(currentSheetName)) {
                iterator.remove();
                continue;
            }
            sheets.getAsJsonObject(currentSheetName).addProperty("index", (Number)0);
        }
        return tmp.toString();
    }

    private static byte[] compressJson(String str) throws IOException {
        if (str != null && !str.isEmpty()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
            gzip.close();
            return out.toByteArray();
        }
        return new byte[0];
    }

    public static boolean isStop(String taskId) {
        return TaskHelper.isStop((String)taskId);
    }

    public static int getDeafultTimeOut() {
        return 300000;
    }

    public static int getIndexThree() {
        return 3;
    }

    public static void checkIsStop(String taskId) {
        if (TaskHelper.isStop((String)taskId)) {
            TaskHelper.stop((String)taskId);
        }
    }

    public static void sleep(long sleepSecond) throws InterruptedException {
        Thread.sleep(sleepSecond);
    }
}

