/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.imsc.dmw.utils.StringUtil;

public class MigObjSchemeUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(MigObjSchemeUpgradeServiceImpl.class);
    private static final String INIT_UPDATE_MIGRATE_OBJ = "update t_dmw_migration_easobject set finitschemename = ? where fid = ?;";
    private static final String ALL_UPDATE_MIGRATE_OBJ = "update t_dmw_migration_easobject set fallschemename = ? where fid = ?;";
    private static final String SELECT_MIGRATE_OBJ = "select fid,finitschemename,finitintegrattype,finitschemeid,fallschemename,fallschemeid,fallintegrattype  from  t_dmw_migration_easobject";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        try (DataSet idDataSet = DB.queryDataSet((String)MigObjSchemeUpgradeServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"imsc"), (String)SELECT_MIGRATE_OBJ);){
            HashMap<String, List<Object>> iscMaps = new HashMap<String, List<Object>>(16);
            HashMap<String, Long> initMapping = new HashMap<String, Long>(16);
            HashMap<String, Long> allMapping = new HashMap<String, Long>(16);
            MigObjSchemeUpgradeServiceImpl.buildMapping(idDataSet, iscMaps, initMapping, allMapping);
            if (iscMaps.isEmpty()) {
                UpgradeResult upgradeResult2 = upgradeResult;
                return upgradeResult2;
            }
            MigObjSchemeUpgradeServiceImpl.updateSql(iscMaps, initMapping, allMapping);
        }
        return upgradeResult;
    }

    private static void updateSql(Map<String, List<Object>> iscMaps, Map<String, Long> initMapping, Map<String, Long> allMapping) {
        ArrayList<Object[]> initParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> allParams = new ArrayList<Object[]>(16);
        for (Map.Entry<String, List<Object>> map : iscMaps.entrySet()) {
            String type = map.getKey();
            List<Object> schemeId = map.getValue();
            SqlBuilder sqlBuilder = new SqlBuilder();
            DataSet idDataSet1 = MigObjSchemeUpgradeServiceImpl.getDataSet(type, schemeId, sqlBuilder);
            Throwable throwable = null;
            try {
                if (idDataSet1 == null) continue;
                while (idDataSet1.hasNext()) {
                    Long allMigrateObj;
                    Row iscScheme = idDataSet1.next();
                    String key = type + "&&" + iscScheme.get("fid");
                    String name = iscScheme.getString("fname");
                    Long migrateObj = initMapping.get(key);
                    if (StringUtil.isEmpty(name)) continue;
                    if (migrateObj != null && migrateObj != 0L) {
                        ArrayList<Object> list = new ArrayList<Object>(8);
                        list.add(name);
                        list.add(migrateObj);
                        Object[] objects = list.toArray();
                        initParams.add(objects);
                    }
                    if ((allMigrateObj = allMapping.get(key)) == null || allMigrateObj == 0L) continue;
                    ArrayList<Object> list = new ArrayList<Object>(8);
                    list.add(name);
                    list.add(allMigrateObj);
                    Object[] objects = list.toArray();
                    allParams.add(objects);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (idDataSet1 == null) continue;
                if (throwable != null) {
                    try {
                        idDataSet1.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                idDataSet1.close();
            }
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (!initParams.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)INIT_UPDATE_MIGRATE_OBJ, initParams);
                }
                if (!allParams.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)ALL_UPDATE_MIGRATE_OBJ, allParams);
                }
            }
            catch (Exception e) {
                logger.error("update t_dmw_migration_easobject fail,", (Throwable)e);
                txHandle.markRollback();
                throw e;
            }
        }
    }

    private static DataSet getDataSet(String type, List<Object> schemeId, SqlBuilder sqlBuilder) {
        DataSet idDataSet1;
        if ("isc_service_flow".equals(type)) {
            sqlBuilder.append("select fid,fname from t_isc_service_flow_l where flocaleid = 'zh_CN' and ", new Object[0]);
            sqlBuilder.appendIn("fid", schemeId);
            idDataSet1 = DB.queryDataSet((String)MigObjSchemeUpgradeServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"eip"), (SqlBuilder)sqlBuilder);
        } else if ("isc_data_copy_trigger".equals(type)) {
            sqlBuilder.append("select fid,fname from t_isc_data_copy_trigger_l where flocaleid = 'zh_CN' and ", new Object[0]);
            sqlBuilder.appendIn("fid", schemeId);
            idDataSet1 = DB.queryDataSet((String)MigObjSchemeUpgradeServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"eip"), (SqlBuilder)sqlBuilder);
        } else {
            return null;
        }
        return idDataSet1;
    }

    private static void buildMapping(DataSet idDataSet, Map<String, List<Object>> iscMaps, Map<String, Long> initMapping, Map<String, Long> allMapping) {
        while (idDataSet.hasNext()) {
            String allName;
            Row migObj = idDataSet.next();
            String initName = migObj.getString("finitschemename");
            if (StringUtil.isEmpty(initName)) {
                String initType = migObj.getString("finitintegrattype");
                Long initSchemeId = migObj.getLong("finitschemeid");
                iscMaps.putIfAbsent(initType, new ArrayList(4));
                List<Object> initschemeList = iscMaps.get(initType);
                initschemeList.add(initSchemeId);
                String key = initType + "&&" + initSchemeId;
                initMapping.put(key, migObj.getLong("fid"));
            }
            if (!StringUtil.isEmpty(allName = migObj.getString("fallschemename"))) continue;
            String allType = migObj.getString("fallintegrattype");
            Long allSchemeId = migObj.getLong("fallschemeid");
            iscMaps.putIfAbsent(allType, new ArrayList(4));
            List<Object> initList = iscMaps.get(allType);
            initList.add(allSchemeId);
            String value = allType + "&&" + allSchemeId;
            allMapping.put(value, migObj.getLong("fid"));
        }
    }
}

