/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.datacollect;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.zip.ZipFile;
import kd.bos.zip.exception.ZipException;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.helper.ShowFormHelper;
import kd.imsc.dmw.plugin.formplugin.datacollect.ProjectAllBaseUtil;
import kd.imsc.dmw.plugin.formplugin.datacollect.ProjectAuthFormUtil;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DateUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.F7Utils;
import kd.imsc.dmw.utils.StdTemplateHelper;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.formplugin.tpl.ImbdBdTplEditPlugin;
import org.apache.commons.io.FileUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ProjectAllBase
extends ImbdBdTplEditPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ProjectAllBase.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String DOWNLOADPATH = "KINGDEEDOWNLOAD";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"datatemplateid", "impscheme"});
        this.addClickListeners(new String[]{"downdatatemplate", "dataobj"});
        Toolbar toolbar = (Toolbar)this.getView().getControl("advcontoolbarap");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("datatemplateid".equals(key)) {
            int rowIndex = e.getRow();
            QFilter qFilter = new QFilter("bizobject", "=", this.getF7PKValue("dataobjid", rowIndex));
            qFilter.and(new QFilter("templatetype", "=", (Object)"IMPT"));
            F7Utils.addF7Filter(e, qFilter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!this.isNewCreate()) {
            Map<Long, Map<String, String>> resultMsgMap = ProjectAllBaseUtil.getEntryResultMsg(this.getModel().getDataEntity().getLong("id"));
            DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDynObj : entryColl) {
                long entryId = entryDynObj.getLong("id");
                String collectMsg = resultMsgMap.get(entryId).get("collectresult");
                String importMsg = resultMsgMap.get(entryId).get("importresult");
                if (collectMsg != null && importMsg != null) {
                    entryDynObj.set("collectresult", (Object)collectMsg);
                    entryDynObj.set("importresult", (Object)importMsg);
                }
                this.setDataObjText(entryDynObj);
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        if ("dataobj".equals(fieldKey)) {
            int rowIndex = control.getModel().getEntryCurrentRowIndex("entryentity");
            this.showDataObjListForm(rowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            Object dataType = this.getModel().getValue("datatype", i);
            this.getView().setEnable(Boolean.valueOf("1".equals(dataType)), i, new String[]{"datatemplateid"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "dataobjid": {
                Object dataObjId = this.getF7PKValue("dataobjid", rowIndex);
                Object templateId = null;
                if (dataObjId != null) {
                    QFilter qFilter = new QFilter("bizobject", "=", dataObjId);
                    qFilter.and(new QFilter("templatetype", "=", (Object)"IMPT"));
                    List templateIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_importtemplate", (QFilter[])qFilter.toArray(), null, (int)-1);
                    if (templateIdList != null && templateIdList.size() == 1) {
                        templateId = templateIdList.get(0);
                    }
                    this.getModel().setValue("dataobj", (Object)this.getF7Value("dataobjid", rowIndex).getLocaleString("name").getLocaleValue(), rowIndex);
                }
                this.getModel().setValue("datatemplateid", templateId, rowIndex);
                break;
            }
            case "impscheme": {
                DynamicObject impScheme = this.getF7Value("impscheme", rowIndex);
                if (impScheme == null) break;
                Object dataType = this.getModel().getValue("datatype", rowIndex);
                if ("1".equals(dataType)) {
                    this.getModel().setValue("datatype", (Object)"2", rowIndex);
                }
                this.getModel().setValue("dataobj", (Object)impScheme.getLocaleString("name").getLocaleValue(), rowIndex);
                break;
            }
            case "datatype": {
                this.getModel().setValue("dataobj", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(!"2".equals(newValue)), rowIndex, new String[]{"datatemplateid"});
                break;
            }
            case "dataobj": {
                if (!StringUtil.isEmpty(newValue)) break;
                this.getModel().setValue("dataobjid", null, rowIndex);
                this.getModel().setValue("impscheme", null, rowIndex);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp prop = e.getEntryProp();
        if ("entryentity".equals(prop.getName())) {
            int[] rowIndexs = e.getRowIndexs();
            ArrayList<Long> detailIdList = new ArrayList<Long>(rowIndexs.length);
            for (int rowIndex : rowIndexs) {
                detailIdList.add(this.getModel().getEntryRowEntity("entryentity", rowIndex).getLong("id"));
            }
            Map<Long, Boolean> flagMap = ProjectAllBaseUtil.getJoinImportResult(this.getModel().getDataEntity(true), detailIdList);
            StringBuilder seqStr = new StringBuilder();
            for (int rowIndex : rowIndexs) {
                long detailPkId = this.getModel().getEntryRowEntity("entryentity", rowIndex).getLong("id");
                boolean ifContain = flagMap.containsKey(detailPkId);
                if (!ifContain || !flagMap.get(detailPkId).booleanValue()) continue;
                seqStr.append(rowIndex + 1).append(',');
            }
            if (seqStr.length() > 0) {
                e.setCancel(true);
                seqStr.deleteCharAt(seqStr.length() - 1);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u5220\u9664\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u63d0\u62a5\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u884c\u3002", (String)"ProjectAllBase_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), seqStr.toString()));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("taskassign".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isSuccess;
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        boolean bl = isSuccess = e.getOperationResult() != null && e.getOperationResult().isSuccess();
        if (isSuccess) {
            switch (key) {
                case "viewdetail": {
                    int[] selectIndex = ((EntryGrid)this.getControl("entryentity")).getSelectRows();
                    if (CommonUtils.isNull(selectIndex)) break;
                    DynamicObject entryDynObj = this.getModel().getEntryRowEntity("entryentity", selectIndex[0]);
                    if (this.verifyProjectNewCreate(entryDynObj)) {
                        return;
                    }
                    this.showProjectDetail();
                    break;
                }
                case "taskassign": {
                    if (this.verifyProjectNewCreate(this.getModel().getDataEntity())) {
                        return;
                    }
                    DynamicObjectCollection entryoll = this.getView().getModel().getEntryEntity("entryentity");
                    List<Long> detailIdList = entryoll.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                    ProjectAuthFormUtil.showProjectAuthByDetailId(this.getView(), (IFormPlugin)this, detailIdList);
                    break;
                }
                case "downdatatemplate": {
                    int[] selectIndexs = ((EntryGrid)this.getControl("entryentity")).getSelectRows();
                    try {
                        if (CommonUtils.isNull(selectIndexs)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u4e00\u884c\u5206\u5f55\u3002", (String)"ProjectAllBase_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                            break;
                        }
                        if (selectIndexs.length == 1) {
                            DynamicObject entryDynObj = this.getModel().getEntryRowEntity("entryentity", selectIndexs[0]);
                            String dataType = DynamicObjectUtils.getString(entryDynObj, "datatype");
                            if ("1".equals(dataType)) {
                                String formId = DynamicObjectUtils.getStrPkValue(entryDynObj, "dataobjid");
                                long templateId = DynamicObjectUtils.getPkValue(entryDynObj, "datatemplateid");
                                if (templateId == 0L) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7b2c%s\u884c\u5206\u5f55\u4e2d\u201c\u6570\u636e\u6536\u96c6\u6a21\u677f\u201d", (String)"ProjectAllBase_5", (String)"imsc-dmw-platform", (Object[])new Object[]{selectIndexs[0] + 1}));
                                    return;
                                }
                                ProjectAllBaseUtil.downloadImportTemplate(this.getView(), formId, templateId, selectIndexs[0] + 1);
                                break;
                            }
                            if (!"2".equals(dataType)) break;
                            long impSchemeId = DynamicObjectUtils.getPkValue(entryDynObj, "impscheme");
                            ProjectAllBaseUtil.downloadImportTemplateByScheme(this.getView(), impSchemeId, selectIndexs[0] + 1);
                            break;
                        }
                        this.batachDownloadImportTemplate(selectIndexs);
                        break;
                    }
                    catch (Exception ex) {
                        throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
                    }
                }
                case "save": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        if ("dataobj".equals(fieldName)) {
            this.showDataObjDetail(rowIndex);
        }
    }

    public void afterCopyData(EventObject e) {
        DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject entryDynObj : entryColl) {
            this.setDataObjText(entryDynObj);
        }
    }

    private void showProjectDetail() {
        BillShowParameter formshowParameter = new BillShowParameter();
        formshowParameter.setBillStatus(BillOperationStatus.EDIT);
        formshowParameter.setStatus(OperationStatus.VIEW);
        formshowParameter.setFormId("dmw_projectdetail");
        int selectRow = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryDynObj = this.getModel().getEntryRowEntity("entryentity", selectRow);
        formshowParameter.setPkId(entryDynObj.getPkValue());
        formshowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)formshowParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batachDownloadImportTemplate(int[] selectIndexs) throws Exception {
        String appNumberPath = String.join((CharSequence)"", USER_HOME, File.separator, DOWNLOADPATH, File.separator, "dmw");
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), StandardCharsets.UTF_8).toString();
        String templatePath = String.join((CharSequence)File.separator, appNumberPath, traceIdHash, "template");
        File templateFile = new File(templatePath);
        OutputStream outputStream = null;
        try {
            if (!templateFile.exists()) {
                templateFile.mkdirs();
            }
            Map<Object, DynamicObject> stdImportTemplate = this.getStdImportTemplate(selectIndexs);
            for (int selectIndex : selectIndexs) {
                String fileName;
                DynamicObject entryDynObj = this.getModel().getEntryRowEntity("entryentity", selectIndex);
                String dataType = DynamicObjectUtils.getString(entryDynObj, "datatype");
                if ("1".equals(dataType)) {
                    String formId = DynamicObjectUtils.getStrPkValue(entryDynObj, "dataobjid");
                    long templateId = DynamicObjectUtils.getPkValue(entryDynObj, "datatemplateid");
                    if (templateId == 0L) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7b2c%s\u884c\u5206\u5f55\u4e2d\u201c\u6570\u636e\u6536\u96c6\u6a21\u677f\u201d", (String)"ProjectAllBase_5", (String)"imsc-dmw-platform", (Object[])new Object[]{selectIndex + 1}));
                        return;
                    }
                    DynamicObject templateData = stdImportTemplate.get(templateId);
                    if (templateData == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6536\u96c6\u5bf9\u8c61\u6e05\u5355\u201d\u7b2c\u201c%s\u201d\u884c\uff0c\u672a\u83b7\u53d6\u5230\u6536\u96c6\u5bf9\u8c61\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ProjectAllBase_4", (String)"imsc-dmw-platform", (Object[])new Object[]{selectIndex + 1}));
                        return;
                    }
                    fileName = ProjectAllBaseUtil.getFileName(formId, DynamicObjectUtils.getString(templateData, "name"), selectIndex + 1);
                    String fileUrlPath = templatePath + File.separator + fileName + ".xlsx";
                    try (SXSSFWorkbook templateStream = StdTemplateHelper.getStdImportTemplateStream(formId, fileName);
                         FileOutputStream oStream = new FileOutputStream(fileUrlPath);){
                        templateStream.write((OutputStream)oStream);
                        continue;
                    }
                }
                if (!"2".equals(dataType)) continue;
                long impSchemeId = DynamicObjectUtils.getPkValue(entryDynObj, "impscheme");
                List attachList = AttachmentServiceHelper.getAttachments((String)"dmw_impscheme", (Object)impSchemeId, (String)"attachmentpanelap", (boolean)false);
                if (attachList == null || attachList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6536\u96c6\u5bf9\u8c61\u6e05\u5355\u201d\u7b2c\u201c%s\u201d\u884c\uff0c\u672a\u83b7\u53d6\u5230\u6536\u96c6\u5bf9\u8c61\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ProjectAllBase_4", (String)"imsc-dmw-platform", (Object[])new Object[]{selectIndex + 1}));
                    return;
                }
                Map attachMap = (Map)attachList.get(0);
                fileName = selectIndex + 1 + "-" + attachMap.get("name");
                String path = (String)attachMap.get("url");
                String fileUrlPath = templatePath + File.separator + fileName;
                outputStream = new FileOutputStream(fileUrlPath);
                String attachmentRelativePath = MultiImpAttachmentHelper.getAttachmentRelativePath(path);
                FileServiceFactory.getAttachmentFileService().download(attachmentRelativePath, outputStream, "imsc-dmw");
            }
            File zipFile = this.compressFile(ResManager.loadKDString((String)"\u6536\u96c6\u5bf9\u8c61\u5bfc\u5165\u6a21\u677f", (String)"ProjectAllBase_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), templateFile);
            try (FileInputStream inputStream = new FileInputStream(zipFile);){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFile.getName(), (InputStream)inputStream, 2);
                this.getView().download(urls);
                FileUtils.delete((File)zipFile);
            }
        }
        finally {
            try {
                if (templateFile.exists()) {
                    FileUtils.deleteDirectory((File)templateFile);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    private Map<Object, DynamicObject> getStdImportTemplate(int[] selectIndexs) {
        ArrayList<Long> templateIds = new ArrayList<Long>(selectIndexs.length);
        for (int selectIndex : selectIndexs) {
            DynamicObject entryDynObj = this.getModel().getEntryRowEntity("entryentity", selectIndex);
            String dataType = DynamicObjectUtils.getString(entryDynObj, "datatype");
            if (!"1".equals(dataType)) continue;
            long templateId = DynamicObjectUtils.getPkValue(entryDynObj, "datatemplateid");
            templateIds.add(templateId);
        }
        Map templateDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])templateIds.toArray(), (String)"bos_importtemplate");
        return templateDynamicObjectMap;
    }

    private File compressFile(String moduleName, File dir) throws ZipException {
        String zipFileName = dir.getParent() + File.separator + String.format("%s_%s.zip", moduleName, DateUtils.getCurrTimeFormat((String)"yyyyMMddHHmmss"));
        ZipFile zipFile = new ZipFile(zipFileName);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            zipFile.addFile(files[i]);
        }
        return zipFile.getFile();
    }

    private boolean verifyProjectNewCreate(DynamicObject dynObj) {
        boolean isAddNew;
        boolean bl = isAddNew = !dynObj.getDataEntityState().getFromDatabase();
        if (isAddNew) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ProjectAllBase_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        return isAddNew;
    }

    private void showDataObjListForm(int rowIndex) {
        Object dataType = this.getModel().getValue("datatype", rowIndex);
        if ("1".equals(dataType)) {
            BasedataEdit stdDataObj = (BasedataEdit)this.getControl("dataobjid");
            stdDataObj.click();
        } else if ("2".equals(dataType)) {
            BasedataEdit impScheme = (BasedataEdit)this.getControl("impscheme");
            impScheme.click();
        }
    }

    private void showDataObjDetail(int rowIndex) {
        String dataType = this.getStringValue("datatype", rowIndex);
        if ("1".equals(dataType)) {
            Object stdDataObjId = this.getF7PKValue("dataobjid", rowIndex);
            if (stdDataObjId == null) {
                return;
            }
            FormShowParameter showParameter = ShowFormHelper.viewDetail(this.getView(), "bos_entityobject", stdDataObjId);
            this.getView().showForm(showParameter);
        } else if ("2".equals(dataType)) {
            Object impSchemeId = this.getF7PKValue("impscheme", rowIndex);
            if (impSchemeId == null) {
                return;
            }
            FormShowParameter showParameter = ShowFormHelper.viewDetail(this.getView(), "dmw_impscheme", impSchemeId);
            this.getView().showForm(showParameter);
        }
    }

    private void setDataObjText(DynamicObject entryDynObj) {
        String dataType = entryDynObj.getString("datatype");
        if ("1".equals(dataType)) {
            DynamicObject dataObjId = entryDynObj.getDynamicObject("dataobjid");
            String dataObj = entryDynObj.getString("dataobj");
            if (dataObjId != null && StringUtil.isEmpty(dataObj)) {
                entryDynObj.set("dataobj", (Object)dataObjId.getLocaleString("name").getLocaleValue());
            }
        }
    }
}

