/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.datacollect.upload;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.dmw.utils.StringUtils;

public class UploadUtil {
    private UploadUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void showDataUploadPanel(IFormView view, String entityNumber, long collectId, long reportOrgId, List<Long> allReportOrgIdList, long dataTemplateId, String callBackClass) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("dmw_fileupload");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("collectId", (Object)collectId);
        formShowParameter.setCustomParam("BillFormId", (Object)entityNumber);
        formShowParameter.setCustomParam("datatemplateid", (Object)dataTemplateId);
        formShowParameter.setCustomParam("reportorgid", (Object)reportOrgId);
        formShowParameter.setCustomParam("filterOrgIdList", allReportOrgIdList);
        if (StringUtils.isNotEmpty(callBackClass)) {
            formShowParameter.setCloseCallBack(new CloseCallBack(callBackClass, "dataupload"));
        }
        view.showForm(formShowParameter);
    }

    public static boolean checkCanUpload(IFormView view, long projectDetailId, long reportOrgId) {
        DynamicObject projectDetail = BusinessDataServiceHelper.loadSingle((Object)projectDetailId, (String)"dmw_projectdetail");
        if (projectDetail == null) {
            String tips = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6536\u96c6\u6570\u636e\u5904\u7406\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"UploadUtil_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            view.showErrorNotification(tips);
            return false;
        }
        DynamicObject collectProjectObj = projectDetail.getDynamicObject("projectid");
        String projectStatus = collectProjectObj.getString("projectstatus");
        if (!"B".equals(projectStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u624d\u5141\u8bb8\u6570\u636e\u4e0a\u4f20", (String)"UploadUtil_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        Date now = new Date();
        Date endDateTime = projectDetail.getDate("enddatetime");
        if (endDateTime != null && now.after(endDateTime)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5HH:mm:ss", (String)"UploadUtil_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            String tips = String.format(ResManager.loadKDString((String)"\u6536\u96c6\u4efb\u52a1\u622a\u6b62\u65f6\u95f4\u4e3a%s\uff0c\u73b0\u5df2\u65e0\u6cd5\u63d0\u62a5\uff0c\u8bf7\u8054\u7cfb\u6536\u96c6\u8d1f\u8d23\u4eba\u5904\u7406\u3002", (String)"UploadUtil_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), dateFormat.format(endDateTime));
            view.showTipNotification(tips);
            return false;
        }
        DynamicObjectCollection collectResultColl = projectDetail.getDynamicObjectCollection("collectresultentry");
        if (collectResultColl.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u4efb\u52a1\u5206\u914d", (String)"UploadUtil_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        boolean existBeginReport = collectResultColl.stream().anyMatch(p -> "1".equals(p.getString("reportstatus")));
        if (!existBeginReport) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u5747\u5df2\u63d0\u62a5\u65e0\u6cd5\u518d\u4e0a\u4f20\u6587\u4ef6\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5", (String)"UploadUtil_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        if (reportOrgId == 0L) {
            return true;
        }
        DynamicObject collectResult = collectResultColl.stream().filter(p -> p.getLong("reportorgid_id") == reportOrgId).findFirst().orElseGet(DynamicObject::new);
        String reportStatus = collectResult.getString("reportstatus");
        DynamicObject org = collectResult.getDynamicObject("reportorgid");
        if ("2".equals(reportStatus)) {
            String tips = ResManager.loadKDString((String)"\u63d0\u62a5\u7ec4\u7ec7\u201c%1$s\u201d\u5df2\u6807\u8bb0\u63d0\u62a5\u5b8c\u6210\uff0c\u65e0\u6cd5\u518d\u4e0a\u4f20\u6587\u4ef6\uff0c\u8bf7\u5148\u53d6\u6d88\u6807\u8bb0\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"UploadUtil_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            view.showTipNotification(String.format(tips, org.getLocaleString("name").getLocaleValue()));
            return false;
        }
        return true;
    }
}

