/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imsc.dmw.helper.ScheduleHelper;
import kd.imsc.dmw.helper.lock.BizLocker;
import kd.imsc.dmw.plugin.formplugin.schedule.task.CheckItemRepairTask;
import kd.imsc.dmw.plugin.formplugin.schedule.taskclick.ProgressBarTaskClick;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class ProgressBarEditPlugin
extends ImbdDymicTplEditPlugin
implements ProgresssListener {
    private static final String PROGRESS_BAR = "progressbar";
    private static final String TO_BACKGROUND_BTN = "btnok";
    private static final String REPAIR_JOB_JSON = "repair_job_json";
    private static final String CACHEKEY_ISFINISHED = "cachekey_isfinished";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TO_BACKGROUND_BTN});
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_BAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("projectid", formShowParameter.getCustomParam("projectid"));
        param.put("dblinkid", formShowParameter.getCustomParam("dblinkid"));
        param.put("taskId", formShowParameter.getCustomParam("taskId"));
        param.put("repairIds", formShowParameter.getCustomParam("repairIds"));
        param.put("checkresult", formShowParameter.getCustomParam("checkresult"));
        param.put("checkdetail", formShowParameter.getCustomParam("checkdetail"));
        param.put("taskData", formShowParameter.getCustomParam("taskData"));
        param.put("checkItemLog", formShowParameter.getCustomParam("checkItemLog"));
        param.put("row", formShowParameter.getCustomParam("row"));
        param.put("checkitemids", formShowParameter.getCustomParam("checkitemids"));
        param.put("checkitemFormId", formShowParameter.getCustomParam("checkitemFormId"));
        JobFormInfo jobFormInfo = ScheduleHelper.buildJobFormInfo(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u4fee\u590d\u4efb\u52a1", (String)"CheckTestDlgEditPlugin_14", (String)"imsc-dmw-platform", (Object[])new Object[0]), CheckItemRepairTask.class.getName(), ProgressBarTaskClick.class.getName(), this.getView(), param);
        jobFormInfo.getJobInfo().setAppId("dmw");
        String taskId = String.valueOf(param.get("taskId"));
        List checkItemIds = (List)param.get("checkitemids");
        if (taskId == null || "".equals(taskId)) {
            if (checkItemIds != null) {
                String checkItemFormId = CommonUtils.getStringCustomParamValue(this.getView(), "checkitemFormId");
                for (Long id : checkItemIds) {
                    BizLocker.create().doLock(id, checkItemFormId);
                }
            }
            taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            param.put("taskId", taskId);
        }
        this.getView().getPageCache().put("repair_jobid_cache", taskId);
        this.getView().getPageCache().put(REPAIR_JOB_JSON, JSON.toJSONString((Object)jobFormInfo));
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
        TaskInfo repairTask = ScheduleServiceHelper.queryTask((String)taskId);
        if (repairTask.isTaskEnd()) {
            progressBar.setPercent(100);
            this.getView().setEnable(Boolean.FALSE, new String[]{TO_BACKGROUND_BTN});
            String checkItemFormId = CommonUtils.getStringCustomParamValue(this.getView(), "checkitemFormId");
            for (Long id : checkItemIds) {
                BizLocker.doRelease(id, checkItemFormId);
            }
        } else {
            progressBar.start();
            progressBar.setPercent(30);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String taskId = this.getView().getPageCache().get("repair_jobid_cache");
        if (key.equals(TO_BACKGROUND_BTN)) {
            JobFormInfo jobFormInfo;
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId) && (jobFormInfo = this.getJobFormInfo()) != null) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)Objects.requireNonNull(jobFormInfo), (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                ThreadPools.executeOnce((String)(((Object)((Object)this)).getClass().getSimpleName() + "-background-monitor"), (Runnable)subscriber);
            }
            TaskClientProxy.setProgressPageId((String)taskId, (String)"");
            this.getView().close();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
        String progressBarKey = progressBar.getKey();
        String repairTaskId = this.getView().getPageCache().get("repair_jobid_cache");
        TaskInfo repairTask = ScheduleServiceHelper.queryTask((String)repairTaskId);
        Map<String, Object> customDataRepair = ScheduleHelper.getTaskCustomData(repairTask);
        if (PROGRESS_BAR.equals(progressBarKey)) {
            if (repairTask.isTaskEnd()) {
                List checkitemidmap = (List)customDataRepair.get("checkitemids");
                String checkItemFormId = CommonUtils.getStringCustomParamValue(this.getView(), "checkitemFormId");
                for (Long id : checkitemidmap) {
                    BizLocker.doRelease(id, checkItemFormId);
                }
                boolean isFinished = this.isFinished();
                this.setFinished(true);
                if (isFinished) {
                    progressEvent.setProgress(100);
                    this.getView().setEnable(Boolean.FALSE, new String[]{TO_BACKGROUND_BTN});
                    if (repairTask.isFailure()) {
                        this.getView().getPageCache().put("repairstatus", "B");
                    } else {
                        Map repaidResult = (Map)SerializationUtils.fromJsonString((String)repairTask.getData(), Map.class);
                        String repairStatus = (String)repaidResult.get("repairstatus");
                        this.getView().getPageCache().put("repairstatus", repairStatus);
                    }
                    this.getView().close();
                } else {
                    progressEvent.setProgress(99);
                }
            } else {
                progressEvent.setProgress(60);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        int row = (Integer)this.getView().getFormShowParameter().getCustomParam("row");
        map.put("repair_jobid_cache", this.getView().getPageCache().get("repair_jobid_cache"));
        map.put("row", row);
        this.getView().returnDataToParent(map);
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    private JobFormInfo getJobFormInfo() {
        String str = this.getView().getPageCache().get(REPAIR_JOB_JSON);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }
}

