/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.schedule.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.helper.BalanceCheckDataHelper;
import kd.imsc.dmw.utils.DynamicObjectUtils;

public class BalanceCheckdataTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BalanceCheckdataTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashMap<String, String> importMap = new HashMap<String, String>(16);
        long serviceFlowId = 2225564508888248320L;
        boolean isExist = QueryServiceHelper.exists((String)"isc_service_flow", (Object)serviceFlowId);
        if (!isExist) {
            importMap.put("errormsg", ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\uff1a\u9884\u7f6eflow_EAS\u79d1\u76ee\u4f59\u989d\u6838\u5bf9\u6570\u636e\uff08EAS-\u661f\u701a\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u90e8\u7f72\u3002", (String)"BalanceCheckdataTask_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            this.feedbackCustomdata(importMap);
            BalanceCheckDataHelper.checkIsStop(this.taskId);
            return;
        }
        LinkedHashMap<String, Object> schemeParam = new LinkedHashMap<String, Object>(8);
        DynamicObject flowDynObj = BusinessDataServiceHelper.loadSingle((String)"isc_service_flow", (String)"id,name,is_released,enable,var_category,var_type,var_name,is_input_param,default_value,is_output_param", (QFilter[])new QFilter("id", "=", (Object)serviceFlowId).toArray());
        List orgNumberList = (List)map.get("orgNumberList");
        String booktypenumber = (String)map.get("booktypenumber");
        String startperiodnumber = (String)map.get("startperiodnumber");
        String endperiodnumber = (String)map.get("endperiodnumber");
        String checkcurrencynumber = (String)map.get("checkcurrencynumber");
        String taskid = (String)map.get("taskid");
        DynamicObjectCollection params = flowDynObj.getDynamicObjectCollection("variables");
        for (DynamicObject param : params) {
            if (!param.getBoolean("is_input_param")) continue;
            String name = param.getString("var_name");
            String value = param.getString("default_value");
            schemeParam.put(name, value);
            if ("companyNumbers".equals(name)) {
                schemeParam.put(name, orgNumberList);
                continue;
            }
            if ("bookTypeNumber".equals(name)) {
                schemeParam.put(name, booktypenumber);
                continue;
            }
            if ("fromPeriodNumber".equals(name)) {
                schemeParam.put(name, startperiodnumber);
                continue;
            }
            if ("toPeriodNumber".equals(name)) {
                schemeParam.put(name, endperiodnumber);
                continue;
            }
            if ("checkCurrencyNumber".equals(name)) {
                schemeParam.put("checkCurrencyNumber", checkcurrencynumber);
                continue;
            }
            if (!"taskid".equals(name)) continue;
            schemeParam.put("taskid", taskid);
        }
        Object invokeResult = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{DynamicObjectUtils.getString(flowDynObj, "number"), new ArrayList(schemeParam.values())});
        long instanceId = Long.parseLong(invokeResult.toString());
        String taskId = "";
        Tuple<String, Object> resultTuple = this.waitServiceFlowEnd(instanceId, taskId);
        if ("C".equals(resultTuple.item1)) {
            importMap.put("errormsg", resultTuple.item2.toString());
            this.feedbackCustomdata(importMap);
            BalanceCheckDataHelper.checkIsStop(this.taskId);
        }
        this.feedbackProgress(99);
    }

    private Tuple<String, Object> waitServiceFlowEnd(long instanceId, String taskId) {
        int sleepSecond = 500;
        long startTime = System.currentTimeMillis();
        int interruptedCount = 0;
        int percent = 1;
        while (!this.checkTerminate(instanceId, taskId)) {
            Map<String, Object> execution = this.getFlowServiceState(instanceId);
            String state = (String)execution.get("state");
            if ("Created".equals(state) || "Waiting".equals(state)) {
                if (System.currentTimeMillis() - startTime > (long)BalanceCheckDataHelper.getDeafultTimeOut()) {
                    String message = String.format(ResManager.loadKDString((String)"%s\u670d\u52a1\u6d41\u7a0b\u957f\u65f6\u95f4\u7b49\u5f85\u540e\u4ecd\u5904\u4e8e\u521b\u5efa\u72b6\u6001\u800c\u672a\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u5230\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u67e5\u770b\u6267\u884c\u72b6\u6001\u3002", (String)"BalanceCheckdataTask_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), instanceId);
                    return new Tuple((Object)"C", (Object)message);
                }
            } else {
                if ("Terminated".equals(state) || "Failed".equals(state)) {
                    String errorMsg = "Terminated".equals(state) ? ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u88ab\u7ec8\u6b62", (String)"BalanceCheckdataTask_3", (String)"imsc-dmw-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u5931\u8d25", (String)"BalanceCheckdataTask_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    String type = "Terminated".equals(state) ? "CONTROL" : "ERROR";
                    QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("proc_inst", "=", (Object)instanceId)};
                    DynamicObjectCollection logObjs = QueryServiceHelper.query((String)"isc_sf_proc_log", (String)"id, content,content_tag", (QFilter[])qFilters, (String)"created_time desc", (int)1);
                    if (!logObjs.isEmpty()) {
                        errorMsg = ((DynamicObject)logObjs.get(0)).getString("content_tag");
                    }
                    return new Tuple((Object)"C", (Object)errorMsg);
                }
                if ("Complete".equals(state)) {
                    return new Tuple((Object)"D", (Object)"");
                }
            }
            try {
                BalanceCheckDataHelper.sleep(sleepSecond);
            }
            catch (InterruptedException e) {
                int n = interruptedCount;
                interruptedCount = (byte)(interruptedCount + 1);
                if (n > BalanceCheckDataHelper.getIndexThree()) {
                    String message = ResManager.loadKDString((String)"%1$s\u670d\u52a1\u6d41\u7a0b\u5df2\u7ecf\u88ab\u591a\u6b21\u4e2d\u65ad\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5 %2$s", (String)"BalanceCheckdataTask_5", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    KDBizException exception = new KDBizException(String.format(message, instanceId, e.getMessage()));
                    exception.addSuppressed((Throwable)e);
                    throw exception;
                }
                Thread.currentThread().interrupt();
            }
            sleepSecond = this.getSleepSecond(sleepSecond, 5000);
            if ((percent += 5) >= 100) {
                this.feedbackProgress(99);
                continue;
            }
            this.feedbackProgress(percent);
        }
        return new Tuple((Object)"C", (Object)ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"BalanceCheckdataTask_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
    }

    private boolean checkTerminate(long instanceId, String taskId) {
        boolean success;
        boolean isTerminate = BalanceCheckDataHelper.isStop(taskId);
        if (isTerminate && instanceId != 0L && !(success = ((Boolean)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"terminate", (Object[])new Object[]{instanceId})).booleanValue())) {
            logger.warn(String.format("\u6d41\u7a0b\u5b9e\u4f8b[%1$s]\u5df2\u7ecf\u7ed3\u675f\u6216\u7ec8\u6b62\uff0c\u65e0\u6cd5\u518d\u6267\u884c\u7ec8\u6b62", instanceId));
        }
        return isTerminate;
    }

    private Map<String, Object> getFlowServiceState(long instanceId) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"getState", (Object[])new Object[]{instanceId});
    }

    private int getSleepSecond(int beginSecond, int maxSecond) {
        if (beginSecond >= maxSecond) {
            return maxSecond;
        }
        return beginSecond * 13 / 10;
    }

    private static class IscFlowStatus {
        public static final String CREATED = "Created";
        public static final String WAITING = "Waiting";
        public static final String FAILED = "Failed";
        public static final String COMPLETE = "Complete";
        public static final String TERMINATED = "Terminated";

        private IscFlowStatus() {
        }
    }
}

