/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CommonUtil {
    public static String getExceptionDetailInfo(Throwable exception) {
        String retMsg;
        if (exception == null) {
            return "exception is null";
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            exception.printStackTrace(pw);
            pw.flush();
            sw.flush();
            retMsg = sw.toString();
        }
        catch (IOException e) {
            String msgTpl = ResManager.loadKDString((String)"exception \u89e3\u6790\u5931\u8d25\uff01%s", (String)"CommonUtil_0", (String)"imsc-imic-platform", (Object[])new Object[0]);
            retMsg = String.format(msgTpl, e.getMessage());
        }
        return retMsg;
    }

    public static List<Long> getOrgIdsByOrgViewNumbers(List<Long> filterOrgs, List<String> orgViewTypeNumberList) {
        QFilter viewTypeFilter = new QFilter("number", "in", orgViewTypeNumberList);
        Map viewsObj = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)"id", (QFilter[])viewTypeFilter.toArray());
        QFilter viewFilter = new QFilter("structure.view", "in", viewsObj.keySet());
        List orgIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])viewFilter.toArray(), null, (int)-1);
        List<Long> longsInB = orgIds.stream().filter(item -> item instanceof Long).map(Long.class::cast).collect(Collectors.toList());
        if (filterOrgs == null || filterOrgs.isEmpty()) {
            return longsInB;
        }
        return filterOrgs.stream().filter(longsInB::contains).collect(Collectors.toList());
    }

    public static boolean isNull(Object o) {
        return o == null || o instanceof String && ((String)o).length() == 0 || o instanceof StringBuffer && ((StringBuffer)o).length() == 0 || o instanceof List && ((List)o).isEmpty() || o instanceof Collection && ((Collection)o).isEmpty() || o instanceof Object[] && ((Object[])o).length == 0 || o instanceof int[] && ((int[])o).length == 0 || o instanceof Map && ((Map)o).size() == 0 || o instanceof DynamicObjectCollection && ((DynamicObjectCollection)o).isEmpty() || o instanceof DynamicObject[] && ((DynamicObject[])o).length == 0;
    }

    public static boolean getBooleanCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtil.getCustomParamValue(formView, key);
        if (obj instanceof Boolean) {
            return Boolean.parseBoolean(obj.toString());
        }
        return false;
    }

    public static long getLongCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtil.getCustomParamValue(formView, key);
        if (CommonUtil.isNull(obj)) {
            return 0L;
        }
        return Long.parseLong(obj.toString());
    }

    public static String getStringCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtil.getCustomParamValue(formView, key);
        if (CommonUtil.isNull(obj)) {
            return "";
        }
        return obj.toString();
    }

    public static int getIntCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtil.getCustomParamValue(formView, key);
        if (CommonUtil.isNull(obj)) {
            return 0;
        }
        return Integer.parseInt(obj.toString());
    }

    public static List<Long> getListCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtil.getCustomParamValue(formView, key);
        if (!CommonUtil.isNull(obj)) {
            return (List)SerializationUtils.fromJsonString((String)obj.toString(), List.class);
        }
        return new ArrayList<Long>(0);
    }

    public static Object getCustomParamValue(IFormView formView, String key) {
        Map customParams = formView.getFormShowParameter().getCustomParams();
        if (CommonUtil.isNull(customParams) || !customParams.containsKey(key)) {
            return null;
        }
        return customParams.get(key);
    }
}

