/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.initialscheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;
import kd.imsc.imic.common.FilterGridUtil;
import kd.imsc.imic.common.StringUtils;

public class PageParamsPlugin
extends ImbdDymicTplEditPlugin {
    private static final String PARAMS = "params";
    private static final String NAME = "name";
    private static final String VALUE = "value";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String modelType = (String)parameter.getCustomParam("modeltype");
        String formNumber = (String)parameter.getCustomParam("formnumber");
        boolean isEntity = StringUtils.equals(modelType, "BaseFormModel") || StringUtils.equals(modelType, "BillFormModel");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (isEntity && !StringUtils.isEmpty(formNumber)) {
            FilterGridUtil.setFilterControl(formNumber, filterGrid);
        } else {
            FilterGridUtil.setFilterControl(null, filterGrid);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String operateKey = control.getKey();
        if (StringUtils.equals(operateKey, "btnok")) {
            JSONObject jsonParamList = new JSONObject();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PARAMS);
            JSONObject entryEntityJson = this.getEntryDataJson(entryEntity);
            String param = entryEntityJson.isEmpty() ? " " : entryEntityJson.toJSONString();
            jsonParamList.put("paramsentry", (Object)param);
            String appId = (String)this.getModel().getValue("appid");
            param = appId == null ? " " : appId;
            jsonParamList.put("appid", (Object)param);
            String openType = (String)this.getModel().getValue("opentype");
            param = openType == null ? " " : openType;
            jsonParamList.put("opentype", (Object)param);
            String paramParameterType = (String)this.getModel().getValue("parametertype");
            param = paramParameterType == null ? " " : paramParameterType;
            jsonParamList.put("parametertype", (Object)param);
            OrmLocaleValue caption = (OrmLocaleValue)this.getModel().getValue("caption");
            param = caption == null ? " " : caption.getLocaleValue();
            jsonParamList.put("caption", (Object)param);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition condition = filterGridState.getFilterCondition();
            if (condition != null && !condition.getFilterRow().isEmpty()) {
                jsonParamList.put("filtercondition", (Object)SerializationUtils.toJsonString((Object)condition));
            }
            this.getView().returnDataToParent((Object)jsonParamList);
            this.getView().close();
        }
    }

    private JSONObject getEntryDataJson(DynamicObjectCollection entryEntity) {
        JSONObject result = new JSONObject();
        for (DynamicObject lineData : entryEntity) {
            String name = lineData.getString(NAME);
            String value = lineData.getString(VALUE);
            result.put(name, (Object)value);
        }
        return result;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int index = changeData.getRowIndex();
        if (StringUtils.equals(NAME, key) && newValue != null) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PARAMS);
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryRow;
                String currentLineValue;
                if (i == index || !(currentLineValue = (entryRow = (DynamicObject)entryEntity.get(i)).getString(NAME)).equals(newValue)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6cd5\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d", (String)"PageParamsPlugin_0", (String)"imsc-imic-platform", (Object[])new Object[0]));
                this.getModel().setValue(NAME, oldValue, index);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setParameterOpenType();
        String params = (String)this.getView().getFormShowParameter().getCustomParam("entrypageparams");
        if (StringUtils.isNotBlank(params)) {
            JSONObject paramJson = JSON.parseObject((String)params);
            String filterConditionStr = paramJson.getString("filtercondition");
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            if (StringUtils.isNotBlank(filterConditionStr)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
                filterGrid.SetValue(filterCondition);
            } else {
                filterGrid.SetValue(new FilterCondition());
            }
        }
    }

    private void setParameterOpenType() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String modeltype = (String)parameter.getCustomParam("modeltype");
        ComboEdit modeltypeCombo = (ComboEdit)this.getView().getControl("parametertype");
        ArrayList<ComboItem> modleItem = new ArrayList<ComboItem>();
        switch (modeltype) {
            case "DynamicFormModel": {
                modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355", (String)"PageParamsPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[0])), "FormShowParameter"));
                modeltypeCombo.setComboItems(modleItem);
                break;
            }
            case "BillFormModel": {
                modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e", (String)"PageParamsPlugin_2", (String)"imsc-imic-platform", (Object[])new Object[0])), "BillShowParameter"));
                modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"PageParamsPlugin_3", (String)"imsc-imic-platform", (Object[])new Object[0])), "ListShowParameter"));
                modeltypeCombo.setComboItems(modleItem);
                break;
            }
            case "BaseFormModel": {
                modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"PageParamsPlugin_4", (String)"imsc-imic-platform", (Object[])new Object[0])), "BaseShowParameter"));
                modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"PageParamsPlugin_3", (String)"imsc-imic-platform", (Object[])new Object[0])), "ListShowParameter"));
                modeltypeCombo.setComboItems(modleItem);
                break;
            }
            case "ReportFormModel": {
                modleItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u62a5\u8868", (String)"PageParamsPlugin_5", (String)"imsc-imic-platform", (Object[])new Object[0])), "ReportShowParameter"));
                modeltypeCombo.setComboItems(modleItem);
                break;
            }
            default: {
                modleItem.add(new ComboItem(null, null));
                modeltypeCombo.setComboItems(modleItem);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String params = (String)parameter.getCustomParam("entrypageparams");
        if (StringUtils.isNotBlank(params)) {
            this.setFormValue(params);
        }
    }

    private void setFormValue(String params) {
        JSONObject paramJson = JSON.parseObject((String)params);
        this.setFieldValue("appid", paramJson);
        this.setFieldValue("opentype", paramJson);
        this.setFieldValue("parametertype", paramJson);
        this.setFieldValue("caption", paramJson);
        JSONObject paramsEntry = paramJson.getJSONObject("paramsentry");
        if (paramsEntry != null) {
            for (Map.Entry stringObjectEntry : paramsEntry.entrySet()) {
                String key = (String)stringObjectEntry.getKey();
                Object value = stringObjectEntry.getValue();
                int index = this.getModel().createNewEntryRow(PARAMS);
                this.getModel().setValue(NAME, (Object)key, index);
                this.getModel().setValue(VALUE, value, index);
            }
        }
    }

    private void setFieldValue(String fieldName, JSONObject params) {
        String value = params.getString(fieldName);
        if (StringUtils.isNotBlank(value)) {
            this.getModel().setValue(fieldName, (Object)value);
        }
    }
}

