/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ssc.hstc.common;

import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.ssc.hstc.util.ObjectUtils;

public class TaskDetailPageService {
    private static final Log LOGGER = LogFactory.getLog(TaskDetailPageService.class);

    public static TaskDetailPageService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public boolean ifUpdateCurrentView(IFormView detailView) {
        return ObjectUtils.getBooleanValOfObject(detailView.getPageCache().get("ifupdate_currentview"));
    }

    public void closeCurrentView(IFormView detailView) {
        detailView.getPageCache().put("childview_closeskipcheck", Boolean.TRUE.toString());
        detailView.close();
    }

    public void updateCurrentView(IFormView detailView) {
        detailView.getPageCache().remove("ifupdate_currentview");
        detailView.updateView();
    }

    public void beforeClosed(IFormView detailView, BeforeClosedEvent beforeClosedEvent) {
        boolean ifSkipCheck = ObjectUtils.getBooleanValOfObject(detailView.getPageCache().get("childview_closeskipcheck"));
        if (ifSkipCheck) {
            return;
        }
        String childPageId = detailView.getPageCache().get("childPageId");
        IFormView childView = null;
        try {
            childView = detailView.getViewNoPlugin(childPageId);
        }
        catch (Throwable throwable) {
            LOGGER.error(throwable);
        }
        if (childView != null) {
            childView.close();
        }
    }

    private static class InstanceHolder {
        private static final TaskDetailPageService INSTANCE = new TaskDetailPageService();

        private InstanceHolder() {
        }
    }
}

