/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ssc.hstc.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.ssc.hstc.common.ArtiCheckPointService;
import kd.sdk.ssc.hstc.constant.OperationResultType;
import kd.sdk.ssc.hstc.util.ObjectUtils;

public class TaskHandleService {
    private static final Log LOG = LogFactory.getLog(TaskHandleService.class);

    public static TaskHandleService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public List<String> validateBeforeHandling(IFormView view, Long taskId, Map<String, Object> paramsMap) {
        paramsMap.putIfAbsent("operationResultType", OperationResultType.PROCESSED.getValue());
        paramsMap.putIfAbsent("isFromList", Boolean.FALSE);
        Map<Long, List<String>> errorTipsMap = this.validateBeforeHandling(view, Lists.newArrayList((Object[])new Long[]{taskId}), paramsMap);
        if (errorTipsMap == null || errorTipsMap.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> result = errorTipsMap.get(taskId);
        String errorMsg = String.join((CharSequence)System.lineSeparator(), result);
        if (ObjectUtils.isNotEmpty(errorMsg)) {
            view.showErrorNotification(errorMsg);
        }
        return result;
    }

    public Map<Long, List<String>> validateBeforeHandling(IFormView view, Collection<Long> taskIds, Map<String, Object> paramsMap) {
        boolean isFromList = ObjectUtils.getBooleanValOfObject(paramsMap.get("isFromList"));
        if (isFromList) {
            return new HashMap<Long, List<String>>();
        }
        String operationResultType = ObjectUtils.getStringValOfObject(paramsMap.get("operationResultType"));
        if (!OperationResultType.PROCESSED.getValue().equals(operationResultType)) {
            return new HashMap<Long, List<String>>();
        }
        if (view == null) {
            return new HashMap<Long, List<String>>();
        }
        HashMap<Long, List<String>> resultMap = new HashMap<Long, List<String>>(taskIds.size());
        for (Long taskId : taskIds) {
            String noSelectTip = this.isArtiCheckPointSelected(view.getModel());
            if (noSelectTip == null) continue;
            ArrayList<String> errorTips = (ArrayList<String>)resultMap.get(taskId);
            if (ObjectUtils.isEmpty(errorTips)) {
                errorTips = new ArrayList<String>();
            }
            errorTips.add(noSelectTip);
            resultMap.put(taskId, errorTips);
        }
        return resultMap;
    }

    public String isArtiCheckPointSelected(IDataModel model) {
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return null;
        }
        for (DynamicObject entry : entryentity) {
            if (entry.getBoolean("checkboxfield")) continue;
            return ResManager.loadKDString((String)"\u4eba\u5de5\u68c0\u67e5\u9879\u6ca1\u6709\u68c0\u67e5\u901a\u8fc7\uff0c\u8bf7\u5148\u68c0\u67e5\u901a\u8fc7\u540e\u5e76\u52fe\u9009\u3002", (String)"TaskHandleService_0", (String)"sdk-ssc", (Object[])new Object[0]);
        }
        return null;
    }

    public List<String> doSomethingsAfterHandled(IFormView view, Long taskId, Map<String, Object> paramsMap) {
        paramsMap.putIfAbsent("operationResultType", OperationResultType.PROCESSED.getValue());
        paramsMap.putIfAbsent("isFromList", Boolean.FALSE);
        Map<Long, List<String>> errorTipsMap = this.doSomethingsAfterHandled(view, Lists.newArrayList((Object[])new Long[]{taskId}), paramsMap);
        if (errorTipsMap == null || errorTipsMap.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> result = errorTipsMap.get(taskId);
        String errorMsg = String.join((CharSequence)System.lineSeparator(), result);
        if (ObjectUtils.isNotEmpty(errorMsg)) {
            view.showErrorNotification(errorMsg);
        }
        return result;
    }

    public Map<Long, List<String>> doSomethingsAfterHandled(IFormView view, Collection<Long> taskIds, Map<String, Object> paramsMap) {
        boolean isFromList = ObjectUtils.getBooleanValOfObject(paramsMap.get("isFromList"));
        String operationResultType = ObjectUtils.getStringValOfObject(paramsMap.get("operationResultType"));
        LOG.info("TaskHandleService_doSomethingsAfterHandled, isFromList={}, operationResultType={}", (Object)isFromList, (Object)operationResultType);
        QFilter idFilter = new QFilter("sourcetaskid", "in", taskIds);
        DynamicObject[] taskHistoryDys = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)"id,sourcetaskid,billtype,tasktypeid,billlongid", (QFilter[])new QFilter[]{idFilter});
        if (taskHistoryDys != null) {
            LOG.info("TaskHandleService_doSomethingsAfterHandled, taskHistoryDys={}", (Object)taskHistoryDys.length);
        }
        IDataModel model = null;
        if (view != null) {
            model = view.getModel();
        }
        ArtiCheckPointService.getInstance().saveArtiCheckPoint(model, taskHistoryDys, isFromList, operationResultType);
        return new HashMap<Long, List<String>>();
    }

    private static class InstanceHolder {
        private static final TaskHandleService INSTANCE = new TaskHandleService();

        private InstanceHolder() {
        }
    }
}

