/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.common;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.mobile.common.TeamLeaderApi;

public class UserGroupUtil {
    public static HashSet<Long> getManageGroup(String sscid, String userId) {
        QFilter sscFilter = new QFilter("createorg", "=", (Object)Long.valueOf(sscid));
        Map userGroupMap = BusinessDataServiceHelper.loadFromCache((String)"task_usergroup", (String)"id,entryentity.teamleader,entryentity.userfield.id", (QFilter[])new QFilter[]{sscFilter});
        HashSet<Long> manageSet = new HashSet<Long>(16);
        for (DynamicObject userGroup : userGroupMap.values()) {
            Long userGroupID = userGroup.getLong("id");
            String userID = userGroup.getString("entryentity.userfield.id");
            boolean isLeader = userGroup.getBoolean("entryentity.teamleader");
            if (!isLeader || !userId.equals(userID)) continue;
            manageSet.add(userGroupID);
        }
        return manageSet;
    }

    public static HashSet<String> getManageSsc(Long userId) {
        QFilter leaderFilter = new QFilter("entryentity.teamleader", "=", (Object)"1");
        QFilter userIdFilter = new QFilter("entryentity.userfield.id", "=", (Object)userId);
        Map userGroupMap = BusinessDataServiceHelper.loadFromCache((String)"task_usergroup", (String)"createorg.id", (QFilter[])new QFilter[]{leaderFilter, userIdFilter});
        HashSet<String> manageSscSet = new HashSet<String>(16);
        for (DynamicObject userGroup : userGroupMap.values()) {
            manageSscSet.add(userGroup.getString("createorg.id"));
        }
        return manageSscSet;
    }

    public static boolean isGroupLeader(String userId, String sscId) {
        HashSet<Long> manageGroup = UserGroupUtil.getManageGroup(sscId, userId);
        return !manageGroup.isEmpty();
    }

    public static boolean verifyIdentity(String sscId, String userId, String adminRoleId, IPageCache pageCache) {
        boolean adminRole = TeamLeaderApi.isAdminRole(sscId, Long.valueOf(userId), "HXLFBW8ZGNH");
        if (!adminRole && "/JFEAD2U2A1R".equals(adminRoleId)) {
            adminRole = TeamLeaderApi.isAdminRole(sscId, Long.valueOf(userId), "/JFEAD2U2A1R");
        }
        if (adminRole) {
            pageCache.put("identity", "sysadmin");
            return true;
        }
        if (UserGroupUtil.isGroupLeader(userId, sscId)) {
            pageCache.put("identity", "groupleader");
            return true;
        }
        return false;
    }

    public static boolean isRobotGroup(Long userGroupId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)userGroupId, (String)"task_usergroup", (String)"isrobots");
        return dynamicObject.getBoolean("isrobots");
    }
}

