/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.common.workcalendar;

import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.workcalendar.PersonInfo;
import kd.ssc.task.mobile.common.workcalendar.SscLevelType;
import kd.ssc.task.mobile.common.workcalendar.SscTimeType;
import kd.ssc.task.mobile.common.workcalendar.SscWorkCalendarUtil;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscWorkCalendarLoadService {
    private static Log logger = LogFactory.getLog(SscWorkCalendarLoadService.class);

    public static DynamicObjectCollection loadWorkCalendar(Map<String, String> params) {
        Date dateTo;
        Date dateFrom;
        SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
        try {
            dateFrom = SDF.parse(params.get("year") + "-01-01");
            dateTo = SDF.parse(params.get("year") + "-12-31");
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + e);
            return null;
        }
        QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(params.get("ssc")));
        filters.and(new QFilter("dateentry.date", ">=", (Object)dateFrom));
        filters.and(new QFilter("dateentry.date", "<=", (Object)dateTo));
        if (StringUtils.isNotEmpty((CharSequence)params.get("usergroup"))) {
            filters.and(new QFilter("dateentry.usergroup", "=", (Object)Long.parseLong(params.get("usergroup"))));
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.GROUP.getValue()));
        } else {
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
        }
        return QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"id,dateentry.*", (QFilter[])new QFilter[]{filters});
    }

    public static DynamicObjectCollection getCalendarTimeOfWorkTime(Map<String, String> params) {
        Date date;
        SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
        try {
            date = SDF.parse(params.get("date"));
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + e);
            return null;
        }
        QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(params.get("ssc")));
        filters.and(new QFilter("dateentry.date", "=", (Object)date));
        filters.and(new QFilter("dateentry.timeentry.timetype", "=", (Object)SscTimeType.WORKTIME.getValue()));
        String select = "id,dateentry.id,dateentry.level,dateentry.ssc,dateentry.usergroup,dateentry.datetype,dateentry.timeentry.*";
        return QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)select, (QFilter[])new QFilter[]{filters});
    }

    public static Map<Long, List<String>> getUserByGroupId(String groupId) {
        HashMap<Long, List<String>> map = new HashMap<Long, List<String>>(16);
        DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"task_usergroup");
        DynamicObjectCollection groupUsers = group.getDynamicObjectCollection("entryentity");
        for (DynamicObject groupUser : groupUsers) {
            ArrayList<String> subList = new ArrayList<String>(3);
            DynamicObject user = (DynamicObject)groupUser.get("userfield");
            boolean status = groupUser.getBoolean("usestatus");
            if (!status) continue;
            subList.add(user.getString("name"));
            subList.add(user.getString("phone"));
            map.put(user.getLong("id"), subList);
        }
        return map;
    }

    public static List<PersonInfo> getUserListByGroupId(String groupId) {
        ArrayList<PersonInfo> userList = new ArrayList<PersonInfo>(16);
        DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"task_usergroup");
        DynamicObjectCollection groupUsers = group.getDynamicObjectCollection("entryentity");
        for (DynamicObject groupUser : groupUsers) {
            Object userO = groupUser.get("userfield");
            boolean status = groupUser.getBoolean("usestatus");
            if (userO == null || !status) continue;
            DynamicObject user = (DynamicObject)userO;
            PersonInfo personInfo = new PersonInfo();
            personInfo.setUid(user.getLong("id"));
            personInfo.setUserName(user.getString("name"));
            personInfo.setPhone(user.getString("phone"));
            userList.add(personInfo);
        }
        Collections.sort(userList, new Comparator<PersonInfo>(){

            @Override
            public int compare(PersonInfo o1, PersonInfo o2) {
                return Collator.getInstance(Locale.CHINA).compare(o1.getUserName(), o2.getUserName());
            }
        });
        return userList;
    }

    public static List<Long> getUserIdList(String groupId) {
        QFilter qfilters = new QFilter("id", "=", (Object)CommonUtils.toLong(groupId, -1L));
        DynamicObjectCollection users = QueryServiceHelper.query((String)"task_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{qfilters});
        if (users.size() == 1 && ((DynamicObject)users.get(0)).getString("entryentity.userfield").equals("0")) {
            users.remove(0);
        }
        return users.stream().mapToLong(user -> user.getLong("entryentity.userfield")).boxed().collect(Collectors.toList());
    }

    public static Set<Date> validateDateCalendar(String sscid, Date startworkdate, Date endworkdate) {
        QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(sscid));
        filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
        filters.and(new QFilter("dateentry.date", ">=", (Object)startworkdate));
        filters.and(new QFilter("dateentry.date", "<=", (Object)endworkdate));
        DynamicObjectCollection dateEntrys = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"dateentry.date", (QFilter[])new QFilter[]{filters});
        Set dates = dateEntrys.stream().map(entry -> entry.getDate("dateentry.date")).collect(Collectors.toSet());
        HashSet<Date> selectDates = new HashSet<Date>(SscWorkCalendarUtil.findDates(startworkdate, endworkdate));
        selectDates.removeAll(dates);
        return selectDates;
    }

    public static Map<String, Object> getDynamicObjectType(Object datestart, Object dateend, String sscId) {
        HashMap<String, Object> dynamicObjectTypes = new HashMap<String, Object>(3);
        QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(sscId));
        filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
        filters.and(new QFilter("dateentry.date", ">=", datestart));
        filters.and(new QFilter("dateentry.date", "<=", dateend));
        List workCalendarIds = QueryServiceHelper.queryPrimaryKeys((String)"ssc_workcalendarsetting", (QFilter[])new QFilter[]{filters}, null, (int)-1);
        if (workCalendarIds == null || workCalendarIds.size() == 0) {
            return null;
        }
        DynamicObject[] workCalendars = BusinessDataServiceHelper.load((Object[])workCalendarIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_workcalendarsetting"));
        if (workCalendars == null || workCalendars.length == 0) {
            return null;
        }
        DynamicObjectCollection dateentrys = workCalendars[0].getDynamicObjectCollection("dateentry");
        if (dateentrys == null || dateentrys.size() == 0) {
            return null;
        }
        dynamicObjectTypes.put("dateEntryType", dateentrys.getDynamicObjectType());
        DynamicObjectCollection timeentrys = ((DynamicObject)dateentrys.get(0)).getDynamicObjectCollection("timeentry");
        dynamicObjectTypes.put("timeEntryType", timeentrys.getDynamicObjectType());
        dynamicObjectTypes.put("workCalendars", workCalendars);
        return dynamicObjectTypes;
    }

    public static List<String> getGroup(Object orgId) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)Long.parseLong(orgId + ""));
        DynamicObjectCollection groups = QueryServiceHelper.query((String)"task_usergroup", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return groups.stream().map(group -> group.getString("id")).collect(Collectors.toList());
    }
}

