/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.AbstractFormView;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Label;

public class PageUtils {
    public static void refreshTargetParentPage(IFormView sourceView, String targetFormId) {
        IFormView targetView = PageUtils.getTargetPageView(sourceView, targetFormId);
        if (targetView == null) {
            return;
        }
        targetView.invokeOperation("refresh");
        sourceView.sendFormAction(targetView);
    }

    public static IFormView getTargetPageView(IFormView view, String targetId) {
        if (StringUtils.isNotEmpty((CharSequence)targetId)) {
            for (IFormView targetView = view; targetView != null; targetView = targetView.getParentView()) {
                if (!StringUtils.equals((CharSequence)targetId, (CharSequence)targetView.getEntityId())) continue;
                return targetView;
            }
        }
        return null;
    }

    public static void showTip(IFormView view, String title, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("confirmType", ConfirmTypes.Default.getValue());
        map.put("button_type", MessageBoxOptions.None.getValue());
        map.put("title", title);
        map.put("msg", msg);
        ((AbstractFormView)view).getClientProxy().addAction("showConfirm", map);
    }

    public static void setLabel(IFormView formView, String labelKey, BigDecimal ratio) {
        PageUtils.setLabel(formView, labelKey, ratio, false);
    }

    public static void setLabel(IFormView formView, String labelKey, BigDecimal ratio, boolean inverseColor) {
        Label label = (Label)formView.getControl(labelKey);
        if (ratio != null) {
            String text = ratio.multiply(new BigDecimal("100")).setScale(0, 4) + "%";
            if (ratio.compareTo(BigDecimal.ZERO) > 0) {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                ctrl.put("fc", inverseColor ? "#1BA854" : "#FB2323");
                formView.updateControlMetadata(labelKey, ctrl);
                text = "+" + text;
            } else if (ratio.compareTo(BigDecimal.ZERO) < 0) {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                ctrl.put("fc", inverseColor ? "#FB2323" : "#1BA854");
                formView.updateControlMetadata(labelKey, ctrl);
            } else {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                ctrl.put("fc", "#666666");
                formView.updateControlMetadata(labelKey, ctrl);
                text = "+" + text;
            }
            label.setText(text);
        } else {
            HashMap<String, String> ctrl = new HashMap<String, String>();
            ctrl.put("fc", "#666666");
            formView.updateControlMetadata(labelKey, ctrl);
            label.setText("-");
        }
    }
}

