/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.efficiency;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyModel;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscEfficiencyTaskRankDetailMobFormPlugin
extends SscCardTemplatePlugin {
    public static final String KEY_ENTRY = "entryentity";
    public static final String KEY_DEFUALTFP = "defaultfp";
    public static final String KEY_CONTENTFP = "contenfp";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterBindData(e);
        String sscIdStr = (String)this.getView().getFormShowParameter().getCustomParam("sharecenter");
        if (sscIdStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"SscEfficiencyTaskRankDetailMobFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        this.refreshTaskRankList();
    }

    private void refreshTaskRankList() {
        Long sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        ((Label)this.getView().getControl("ssclabel")).setText(CommonQueryHelper.getNameById("bos_org", sscId));
        DynamicObjectCollection userEntry = QueryServiceHelper.query((String)"task_usergroup", (String)"entryentity.userfield userId, entryentity.userfield.name username, entryentity.userfield.picturefield picture", (QFilter[])new QFilter("createorg", "=", (Object)sscId).toArray());
        HashMap<Long, DynamicObject> userMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject ue : userEntry) {
            long userId = ue.getLong("userId");
            if (userId <= 0L || userMap.containsKey(userId)) continue;
            userMap.put(userId, ue);
        }
        if (userMap.isEmpty()) {
            IFormView view = this.getView();
            view.setVisible(Boolean.FALSE, new String[]{KEY_CONTENTFP});
            view.setVisible(Boolean.TRUE, new String[]{KEY_DEFUALTFP});
            return;
        }
        LocalDate now = LocalDate.now();
        LocalDate firstDayOfLastMonth = now.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        Date beginQueryDate = CommonUtils.localDate2Date(firstDayOfLastMonth);
        Date endQueryDate = CommonUtils.localDate2Date(now.with(TemporalAdjusters.lastDayOfMonth()).plusDays(1L));
        QFilter filters = new QFilter("sscid", "=", (Object)sscId).and("pooltype", "=", (Object)"2").and("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK).and("completetime", ">=", (Object)beginQueryDate).and("completetime", "<", (Object)endQueryDate);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id, personid, coefficient, completetime", (QFilter[])filters.toArray());
        if (tasks.isEmpty()) {
            ((Label)this.getControl("defaultlabel")).setText(ResManager.loadKDString((String)"\u672c\u6708\u672a\u53d1\u73b0\u5df2\u5904\u7406\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u5f00\u5c55\u5ba1\u6838\u5de5\u4f5c\u3002", (String)"SscEfficiencyTaskRankDetailMobFormPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]));
            IFormView view = this.getView();
            view.setVisible(Boolean.FALSE, new String[]{KEY_CONTENTFP});
            view.setVisible(Boolean.TRUE, new String[]{KEY_DEFUALTFP});
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Map<String, List<DynamicObject>> taskGroupByMonth = tasks.stream().collect(Collectors.groupingBy(t -> format.format(t.getDate("completetime"))));
        List<DynamicObject> taskOfCurMonth = taskGroupByMonth.get(format.format(new Date()));
        List<DynamicObject> taskOfLastMonth = taskGroupByMonth.get(format.format(beginQueryDate));
        Map<Long, List<DynamicObject>> taskGroupByUserOfCurMonth = taskOfCurMonth != null ? taskOfCurMonth.stream().collect(Collectors.groupingBy(e -> e.getLong("personid"))) : Collections.EMPTY_MAP;
        Map<Long, List<DynamicObject>> taskGroupByUserOfLastMonth = taskOfLastMonth != null ? taskOfLastMonth.stream().collect(Collectors.groupingBy(e -> e.getLong("personid"))) : Collections.EMPTY_MAP;
        ArrayList<EfficiencyModel> entryList = new ArrayList<EfficiencyModel>();
        HashMap<Long, EfficiencyModel> dataOfLastMonth = new HashMap<Long, EfficiencyModel>();
        BigDecimal zero = BigDecimal.ZERO.setScale(1, 4);
        for (Map.Entry e2 : userMap.entrySet()) {
            Long userId = (Long)e2.getKey();
            DynamicObject user = (DynamicObject)e2.getValue();
            List<DynamicObject> taskOfOneUser = taskGroupByUserOfCurMonth.get(userId);
            List<DynamicObject> taskOfOneUserOfLastMonth = taskGroupByUserOfLastMonth.get(userId);
            BigDecimal taskCount = zero;
            if (taskOfOneUser != null) {
                for (DynamicObject task : taskOfOneUser) {
                    BigDecimal curTask = task.getBigDecimal("coefficient");
                    if (curTask.compareTo(BigDecimal.ZERO) <= 0) {
                        curTask = BigDecimal.ONE;
                    }
                    taskCount = taskCount.add(curTask);
                }
            }
            entryList.add(new EfficiencyModel(userId, user.getString("username"), user.getString("picture"), taskCount.setScale(1, 4)));
            BigDecimal taskCountOfLastMonth = zero;
            if (taskOfOneUserOfLastMonth != null) {
                taskCountOfLastMonth = taskOfOneUserOfLastMonth.stream().map(t -> t.getBigDecimal("coefficient")).reduce(BigDecimal::add).orElse(zero);
            }
            dataOfLastMonth.put(userId, new EfficiencyModel(userId, null, null, taskCountOfLastMonth.setScale(1, 4)));
        }
        if (!dataOfLastMonth.isEmpty()) {
            List sortedLastData = dataOfLastMonth.values().stream().sorted((a, b) -> b.getTaskOfUser().compareTo(a.getTaskOfUser())).collect(Collectors.toList());
            int size = sortedLastData.size();
            ((EfficiencyModel)sortedLastData.get(0)).setTaskRankOfUser(1);
            for (int i = 1; i < size; ++i) {
                EfficiencyModel cur = (EfficiencyModel)sortedLastData.get(i);
                EfficiencyModel last = (EfficiencyModel)sortedLastData.get(i - 1);
                if (cur.getTaskOfUser().compareTo(last.getTaskOfUser()) == 0) {
                    cur.setTaskRankOfUser(last.getTaskRankOfUser());
                    continue;
                }
                cur.setTaskRankOfUser(i + 1);
            }
        }
        entryList.sort((a, b) -> b.getTaskOfUser().compareTo(a.getTaskOfUser()));
        int size2 = entryList.size();
        for (int i = 0; i < size2; ++i) {
            EfficiencyModel cur = (EfficiencyModel)entryList.get(i);
            if (i == 0) {
                cur.setTaskRankOfUser(1);
            } else {
                EfficiencyModel last = entryList.get(i - 1);
                if (cur.getTaskOfUser().compareTo(last.getTaskOfUser()) == 0) {
                    cur.setTaskRankOfUser(last.getTaskRankOfUser());
                } else {
                    cur.setTaskRankOfUser(i + 1);
                }
            }
            EfficiencyModel compareData = (EfficiencyModel)dataOfLastMonth.get(cur.getUserId());
            if (compareData == null) continue;
            int rank = compareData.getTaskRankOfUser() - cur.getTaskRankOfUser();
            cur.setChangedTaskRankOfUser(rank < 0 ? rank + "" : (rank > 0 ? "+" + rank : "+0"));
        }
        this.createRows(entryList);
    }

    private void createRows(ArrayList<EfficiencyModel> entryData) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        model.beginInit();
        int size = entryData.size();
        model.batchCreateNewEntryRow(KEY_ENTRY, size);
        DynamicObjectCollection efficiencyEntryEntity = model.getEntryEntity(KEY_ENTRY);
        DynamicProperty rank = efficiencyEntryEntity.getDynamicObjectType().getProperty("rank");
        DynamicProperty username = efficiencyEntryEntity.getDynamicObjectType().getProperty("username");
        DynamicProperty taskCount = efficiencyEntryEntity.getDynamicObjectType().getProperty("taskcount");
        DynamicProperty rankChange = efficiencyEntryEntity.getDynamicObjectType().getProperty("rankchange");
        DynamicProperty picture = efficiencyEntryEntity.getDynamicObjectType().getProperty("picture");
        for (int i = 0; i < size; ++i) {
            EfficiencyModel efficiencyModel = entryData.get(i);
            DynamicObject entry = (DynamicObject)efficiencyEntryEntity.get(i);
            rank.setValueFast((Object)entry, (Object)efficiencyModel.getTaskRankOfUser());
            username.setValueFast((Object)entry, (Object)efficiencyModel.getUserName());
            taskCount.setValueFast((Object)entry, (Object)efficiencyModel.getTaskOfUser());
            rankChange.setValueFast((Object)entry, (Object)efficiencyModel.getChangedTaskRankOfUser());
            picture.setValueFast((Object)entry, (Object)efficiencyModel.getPicture());
        }
        model.endInit();
        IFormView view = this.getView();
        view.updateView(KEY_ENTRY);
        view.setVisible(Boolean.FALSE, new String[]{KEY_DEFUALTFP});
        view.setVisible(Boolean.TRUE, new String[]{KEY_CONTENTFP});
    }
}

