/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.exhibit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.index.SscTaskIndexPlugin;

public class SscShareCardPlugin
extends AbstractMobFormPlugin {
    protected static final String CTRL_CARD_COMTAINER = "cardcontainer";
    protected static final String TAG_IS_SELF = "showtag";
    private static final String CTRL_BTN_BACK_INDEX = "btnbackindex";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_BACK_INDEX});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)CTRL_BTN_BACK_INDEX, (CharSequence)optKey)) {
            this.btnBackIndex();
        }
    }

    public void afterCreateNewData(EventObject e) {
        String userId;
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object sharecenter = parameter.getCustomParam("sharecenter");
        if (sharecenter == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u4eab\u94fe\u63a5\u6709\u8bef,\u672a\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"SscShareCardPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
            return;
        }
        Object usergroup = parameter.getCustomParam("usergroup");
        Label label_sharecenter = (Label)this.getView().getControl("sharecenter");
        Label label_usergroup = (Label)this.getView().getControl("usergroup");
        label_sharecenter.setText(CommonQueryHelper.getShareCenterName(Long.valueOf(String.valueOf(sharecenter))));
        label_usergroup.setText(CommonQueryHelper.getUserGroupName(Long.valueOf(String.valueOf(usergroup))));
        Object userid = parameter.getCustomParam("uid");
        if (userid != null && (userId = RequestContext.get().getUserId()).equals(String.valueOf(userid))) {
            this.getModel().setValue(TAG_IS_SELF, (Object)1);
        }
        String formIdsStr = (String)parameter.getCustomParam("formIds");
        this.addCustomCards(formIdsStr, sharecenter, usergroup);
    }

    protected void addCustomCards(String formIdsStr, Object sscId, Object usergroup) {
        Container cardcontainer = (Container)this.getView().getControl(CTRL_CARD_COMTAINER);
        if (StringUtils.isNotEmpty((CharSequence)formIdsStr)) {
            String[] formIds = formIdsStr.split(",");
            cardcontainer.deleteControls(formIds);
            FlexPanelAp flex = new FlexPanelAp();
            for (String formId : formIds) {
                flex.setKey(formId);
                flex.setGrow(0);
                flex.setShrink(0);
                flex.setRadius("8px");
                ArrayList<Map> list = new ArrayList<Map>(1);
                list.add(flex.createControl());
                cardcontainer.addControls(list);
                this.addCard(formId, sscId, usergroup);
            }
        }
    }

    protected void addCard(String formId, Object sscId, Object usergroup) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(formId);
        showParameter.setCustomParam("sharecenter", sscId);
        showParameter.setCustomParam("usergroup", usergroup);
        Object value = this.getModel().getValue(TAG_IS_SELF);
        if (!Objects.equals(value, 1)) {
            showParameter.setCustomParam("onlyRead", (Object)"true");
        }
        showParameter.setCustomParam("CARD_IS_SHARE", (Object)"true");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void btnBackIndex() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object sharecenter = parameter.getCustomParam("sharecenter");
        Object usergroup = parameter.getCustomParam("usergroup");
        SscTaskIndexPlugin.backToIndex(this.getView(), sharecenter, usergroup);
    }
}

