/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.url.UrlService;
import kd.ssc.task.mobile.common.CustomCtrlPropHelper;
import kd.ssc.task.mobile.common.UserParameterHelper;
import kd.ssc.task.mobile.formplugin.PageUtils;
import kd.ssc.task.mobile.utils.OperationLogUtil;

public class SscCardTemplatePlugin
extends AbstractMobFormPlugin {
    public static final Log logger = LogFactory.getLog(SscCardTemplatePlugin.class);
    private static final String CONTROLID_CC_POPOVER = "cc_icon_popover";
    private static final String RUN_ON_PLATFORM = "RUN_ON_PLATFORM";
    private static final String POPOVER_MENU_CARD_MANAGER = "CARD_MANAGER";
    private static final String POPOVER_MENU_SHARE = "SHARE";
    private static final String CARD_MANAGER_CP_REMOVE = "REMOVE";
    private static final String CARD_MANAGER_CP_ADD = "ADD";
    public static final String CACHE_SHARE_VALUE = "CACHE_SHARE_VALUE";
    public static final String PROP_DATA_TAG = "datatag";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object onlyRead = parameter.getCustomParam("onlyRead");
        if ("true".equals(onlyRead)) {
            this.onlyRead();
        }
    }

    protected void registerParentView(String ... parentFormIds) {
        if (ArrayUtils.isNotEmpty((Object[])parentFormIds)) {
            for (String targetParentFormId : parentFormIds) {
                IFormView targetParentPageView = PageUtils.getTargetPageView(this.getView(), targetParentFormId);
                if (targetParentPageView == null) continue;
                targetParentPageView.getPageCache().put(this.getView().getParentView().getFormShowParameter().getFormId() + "#" + this.getView().getFormShowParameter().getFormId(), this.getView().getPageId());
            }
        }
    }

    protected IFormView getCardViewFromParent(String parentFormId, String cardFormId) {
        IFormView parentView = PageUtils.getTargetPageView(this.getView(), parentFormId);
        if (parentView != null) {
            String pageId = parentView.getPageCache().get(parentFormId + "#" + cardFormId);
            return this.getView().getView(pageId);
        }
        return null;
    }

    protected void onlyRead() {
    }

    protected void setPropDataTag(int dataTag) {
        this.getModel().setValue(PROP_DATA_TAG, (Object)dataTag);
    }

    protected void setNoDataView(String tip) {
        Label defaultlabel = (Label)this.getControl("defaultlabel");
        defaultlabel.setText(tip);
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        if (CONTROLID_CC_POPOVER.equals(key) && "click".equals(eventName)) {
            String eventArgs = e.getEventArgs();
            Map popoverInfo = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            String id = popoverInfo.getOrDefault("id", "");
            if (id.equals(POPOVER_MENU_CARD_MANAGER)) {
                String params = popoverInfo.getOrDefault("customer_params", "");
                if (CARD_MANAGER_CP_ADD.equals(params)) {
                    this.addCard(this.getView().getFormShowParameter().getFormId());
                } else if (CARD_MANAGER_CP_REMOVE.equals(params)) {
                    this.removeCard(this.getView().getFormShowParameter().getFormId());
                }
            } else if (id.equals(POPOVER_MENU_SHARE)) {
                this.shareTo();
            }
        } else if (CONTROLID_CC_POPOVER.equals(key) && "PlatformInfo".equals(eventName)) {
            String eventArgs = e.getEventArgs();
            Map platformInfo = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            String platformId = platformInfo.getOrDefault("platformId", "");
            this.getPageCache().put(RUN_ON_PLATFORM, platformId);
            this.customPopoverMenu(platformId, null);
        }
    }

    private void customPopoverMenu(String platformId, String customCards) {
        ArrayList<LinkedHashMap<String, String>> menus = new ArrayList<LinkedHashMap<String, String>>();
        Object onlyRead = this.getView().getFormShowParameter().getCustomParam("onlyRead");
        if (!"true".equals(onlyRead)) {
            if ("yzj".equals(platformId)) {
                menus.add(this.createMenu(POPOVER_MENU_SHARE, ResManager.loadKDString((String)"\u5206\u4eab", (String)"SscCardTemplatePlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]), "cp"));
            }
            if (customCards == null) {
                customCards = UserParameterHelper.getCustomCard();
            }
            if (customCards != null && customCards.contains(this.getView().getFormShowParameter().getFormId())) {
                menus.add(this.createMenu(POPOVER_MENU_CARD_MANAGER, ResManager.loadKDString((String)"\u79fb\u51fa\u9996\u9875", (String)"SscCardTemplatePlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]), CARD_MANAGER_CP_REMOVE));
            } else {
                menus.add(this.createMenu(POPOVER_MENU_CARD_MANAGER, ResManager.loadKDString((String)"\u653e\u5230\u9996\u9875", (String)"SscCardTemplatePlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]), CARD_MANAGER_CP_ADD));
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("menus", menus);
        data.put("datetime", String.valueOf(new Date().getTime()));
        CustomCtrlPropHelper.setCustomCtrlProp(this.getView(), CONTROLID_CC_POPOVER, data, Boolean.FALSE);
    }

    private LinkedHashMap<String, String> createMenu(String id, String name, String cp) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("id", id);
        map.put("name", name);
        map.put("customer_params", cp);
        return map;
    }

    private void addCard(String cardFormId) {
        String customCards = UserParameterHelper.getCustomCard();
        if (StringUtils.isBlank((CharSequence)customCards)) {
            UserParameterHelper.saveCustomCard(cardFormId);
            this.refreshCustomPopover(cardFormId);
            this.refreshIndex(cardFormId);
        } else {
            String[] split = customCards.split(",");
            List strings = Arrays.stream(split).collect(Collectors.toList());
            strings.add(cardFormId);
            LinkedHashSet linkedHashSet = new LinkedHashSet(strings);
            String join = String.join((CharSequence)",", linkedHashSet);
            UserParameterHelper.saveCustomCard(join);
            this.refreshCustomPopover(join);
            this.refreshIndex(join);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6dfb\u52a0\u5230\u9996\u9875\u3002", (String)"SscCardTemplatePlugin_5", (String)"ssc-task-mobile", (Object[])new Object[0]));
    }

    private void removeCard(String cardFormId) {
        String customCards = UserParameterHelper.getCustomCard();
        if (StringUtils.isNotBlank((CharSequence)customCards)) {
            String[] split = customCards.split(",");
            String collect = Arrays.stream(split).filter(s -> !s.equals(cardFormId)).collect(Collectors.joining(","));
            UserParameterHelper.saveCustomCard(collect);
            this.refreshCustomPopover(collect);
            this.refreshIndex(collect);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u4ece\u9996\u9875\u79fb\u51fa\u3002", (String)"SscCardTemplatePlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]));
    }

    private void refreshCustomPopover(String cards) {
        String platformId = this.getPageCache().get(RUN_ON_PLATFORM);
        this.customPopoverMenu(platformId, cards);
    }

    private void refreshIndex(String cards) {
        IFormView targetPageView = PageUtils.getTargetPageView(this.getView(), "ssc_index_m");
        if (targetPageView != null) {
            targetPageView.getPageCache().put("cache_custom_cards_formIds", cards);
            targetPageView.invokeOperation("refresh");
            this.getView().sendFormAction(targetPageView);
        }
    }

    private void shareTo() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("event", "share");
        args.put("shareType", "4");
        args.put("appName", ResManager.loadKDString((String)"\u5171\u4eab\u6d1e\u5bdf", (String)"SscCardTemplatePlugin_8", (String)"ssc-task-mobile", (Object[])new Object[0]));
        args.put("title", "");
        args.put("content", "");
        args.put("cellContent", "");
        args.put("sharedObject", "all");
        args.put("datetime", new Date().getTime());
        this.fillSscCardShareParam(args);
        Object yunzhijiaAppId = this.getYunzhijiaAppId();
        if (StringUtils.isBlank((Object)yunzhijiaAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5173\u8054\u4e91\u4e4b\u5bb6\u8f7b\u5e94\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7ef4\u62a4\u7cfb\u7edf\u53c2\u6570\u3002", (String)"SscCardTemplatePlugin_6", (String)"ssc-task-mobile", (Object[])new Object[0]));
            return;
        }
        args.put("appId", yunzhijiaAppId);
        args.put("lightAppId", yunzhijiaAppId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", "share");
        map.put("args", args);
        this.getView().executeClientCommand("callYZJApi", new Object[]{map});
        OperationLogUtil.log(ResManager.loadKDString((String)"\u5206\u4eab\u5361\u7247", (String)"SscCardTemplatePlugin_9", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u4eab\u5361\u7247\u6210\u529f", (String)"SscCardTemplatePlugin_10", (String)"ssc-task-mobile", (Object[])new Object[0]), this.getView().getEntityId());
    }

    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        args.put("webpageUrl", this.getWebpageUrl());
    }

    protected String getShareContent(String format) {
        String shareValue = this.getPageCache().get(CACHE_SHARE_VALUE);
        if (StringUtils.isBlank((CharSequence)shareValue)) {
            return ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"SscCardTemplatePlugin_7", (String)"ssc-task-mobile", (Object[])new Object[0]);
        }
        return String.format(format, shareValue);
    }

    protected String getShareContent(String format, String defaultBack) {
        String shareValue = this.getPageCache().get(CACHE_SHARE_VALUE);
        if (StringUtils.isBlank((CharSequence)shareValue)) {
            return defaultBack;
        }
        return String.format(format, shareValue);
    }

    private Object getYunzhijiaAppId() {
        AppParam appParam = new AppParam("83bfebc8000020ac", "12", Long.valueOf(OrgUnitServiceHelper.getRootOrgId()), Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"ssc_yzj_appid");
    }

    protected String getWebpageUrl() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object sharecenter = parameter.getCustomParam("sharecenter");
        Object usergroup = parameter.getCustomParam("usergroup");
        String accountId = RequestContext.get().getAccountId();
        Long userId = RequestContext.get().getCurrUserId();
        return String.format("%s/mobile.html?form=ssc_share_card_m&uid=%s&sharecenter=%s&usergroup=%s&formIds=%s&accountId=%s", UrlService.getDomainContextUrl(), userId, sharecenter, usergroup, this.getView().getFormShowParameter().getFormId(), accountId);
    }

    protected Long getSscid() {
        Object sharecenter = this.getView().getFormShowParameter().getCustomParam("sharecenter");
        if (sharecenter == null) {
            return null;
        }
        return Long.valueOf(String.valueOf(sharecenter));
    }

    protected Long getUsergroup() {
        Object usergroup = this.getView().getFormShowParameter().getCustomParam("usergroup");
        if (usergroup == null) {
            return null;
        }
        return Long.valueOf(String.valueOf(usergroup));
    }
}

