/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceCheckItemDataHelper;

public class SscIntelligenceArtiCheckItemDetailFormPlugin
extends AbstractMobFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill = SscIntelligenceCheckItemDataHelper.getCheckItemIdListMapByTaskBill(this.getSscId());
        this.initialPermPanel();
        this.initialTaskPanel(checkItemIdListMapByTaskBill);
        this.initialTaskBillPanel(checkItemIdListMapByTaskBill);
        this.initialArtiCheckItemList(checkItemIdListMapByTaskBill);
    }

    private void initialPermPanel() {
        Label sscLabel = (Label)this.getControl("label_ssc");
        sscLabel.setText(CommonQueryHelper.getNameById("bos_org", this.getSscId()));
        Label groupLabel = (Label)this.getControl("label_group");
        groupLabel.setText(ResManager.loadKDString((String)"\u5168\u90e8\u7528\u6237\u7ec4", (String)"SscIntelligenceArtiCheckItemDetailFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
    }

    private void initialTaskPanel(Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill) {
        int allInteCheckItemCount = 0;
        int allArtiCheckItemCount = 0;
        Label inteCheckPercentLabel = (Label)this.getControl("inte_checkitem_percent");
        Label artificialCountLabel = (Label)this.getControl("arti_check_count");
        Label intelligenceCountLabel = (Label)this.getControl("inte_check_count");
        if (CollectionUtils.isEmpty(checkItemIdListMapByTaskBill)) {
            inteCheckPercentLabel.setText("-");
            artificialCountLabel.setText(String.valueOf(allArtiCheckItemCount));
            intelligenceCountLabel.setText(String.valueOf(allInteCheckItemCount));
            return;
        }
        allInteCheckItemCount = SscIntelligenceCheckItemDataHelper.getInteCheckItemCountByInteScheme(checkItemIdListMapByTaskBill, -1L);
        allArtiCheckItemCount = checkItemIdListMapByTaskBill.values().stream().map(booleanSetMap -> ((Set)booleanSetMap.get(Boolean.FALSE)).size()).reduce(Integer::sum).orElse(0);
        if (allArtiCheckItemCount + allInteCheckItemCount == 0) {
            inteCheckPercentLabel.setText("0.0%");
        } else {
            String inteCheckPercent = new BigDecimal(allInteCheckItemCount).multiply(new BigDecimal(100)).divide(new BigDecimal(allArtiCheckItemCount + allInteCheckItemCount), 1, 4).toString();
            inteCheckPercentLabel.setText(inteCheckPercent + "%");
        }
        artificialCountLabel.setText(String.valueOf(allArtiCheckItemCount));
        intelligenceCountLabel.setText(String.valueOf(allInteCheckItemCount));
    }

    private void initialTaskBillPanel(Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill) {
        Long taskBillId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("task_bill_id"));
        int allInteCheckItemCount = SscIntelligenceCheckItemDataHelper.getInteCheckItemCountByInteScheme(checkItemIdListMapByTaskBill, taskBillId);
        int allArtiCheckItemCount = checkItemIdListMapByTaskBill.get(taskBillId).get(Boolean.FALSE).size();
        DynamicObject taskBill = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)taskBillId).toArray());
        Label billName = (Label)this.getControl("bill_name");
        billName.setText(taskBill.getString("name"));
        Label intecheckitemTotalcount = (Label)this.getControl("intecheckitem_totalcount");
        intecheckitemTotalcount.setText(allInteCheckItemCount + "/" + (allInteCheckItemCount + allArtiCheckItemCount));
        Label inteCheckitemOfBill = (Label)this.getControl("inte_checkitem_bill");
        if (allArtiCheckItemCount + allInteCheckItemCount == 0) {
            inteCheckitemOfBill.setText("0.0%");
        } else {
            String inteCheckPercent = new BigDecimal(allInteCheckItemCount).multiply(new BigDecimal(100)).divide(new BigDecimal(allArtiCheckItemCount + allInteCheckItemCount), 1, 4).toString();
            inteCheckitemOfBill.setText(inteCheckPercent + "%");
        }
    }

    private void initialArtiCheckItemList(Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill) {
        Long taskBillId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("task_bill_id"));
        Set<Long> artiCheckItemIds = checkItemIdListMapByTaskBill.get(taskBillId).get(Boolean.FALSE);
        if (CollectionUtils.isEmpty(artiCheckItemIds)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            return;
        }
        DynamicObjectCollection artiCheckItems = QueryServiceHelper.query((String)"task_checkpoint", (String)"id,number,name", (QFilter[])new QFilter("id", "in", artiCheckItemIds).toArray());
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        int size = artiCheckItems.size();
        model.batchCreateNewEntryRow("entryentity", size);
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
        DynamicProperty itemSequence = dynamicObjects.getDynamicObjectType().getProperty("item_sequence");
        DynamicProperty itemDetail = dynamicObjects.getDynamicObjectType().getProperty("item_detail");
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)artiCheckItems.get(i);
            DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
            itemSequence.setValueFast((Object)entry, (Object)String.format(ResManager.loadKDString((String)"\u4eba\u5de5\u68c0\u67e5\u9879%s\uff1a", (String)"SscIntelligenceArtiCheckItemDetailFormPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]), i + 1));
            itemDetail.setValueFast((Object)entry, (Object)dynamicObject.getString("name"));
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Long getGroupId() {
        return Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("usergroup"));
    }

    private Long getSscId() {
        Long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        }
        return sscId;
    }
}

