/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.util.CollectionUtils;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.PageUtils;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceCheckItemDataHelper;

public class SscIntelligenceCheckItemCardFormPlugin
extends SscCardTemplatePlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"detail_label", "vector_tip"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initialIntelligenceCheckItemPercent();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"vector_tip")) {
            PageUtils.showTip(this.getView(), ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u81ea\u52a8\u5316\u7387", (String)"SscIntelligenceCheckItemCardFormPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u4e0b\u81ea\u52a8\u5316\u68c0\u67e5\u9879\u5360\u603b\u68c0\u67e5\u9879\u7684\u6bd4\u4f8b", (String)"SscIntelligenceCheckItemCardFormPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"detail_label")) {
            this.jumpToInteCheckItemDetailDistributePage();
        }
    }

    private void initialIntelligenceCheckItemPercent() {
        int allInteCheckItemCount = 0;
        int allArtiCheckItemCount = 0;
        Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill = SscIntelligenceCheckItemDataHelper.getCheckItemIdListMapByTaskBill(this.getSscid());
        Label inteCheckPercentLabel = (Label)this.getControl("label_intecheck_percent");
        Label artificialCountLabel = (Label)this.getControl("artificial_count");
        Label intelligenceCountLabel = (Label)this.getControl("intelligence_count");
        if (CollectionUtils.isEmpty(checkItemIdListMapByTaskBill)) {
            inteCheckPercentLabel.setText("-");
            artificialCountLabel.setText(String.valueOf(allArtiCheckItemCount));
            intelligenceCountLabel.setText(String.valueOf(allInteCheckItemCount));
            if (this.getPageCache().get("CACHE_SHARE_VALUE") == null) {
                this.getPageCache().put("CACHE_SHARE_VALUE", "-");
            }
            return;
        }
        allInteCheckItemCount = SscIntelligenceCheckItemDataHelper.getInteCheckItemCountByInteScheme(checkItemIdListMapByTaskBill, -1L);
        allArtiCheckItemCount = checkItemIdListMapByTaskBill.values().stream().map(booleanSetMap -> ((Set)booleanSetMap.get(Boolean.FALSE)).size()).reduce(Integer::sum).orElse(0);
        if (allArtiCheckItemCount + allInteCheckItemCount == 0) {
            inteCheckPercentLabel.setText("0.0%");
            if (this.getPageCache().get("CACHE_SHARE_VALUE") == null) {
                this.getPageCache().put("CACHE_SHARE_VALUE", "0.0%");
            }
        } else {
            String inteCheckPercent = new BigDecimal(allInteCheckItemCount).multiply(new BigDecimal(100)).divide(new BigDecimal(allArtiCheckItemCount + allInteCheckItemCount), 1, 4).toString();
            inteCheckPercentLabel.setText(inteCheckPercent + "%");
            if (this.getPageCache().get("CACHE_SHARE_VALUE") == null) {
                this.getPageCache().put("CACHE_SHARE_VALUE", inteCheckPercent + "%");
            }
        }
        artificialCountLabel.setText(String.valueOf(allArtiCheckItemCount));
        intelligenceCountLabel.setText(String.valueOf(allInteCheckItemCount));
    }

    private void jumpToInteCheckItemDetailDistributePage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_checkitem_detail_m");
        parameter.setCaption(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u81ea\u52a8\u5316\u7387", (String)"SscIntelligenceCheckItemCardFormPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("sharecenter", (Object)this.getSscid().toString());
        parameter.setCustomParam("usergroup", (Object)this.getUsergroup().toString());
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.InteCheckItemPercentCard.getCaption());
        String content = this.getShareContent(ResManager.loadKDString((String)"\u5f53\u524d\u81ea\u52a8\u5316\u7387\uff1a%s", (String)"SscIntelligenceCheckItemCardFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        args.put("content", content);
        args.put("cellContent", content);
    }
}

