/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class SscIntelligenceCheckItemDataHelper {
    private static final Log log = LogFactory.getLog(SscIntelligenceCheckItemDataHelper.class);

    protected static Map<Long, Map<Boolean, Set<Long>>> getCheckItemIdListMapByTaskBill(Long sscId) {
        HashMap<Long, Map<Boolean, Set<Long>>> checkItemsMapOfTaskBill = new HashMap<Long, Map<Boolean, Set<Long>>>();
        DynamicObjectCollection taskBills = QueryServiceHelper.query((String)"task_taskbill", (String)"id,number,name,entryentity.childpkid", (QFilter[])new QFilter("ssccenter", "=", (Object)sscId).toArray());
        if (CollectionUtils.isEmpty((Collection)taskBills)) {
            return checkItemsMapOfTaskBill;
        }
        List childPkIds = taskBills.stream().map(dy -> dy.getLong("entryentity.childpkid")).collect(Collectors.toList());
        DataSet InteCheckItemDataSet = DB.queryDataSet((String)"kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceCheckItemDataHelper", (DBRoute)DBRoute.of((String)"ssc"), (String)("SELECT fid,fbasedataid FROM t_tk_idischemaconf where " + new QFilter("fid", "in", (Object)childPkIds.toArray())));
        DataSet artiCheckItemDataSet = DB.queryDataSet((String)"kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceCheckItemDataHelper", (DBRoute)DBRoute.of((String)"ssc"), (String)("SELECT fid,fbasedataid FROM t_tk_articheckpointconfig where " + new QFilter("fid", "in", (Object)childPkIds.toArray())));
        ORM orm = ORM.create();
        for (DynamicObject taskBill : taskBills) {
            HashSet<Long> inteBaseDataIds = new HashSet<Long>();
            DataSet inteBaseIdDataSet = InteCheckItemDataSet.copy().filter("fid = " + taskBill.getLong("entryentity.childpkid")).select("fbasedataid");
            for (Row row : inteBaseIdDataSet) {
                inteBaseDataIds.add(row.getLong("fbasedataid"));
            }
            HashSet<Long> artiBaseDataIds = new HashSet<Long>();
            DataSet artiBaseIdDataSet = artiCheckItemDataSet.copy().filter("fid = " + taskBill.getLong("entryentity.childpkid")).select("fbasedataid");
            for (Row row : artiBaseIdDataSet) {
                artiBaseDataIds.add(row.getLong("fbasedataid"));
            }
            Map oldCheckItemMap = (Map)checkItemsMapOfTaskBill.get(taskBill.getLong("id"));
            if (CollectionUtils.isEmpty((Map)oldCheckItemMap)) {
                HashMap<Boolean, HashSet<Long>> InteOrArtiCheckItem = new HashMap<Boolean, HashSet<Long>>();
                InteOrArtiCheckItem.put(Boolean.TRUE, inteBaseDataIds);
                InteOrArtiCheckItem.put(Boolean.FALSE, artiBaseDataIds);
                checkItemsMapOfTaskBill.put(taskBill.getLong("id"), InteOrArtiCheckItem);
                continue;
            }
            ((Set)oldCheckItemMap.get(Boolean.TRUE)).addAll(inteBaseDataIds);
            ((Set)oldCheckItemMap.get(Boolean.FALSE)).addAll(artiBaseDataIds);
        }
        InteCheckItemDataSet.close();
        artiCheckItemDataSet.close();
        return checkItemsMapOfTaskBill;
    }

    public static int getInteCheckItemCountByInteScheme(Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill, Long taskBillId) {
        int totalItemCount = 0;
        Map<Long, Integer> schemeItemCountMap = SscIntelligenceCheckItemDataHelper.getSchemeItemCountMap(checkItemIdListMapByTaskBill, taskBillId);
        if (taskBillId != -1L) {
            Set<Long> inteSchemeIds = checkItemIdListMapByTaskBill.get(taskBillId).get(Boolean.TRUE);
            for (Long inteSchemeId : inteSchemeIds) {
                totalItemCount += schemeItemCountMap.get(inteSchemeId).intValue();
            }
        } else {
            for (Map.Entry<Long, Map<Boolean, Set<Long>>> longMapEntry : checkItemIdListMapByTaskBill.entrySet()) {
                Set<Long> inteSchemeIds = longMapEntry.getValue().get(Boolean.TRUE);
                for (Long inteSchemeId : inteSchemeIds) {
                    totalItemCount += schemeItemCountMap.get(inteSchemeId).intValue();
                }
            }
        }
        return totalItemCount;
    }

    private static Map<Long, Integer> getSchemeItemCountMap(Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill, Long taskBillId) {
        HashSet inteCheckSchemSet = new HashSet();
        if (taskBillId != -1L) {
            inteCheckSchemSet.addAll(checkItemIdListMapByTaskBill.get(taskBillId).get(Boolean.TRUE));
        } else {
            for (Map.Entry<Long, Map<Boolean, Set<Long>>> longMapEntry : checkItemIdListMapByTaskBill.entrySet()) {
                inteCheckSchemSet.addAll(longMapEntry.getValue().get(Boolean.TRUE));
            }
        }
        HashMap<Long, Integer> longHashMap = new HashMap<Long, Integer>();
        DynamicObjectCollection schemeJsons = QueryServiceHelper.query((String)"idi_schema", (String)"id,rule_tag", (QFilter[])new QFilter("id", "in", inteCheckSchemSet).toArray());
        ObjectMapper objectMapper = new ObjectMapper();
        for (DynamicObject schemeJson : schemeJsons) {
            int inteCheckSchemeItemCount = 0;
            try {
                JsonNode rootNode = objectMapper.readTree(schemeJson.getString("rule_tag"));
                JsonNode areaList = rootNode.path("area");
                for (int i = 0; i < areaList.size(); ++i) {
                    JsonNode decisionList = areaList.get(i).path("decision");
                    for (int i1 = 0; i1 < decisionList.size(); ++i1) {
                        JsonNode currentDecision = decisionList.get(i1);
                        if (!currentDecision.path("enabled").booleanValue()) continue;
                        if ("\"invoice\"".equals(currentDecision.path("matchType").toString())) {
                            inteCheckSchemeItemCount += SscIntelligenceCheckItemDataHelper.getCheckItemCountOfInvoice(currentDecision);
                            continue;
                        }
                        ++inteCheckSchemeItemCount;
                    }
                }
            }
            catch (JsonProcessingException e) {
                log.error("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 \uff1a" + e.getMessage());
            }
            longHashMap.put(schemeJson.getLong("id"), inteCheckSchemeItemCount);
        }
        return longHashMap;
    }

    private static int getCheckItemCountOfInvoice(JsonNode invoiceDecision) {
        int itemCount = 0;
        JsonNode invoiceConfig = invoiceDecision.path("invoiceConfig");
        itemCount += invoiceConfig.path("buyerTaxCode").booleanValue() ? 1 : 0;
        itemCount += invoiceConfig.path("certifiedOfInvoice").booleanValue() ? 1 : 0;
        itemCount += invoiceConfig.path("checkInvoiceHeader").booleanValue() ? 1 : 0;
        itemCount += invoiceConfig.path("completedOfBuyerInfo").booleanValue() ? 1 : 0;
        itemCount += invoiceConfig.path("completedOfSalerInfo").booleanValue() ? 1 : 0;
        itemCount += invoiceConfig.path("completedOfStamp").booleanValue() ? 1 : 0;
        itemCount += invoiceConfig.path("crossOneYear").booleanValue() ? 1 : 0;
        itemCount += invoiceConfig.path("duplicate").booleanValue() ? 1 : 0;
        itemCount += invoiceConfig.path("fullAmountOfAllInvoices").booleanValue() ? 1 : 0;
        return itemCount += invoiceConfig.path("customList").size();
    }
}

