/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceCheckItemDataHelper;

public class SscIntelligenceCheckItemDetailFormPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentity = (CardEntry)this.getControl("entryentity");
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill = SscIntelligenceCheckItemDataHelper.getCheckItemIdListMapByTaskBill(this.getSscId());
        this.initialPermPanel();
        this.initialTaskPanel(checkItemIdListMapByTaskBill);
        this.initialTaskList(checkItemIdListMapByTaskBill);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("entryentity".equals(key)) {
            int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(currIndex);
            this.JumpToArtiCheckItemPage(dynamicObject);
        }
    }

    private void JumpToArtiCheckItemPage(DynamicObject currentClickDynamicObject) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_checkitem_arti_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("sharecenter", (Object)this.getSscId().toString());
        parameter.setCustomParam("usergroup", (Object)this.getGroupId().toString());
        parameter.setCustomParam("task_bill_id", (Object)currentClickDynamicObject.getString("billid"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void initialPermPanel() {
        Label sscLabel = (Label)this.getControl("label_ssc");
        sscLabel.setText(CommonQueryHelper.getNameById("bos_org", this.getSscId()));
        Label groupLabel = (Label)this.getControl("label_group");
        groupLabel.setText(ResManager.loadKDString((String)"\u5168\u90e8\u7528\u6237\u7ec4", (String)"SscIntelligenceCheckItemDetailFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
    }

    private void initialTaskPanel(Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill) {
        int allInteCheckItemCount = 0;
        int allArtiCheckItemCount = 0;
        Label inteCheckPercentLabel = (Label)this.getControl("inte_checkitem_percent");
        Label artificialCountLabel = (Label)this.getControl("arti_check_count");
        Label intelligenceCountLabel = (Label)this.getControl("inte_check_count");
        if (CollectionUtils.isEmpty(checkItemIdListMapByTaskBill)) {
            inteCheckPercentLabel.setText("-");
            artificialCountLabel.setText(String.valueOf(allArtiCheckItemCount));
            intelligenceCountLabel.setText(String.valueOf(allInteCheckItemCount));
            return;
        }
        allInteCheckItemCount = SscIntelligenceCheckItemDataHelper.getInteCheckItemCountByInteScheme(checkItemIdListMapByTaskBill, -1L);
        allArtiCheckItemCount = checkItemIdListMapByTaskBill.values().stream().map(booleanSetMap -> ((Set)booleanSetMap.get(Boolean.FALSE)).size()).reduce(Integer::sum).orElse(0);
        if (allArtiCheckItemCount + allInteCheckItemCount == 0) {
            inteCheckPercentLabel.setText("0.0%");
        } else {
            String inteCheckPercent = new BigDecimal(allInteCheckItemCount).multiply(new BigDecimal(100)).divide(new BigDecimal(allArtiCheckItemCount + allInteCheckItemCount), 1, 4).toString();
            inteCheckPercentLabel.setText(inteCheckPercent + "%");
        }
        artificialCountLabel.setText(String.valueOf(allArtiCheckItemCount));
        intelligenceCountLabel.setText(String.valueOf(allInteCheckItemCount));
    }

    private void initialTaskList(Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill) {
        if (CollectionUtils.isEmpty(checkItemIdListMapByTaskBill)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity"});
        List<Map<String, Object>> listDataParameterMap = this.translateTasksToListDataParameters(checkItemIdListMapByTaskBill);
        this.fillDataIntoList(listDataParameterMap);
    }

    private List<Map<String, Object>> translateTasksToListDataParameters(Map<Long, Map<Boolean, Set<Long>>> checkItemIdListMapByTaskBill) {
        ArrayList<Map<String, Object>> parameterList = new ArrayList<Map<String, Object>>(checkItemIdListMapByTaskBill.size());
        if (CollectionUtils.isEmpty(checkItemIdListMapByTaskBill)) {
            this.fillDataWhichIsZero(parameterList, checkItemIdListMapByTaskBill.keySet());
            return parameterList;
        }
        HashMap<Long, String> taskBillNameMap = new HashMap<Long, String>();
        DynamicObjectCollection taskBills = QueryServiceHelper.query((String)"task_taskbill", (String)"id,number,name", (QFilter[])new QFilter("id", "in", checkItemIdListMapByTaskBill.keySet()).toArray());
        for (DynamicObject taskBill : taskBills) {
            taskBillNameMap.put(taskBill.getLong("id"), taskBill.getString("name"));
        }
        for (Map.Entry<Long, Map<Boolean, Set<Long>>> entry : checkItemIdListMapByTaskBill.entrySet()) {
            int allInteCheckItemCount = SscIntelligenceCheckItemDataHelper.getInteCheckItemCountByInteScheme(checkItemIdListMapByTaskBill, entry.getKey());
            int allArtiCheckItemCount = entry.getValue().get(Boolean.FALSE).size();
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("billid", entry.getKey());
            parameterMap.put("bill_name", taskBillNameMap.get(entry.getKey()));
            parameterMap.put("intecheckitem_total", allInteCheckItemCount + "/" + (allInteCheckItemCount + allArtiCheckItemCount));
            parameterMap.put("total_count", allInteCheckItemCount + allArtiCheckItemCount);
            if (allInteCheckItemCount + allArtiCheckItemCount != 0) {
                BigDecimal inteCheckPercent = new BigDecimal(allInteCheckItemCount).multiply(new BigDecimal(100)).divide(new BigDecimal(allArtiCheckItemCount + allInteCheckItemCount), 1, 4);
                parameterMap.put("inte_checkitem_percent_e", inteCheckPercent);
            } else {
                parameterMap.put("inte_checkitem_percent_e", BigDecimal.ZERO.setScale(1, 4));
            }
            parameterList.add(parameterMap);
        }
        this.fillDataWhichIsZero(parameterList, checkItemIdListMapByTaskBill.keySet());
        parameterList.sort((map1, map2) -> {
            int inteCheckItemPercentSort = ((BigDecimal)map2.get("inte_checkitem_percent_e")).compareTo((BigDecimal)map1.get("inte_checkitem_percent_e"));
            return inteCheckItemPercentSort != 0 ? inteCheckItemPercentSort : (Integer)map2.get("total_count") - (Integer)map1.get("total_count");
        });
        return parameterList;
    }

    private void fillDataWhichIsZero(List<Map<String, Object>> parameterList, Set<Long> taskBillIds) {
        DynamicObjectCollection taskBills = QueryServiceHelper.query((String)"task_taskbill", (String)"id,number,name", (QFilter[])new QFilter("ssccenter", "=", (Object)this.getSscId()).toArray());
        List billIdsWhichIsEmpty = taskBills.stream().filter(dy -> !taskBillIds.contains(dy.getLong("id"))).collect(Collectors.toList());
        for (DynamicObject dynamicObject : billIdsWhichIsEmpty) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("billid", dynamicObject.getLong("id"));
            parameterMap.put("bill_name", dynamicObject.getString("name"));
            parameterMap.put("intecheckitem_total", "-");
            parameterMap.put("inte_checkitem_percent_e", new BigDecimal(-1).setScale(1, 4));
            parameterList.add(parameterMap);
        }
    }

    private void fillDataIntoList(List<Map<String, Object>> listDataParameterMap) {
        if (CollectionUtils.isEmpty(listDataParameterMap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity"});
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        int size = listDataParameterMap.size();
        model.batchCreateNewEntryRow("entryentity", size);
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
        DynamicProperty billid = dynamicObjects.getDynamicObjectType().getProperty("billid");
        DynamicProperty billName = dynamicObjects.getDynamicObjectType().getProperty("bill_name");
        DynamicProperty intecheckitemTotal = dynamicObjects.getDynamicObjectType().getProperty("intecheckitem_total");
        DynamicProperty inteCheckitemPercentOfEntry = dynamicObjects.getDynamicObjectType().getProperty("inte_checkitem_percent_e");
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = listDataParameterMap.get(i);
            DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
            billid.setValueFast((Object)entry, map.get("billid"));
            billName.setValueFast((Object)entry, map.get("bill_name"));
            intecheckitemTotal.setValueFast((Object)entry, map.get("intecheckitem_total"));
            BigDecimal inte_checkitem_percent = (BigDecimal)map.get("inte_checkitem_percent_e");
            if (inte_checkitem_percent.compareTo(BigDecimal.ZERO) >= 0) {
                inteCheckitemPercentOfEntry.setValueFast((Object)entry, (Object)(inte_checkitem_percent + "%"));
                continue;
            }
            inteCheckitemPercentOfEntry.setValueFast((Object)entry, (Object)"-");
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Long getGroupId() {
        return Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("usergroup"));
    }

    private Long getSscId() {
        Long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        }
        return sscId;
    }
}

