/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.quality.SscQualityProportionCardPlugin;
import kd.ssc.task.mobile.formplugin.quality.dto.QualityPointCountResult;
import kd.ssc.task.mobile.utils.FormatUtils;

public class SscQualityProportionDetailPlugin
extends SscQualityProportionCardPlugin {
    public static final String FORMID = "ssc_quality_prop_detail_m";
    private static final String CTRL_ENTRY_KEY_POINT_PERCENT_LIST = "pointpercentlist";
    private static final String ENTRY_PROPERTY_POINTNAME = "pointname";
    private static final String ENTRY_PROPERTY_POINTTIMES = "pointtimes";
    private static final String ENTRY_PROPERTY_POINTPERCENT = "pointpercent";

    @Override
    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String sharecenter = (String)parameter.getCustomParam("sharecenter");
        String usergroup = (String)parameter.getCustomParam("usergroup");
        if (sharecenter == null || usergroup == null) {
            return;
        }
        Label label_sharecenter = (Label)this.getView().getControl("sharecenter");
        Label label_usergroup = (Label)this.getView().getControl("usergroup");
        label_sharecenter.setText(CommonQueryHelper.getShareCenterName(Long.valueOf(sharecenter)));
        label_usergroup.setText(CommonQueryHelper.getUserGroupName(Long.valueOf(usergroup)));
        super.afterCreateNewData(e);
    }

    @Override
    protected void setPanelList(List<QualityPointCountResult> results) {
        IDataModel model = this.getModel();
        model.deleteEntryData(CTRL_ENTRY_KEY_POINT_PERCENT_LIST);
        int size = results.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(CTRL_ENTRY_KEY_POINT_PERCENT_LIST, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(CTRL_ENTRY_KEY_POINT_PERCENT_LIST);
            DynamicProperty pointname = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_PROPERTY_POINTNAME);
            DynamicProperty pointtimes = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_PROPERTY_POINTTIMES);
            DynamicProperty pointpercent = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_PROPERTY_POINTPERCENT);
            String text = ResManager.loadKDString((String)"\u4e0d\u5408\u683c\u6570\uff1a", (String)"SscQualityProportionDetailPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]);
            for (int i = 0; i < size; ++i) {
                QualityPointCountResult result = results.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                pointname.setValueFast((Object)entry, (Object)result.getPointname());
                pointtimes.setValueFast((Object)entry, (Object)(text + result.getPointtimes()));
                pointpercent.setValueFast((Object)entry, (Object)(FormatUtils.format1dot(result.getPercent()) + "%"));
            }
            model.endInit();
            this.getView().updateView(CTRL_ENTRY_KEY_POINT_PERCENT_LIST);
        }
    }

    public static void jumpMeBy(IFormView formView, String sharecenter, String usergroup, String dateRangeStr) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(CardEnum.QualityProportionCard.getCaption());
        parameter.setCustomParam("sharecenter", (Object)sharecenter);
        parameter.setCustomParam("usergroup", (Object)usergroup);
        parameter.setCustomParam("dateRange", (Object)dateRangeStr);
        formView.showForm((FormShowParameter)parameter);
    }
}

