/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.ssc.task.mobile.formplugin.quality.SscQualityProportionDataHelper;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountDetailResult;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountResult;
import kd.ssc.task.mobile.utils.CommonUtils;
import kd.ssc.task.mobile.utils.DataSetCloseHelper;
import kd.ssc.task.mobile.utils.SQLBuilder;

public final class SscUnqualifiedDetailHelper {
    public static DataSet getQualitysamplelibraryDataSet(Long sscid, Long usergroup, Date startDate, Date endDate) {
        SQLBuilder builder = new SQLBuilder().append(" AND t1.FTASKCREATETIME >= ? ", startDate).append(" AND t1.FTASKCREATETIME < ? ", CommonUtils.nextDate(endDate));
        DataSet dataSet = usergroup == null || usergroup.equals(-1L) ? DB.queryDataSet((String)SscQualityProportionDataHelper.class.getName(), (DBRoute)DBRoute.of((String)"ssc"), (String)("SELECT t1.FID as id,t2.FUSERGROUP as usergroup,t2.FORGID as orgid,t2.FBilltypeID as billtype,t1.fqualityresult as qualityresult FROM T_TK_TASKHISTORY t1, T_TK_TASKHISTORY t2 WHERE  t1.FSOURCETASKID = t2.FID AND t1.FSSCID = ? AND t1.fqualitysamplelibraryid > 0 " + builder.getExpression()), (Object[])builder.toArray(sscid)) : DB.queryDataSet((String)SscQualityProportionDataHelper.class.getName(), (DBRoute)DBRoute.of((String)"ssc"), (String)("SELECT t1.FID as id,t2.FUSERGROUP as usergroup,t2.FORGID as orgid,t2.FBilltypeID as billtype,t2.FPersonID as personid,t1.fqualityresult as qualityresult FROM T_TK_TASKHISTORY t1, T_TK_TASKHISTORY t2 WHERE  t1.FSOURCETASKID = t2.FID AND t1.FSSCID = ? AND t2.FUSERGROUP = ? AND t1.fqualitysamplelibraryid > 0 " + builder.getExpression()), (Object[])builder.toArray(sscid, usergroup));
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnqualifiedCountDetailResult getData(Long sscid, Long usergroup, Date startDate, Date endDate, String groupby) {
        UnqualifiedCountDetailResult data = new UnqualifiedCountDetailResult();
        try (DataSetCloseHelper closeHelper = DataSetCloseHelper.get();){
            UnqualifiedCountResult result;
            DataSet dataSet = SscUnqualifiedDetailHelper.getQualitysamplelibraryDataSet(sscid, usergroup, startDate, endDate);
            closeHelper.add(dataSet);
            DataSet ds1 = dataSet.groupBy(new String[]{groupby}).count("taskcount").sum("(case when qualityresult='0' then 1 else 0 end) as unpass", "nopasscount").finish();
            DataSet copy = ds1.copy();
            ArrayList<UnqualifiedCountResult> list = new ArrayList<UnqualifiedCountResult>();
            for (Row row : copy) {
                Long groupbyId = row.getLong(groupby);
                Integer nopasscount = row.getInteger("nopasscount");
                Integer taskcount = row.getInteger("taskcount");
                result = new UnqualifiedCountResult();
                result.setXnames(groupby);
                result.setUnqualifiedCount(nopasscount);
                result.setCompleteCount(taskcount);
                result.setGroupbyId(groupbyId);
                list.add(result);
            }
            data.setList(list);
            DataSet ds2 = ds1.groupBy().sum("taskcount").sum("nopasscount").finish();
            for (Row row : ds2) {
                Integer taskcount = row.getInteger("taskcount");
                Integer nopasscount = row.getInteger("nopasscount");
                result = new UnqualifiedCountResult();
                result.setUnqualifiedCount(nopasscount);
                result.setCompleteCount(taskcount);
                result.setGroupbyId(-1L);
                data.setHead(result);
            }
        }
        return data;
    }

    public static Comparator<UnqualifiedCountResult> newComparator() {
        return (o1, o2) -> {
            BigDecimal ratio1 = o1.unqualifiedRatio();
            BigDecimal ratio2 = o2.unqualifiedRatio();
            if (ratio1 != null && ratio2 != null) {
                return -ratio1.compareTo(ratio2);
            }
            if (ratio1 != null) {
                return -1;
            }
            if (ratio2 != null) {
                return 1;
            }
            return o1.getGroupbyId().compareTo(o2.getGroupbyId());
        };
    }
}

