/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.OrgRelationQueryHelper;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.quality.SscUnqualifiedDetailHelper;
import kd.ssc.task.mobile.formplugin.quality.SscUnqualifiedDetailUserPlugin;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountDetailResult;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountResult;
import kd.ssc.task.mobile.template.datespan.DateRangePO;

public class SscUnqualifiedDetailPlugin
extends AbstractMobFormPlugin
implements TabSelectListener,
RowClickEventListener {
    public static final String FORMID = "ssc_unqualified_detail_m";
    private static final String LABEL_TIME = "labeltime";
    private static final String LABEL_RATIO = "labelratio";
    private static final String LABEL_UNQUALIFIED_COUNT = "labelunqualifiedcount";
    private static final String LABEL_COMPLETE_COUNT = "labelcompletecount";
    private static final String CTRL_TAB_AP = "tabap";
    private static final String TAB_USERGROUP = "tab_usergroup";
    private static final String TAB_ORG = "tab_org";
    private static final String ENTRYENTITY = "entryentity";
    private static final String F_ITEM_NAME = "itemname";
    private static final String F_ITEM_UNCOUNT_ALLCOUNT = "itemuncountallcount";
    private static final String F_ITEM_RATIO = "itemratio";
    private static final String F_GROUPBY = "groupby";
    private static final String F_GROUPID = "groupid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(CTRL_TAB_AP);
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        CardEntry entryentity = (CardEntry)this.getControl(ENTRYENTITY);
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String sharecenter = (String)parameter.getCustomParam("sharecenter");
        String usergroup = (String)parameter.getCustomParam("usergroup");
        if (sharecenter == null || usergroup == null) {
            return;
        }
        DateRangePO dateRangePO = this.getDateRangePO();
        this.initParams(sharecenter, usergroup, dateRangePO);
        this.switchTabView(TAB_USERGROUP, dateRangePO);
    }

    private DateRangePO getDateRangePO() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String poJson = (String)parameter.getCustomParam("dateRange");
        return (DateRangePO)SerializationUtils.fromJsonString((String)poJson, DateRangePO.class);
    }

    private void initParams(String sharecenter, String usergroup, DateRangePO dateRangePO) {
        Label label_sharecenter = (Label)this.getView().getControl("sharecenter");
        Label label_usergroup = (Label)this.getView().getControl("usergroup");
        label_sharecenter.setText(CommonQueryHelper.getShareCenterName(Long.valueOf(sharecenter)));
        label_usergroup.setText(CommonQueryHelper.getUserGroupName(Long.valueOf(usergroup)));
        Label label_time = (Label)this.getView().getControl(LABEL_TIME);
        label_time.setText(dateRangePO.getSpanTypeDesc());
    }

    private void setDataHeadView(UnqualifiedCountResult head) {
        if (head != null) {
            Label label_ratio = (Label)this.getView().getControl(LABEL_RATIO);
            Label label_unqualified_count = (Label)this.getView().getControl(LABEL_UNQUALIFIED_COUNT);
            Label label_complete_count = (Label)this.getView().getControl(LABEL_COMPLETE_COUNT);
            label_ratio.setText(head.unqualifiedRatiotextPercent());
            label_unqualified_count.setText(head.getUnqualifiedCount() + "");
            label_complete_count.setText(head.getCompleteCount() + "");
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        this.switchTabView(evt.getTabKey(), this.getDateRangePO());
    }

    private void switchTabView(String tabKey, DateRangePO dateRangePO) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long sharecenter = Long.valueOf((String)parameter.getCustomParam("sharecenter"));
        Long usergroup = Long.valueOf((String)parameter.getCustomParam("usergroup"));
        if (TAB_USERGROUP.equals(tabKey)) {
            String groupby = "usergroup";
            UnqualifiedCountDetailResult dataResults = this.getDetailResultData(sharecenter, usergroup, dateRangePO, groupby);
            this.setDataHeadView(dataResults.getHead());
            if (usergroup.equals(-1L)) {
                Map<Long, UnqualifiedCountResult> resultMap = dataResults.getList().stream().collect(Collectors.toMap(UnqualifiedCountResult::getGroupbyId, o -> o));
                Long userId = RequestContext.get().getCurrUserId();
                DynamicObjectCollection allGroupBySscId = CommonQueryHelper.getAllGroupBySscId(sharecenter, userId);
                List<UnqualifiedCountResult> collect = allGroupBySscId.stream().map(dynamicObject -> {
                    long id = dynamicObject.getLong("id");
                    String name = dynamicObject.getString("name");
                    UnqualifiedCountResult result = (UnqualifiedCountResult)resultMap.get(id);
                    if (result == null) {
                        result = new UnqualifiedCountResult();
                        result.setGroupbyId(id);
                        result.setUnqualifiedCount(0);
                        result.setCompleteCount(0);
                    }
                    result.setXnames(name);
                    return result;
                }).sorted(SscUnqualifiedDetailHelper.newComparator()).collect(Collectors.toList());
                this.setListData(collect, groupby);
            } else {
                List<UnqualifiedCountResult> collect = dataResults.getList();
                if (collect.size() == 0) {
                    UnqualifiedCountResult empty = new UnqualifiedCountResult();
                    empty.setGroupbyId(usergroup);
                    empty.setUnqualifiedCount(0);
                    empty.setCompleteCount(0);
                    collect.add(empty);
                }
                UnqualifiedCountResult result = collect.get(0);
                String name = CommonQueryHelper.getUserGroupName(result.getGroupbyId());
                result.setXnames(name);
                this.setListData(collect, groupby);
            }
        } else if (TAB_ORG.equals(tabKey)) {
            String groupby = "orgid";
            UnqualifiedCountDetailResult dataResults = this.getDetailResultData(sharecenter, usergroup, dateRangePO, groupby);
            this.setDataHeadView(dataResults.getHead());
            List<Long> allToOrg = OrgRelationQueryHelper.getFromOrgList(sharecenter);
            DynamicObjectCollection allOrgCollection = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter("id", "in", allToOrg).toArray());
            Map<Long, UnqualifiedCountResult> resultMap = dataResults.getList().stream().collect(Collectors.toMap(UnqualifiedCountResult::getGroupbyId, o -> o));
            List<UnqualifiedCountResult> collect = allOrgCollection.stream().map(dynamicObject -> {
                long id = dynamicObject.getLong("id");
                String name = dynamicObject.getString("name");
                UnqualifiedCountResult result = (UnqualifiedCountResult)resultMap.get(id);
                if (result == null) {
                    result = new UnqualifiedCountResult();
                    result.setGroupbyId(id);
                    result.setUnqualifiedCount(0);
                    result.setCompleteCount(0);
                }
                result.setXnames(name);
                return result;
            }).sorted(SscUnqualifiedDetailHelper.newComparator()).collect(Collectors.toList());
            this.setListData(collect, groupby);
        } else {
            String groupby = "billtype";
            UnqualifiedCountDetailResult dataResults = this.getDetailResultData(sharecenter, usergroup, dateRangePO, groupby);
            this.setDataHeadView(dataResults.getHead());
            DynamicObjectCollection allBillTypeCollection = QueryServiceHelper.query((String)"task_taskbill", (String)"id,number,name", (QFilter[])new QFilter("ssccenter", "=", (Object)sharecenter).toArray());
            Map<Long, UnqualifiedCountResult> resultMap = dataResults.getList().stream().collect(Collectors.toMap(UnqualifiedCountResult::getGroupbyId, o -> o));
            List<UnqualifiedCountResult> collect = allBillTypeCollection.stream().map(dynamicObject -> {
                long id = dynamicObject.getLong("id");
                String name = dynamicObject.getString("name");
                UnqualifiedCountResult result = (UnqualifiedCountResult)resultMap.get(id);
                if (result == null) {
                    result = new UnqualifiedCountResult();
                    result.setGroupbyId(id);
                    result.setUnqualifiedCount(0);
                    result.setCompleteCount(0);
                }
                result.setXnames(name);
                return result;
            }).sorted(SscUnqualifiedDetailHelper.newComparator()).collect(Collectors.toList());
            this.setListData(collect, groupby);
        }
    }

    private UnqualifiedCountDetailResult getDetailResultData(Long sharecenter, Long usergroup, DateRangePO dateRangePO, String groupby) {
        return SscUnqualifiedDetailHelper.getData(sharecenter, usergroup, dateRangePO.getStartDate(), dateRangePO.getEndDate(), groupby);
    }

    private void setListData(List<UnqualifiedCountResult> list, String groupby) {
        int size = list.size();
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(ENTRYENTITY, "setCardScrollBartoTop", new Object[]{Boolean.TRUE});
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(ENTRYENTITY);
            DynamicProperty pro_itemname = dynamicObjects.getDynamicObjectType().getProperty(F_ITEM_NAME);
            DynamicProperty pro_itemuncountallcount = dynamicObjects.getDynamicObjectType().getProperty(F_ITEM_UNCOUNT_ALLCOUNT);
            DynamicProperty pro_itemratio = dynamicObjects.getDynamicObjectType().getProperty(F_ITEM_RATIO);
            DynamicProperty pro_groupby = dynamicObjects.getDynamicObjectType().getProperty(F_GROUPBY);
            DynamicProperty pro_groupId = dynamicObjects.getDynamicObjectType().getProperty(F_GROUPID);
            for (int i = 0; i < size; ++i) {
                UnqualifiedCountResult result = list.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                pro_itemname.setValueFast((Object)entry, (Object)result.getXnames());
                pro_itemuncountallcount.setValueFast((Object)entry, (Object)(result.getUnqualifiedCount() + "/" + result.getCompleteCount()));
                pro_itemratio.setValueFast((Object)entry, (Object)result.unqualifiedRatiotextPercent());
                pro_groupby.setValueFast((Object)entry, (Object)groupby);
                pro_groupId.setValueFast((Object)entry, (Object)result.getGroupbyId());
            }
            model.endInit();
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (ENTRYENTITY.equals(key) && TAB_USERGROUP.equals(((Tab)this.getControl(CTRL_TAB_AP)).getCurrentTab())) {
            int currIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(currIndex);
            String usergroupid = dynamicObject.getString(F_GROUPID);
            this.jumpDetailUser(usergroupid);
        }
    }

    private void jumpDetailUser(String usergroupid) {
        Object sharecenter = this.getView().getFormShowParameter().getCustomParam("sharecenter");
        Object poJson = this.getView().getFormShowParameter().getCustomParam("dateRange");
        if (sharecenter == null || poJson == null || usergroupid == null) {
            return;
        }
        SscUnqualifiedDetailUserPlugin.jumpMeBy(this.getView(), String.valueOf(sharecenter), usergroupid, String.valueOf(poJson));
    }

    public static void jumpMeBy(IFormView formView, String sharecenter, String usergroup, String dateRangeStr) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("sharecenter", (Object)sharecenter);
        parameter.setCustomParam("usergroup", (Object)usergroup);
        parameter.setCustomParam("dateRange", (Object)dateRangeStr);
        formView.showForm((FormShowParameter)parameter);
    }
}

