/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.serviceap;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.ssc.task.mobile.common.OrgRelationQueryHelper;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.PageUtils;
import kd.ssc.task.mobile.formplugin.index.SscDateSpanCardTemplatePlugin;
import kd.ssc.task.mobile.formplugin.serviceap.datahelper.SscServiceOrgSatisfactionDataHelper;
import kd.ssc.task.mobile.formplugin.serviceap.graph.RadarGraphOfServiceOrgSatisfaction;
import kd.ssc.task.mobile.template.AbstractDataProcess;
import kd.ssc.task.mobile.template.DynamicTabTemplatePlugin;
import kd.ssc.task.mobile.template.data.TransferData;
import kd.ssc.task.mobile.template.datespan.DateSpanEnum;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.template.enums.BaseDataEnum;

public class SscServiceOrgSatisfactionCardPlugin
extends SscDateSpanCardTemplatePlugin {
    private static final Log log = LogFactory.getLog(SscServiceOrgSatisfactionCardPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"up_down_flex", "up_down_flex_2", "average_color_label_on", "average_color_label_off", "vectorap1", "org_color_label_on", "org_color_label_off", "org_switch_button", "suggestion_flex_2", "suggestion_flex_3", "suggestion_flex_4", "suggestion_flex_5"});
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("compare_org");
        orgF7.addBeforeF7SelectListener(evt -> {
            List<Long> allToOrg = OrgRelationQueryHelper.getFromOrgList(this.getSscid());
            QFilter qFilter = new QFilter("id", "in", allToOrg);
            evt.addCustomQFilter(qFilter);
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Map.Entry<Long, BigDecimal>> orderedRecTaskCountEntry = SscServiceOrgSatisfactionDataHelper.orderedRecTaskCountEntry(this.getSscid(), this.getDateSpanPO());
        if (CollectionUtils.isEmpty(orderedRecTaskCountEntry)) {
            this.getPageCache().put("isEmpty", "1");
            List<Map.Entry<Long, BigDecimal>> newOrderedRecTaskCountEntry = SscServiceOrgSatisfactionDataHelper.orderedRecTaskCountEntry(this.getSscid(), new DateSpanPO(DateSpanEnum.UNLIMIT.getNumber(), null, null));
            log.info("\u5361\u7247\u521d\u59cb\u5316\u65f6\u7684\u7ec4\u7ec7\u96c6\u5408\u6570\u636e" + newOrderedRecTaskCountEntry.size() + " --- " + newOrderedRecTaskCountEntry);
            if (!CollectionUtils.isEmpty(newOrderedRecTaskCountEntry)) {
                this.getModel().setValue("compare_org", (Object)newOrderedRecTaskCountEntry.get(0).getKey());
            }
        } else {
            this.getModel().setValue("compare_org", (Object)orderedRecTaskCountEntry.get(0).getKey());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put("average_domain_on_off", "1");
        this.getPageCache().put("org_domain_on_off", "1");
        this.getPageCache().put("advance_suggestion_panel", "0");
        if ("1".equals(this.getPageCache().get("isEmpty"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contentflexcore", "suggestion_panel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultflex"});
            return;
        }
        RadarGraphOfServiceOrgSatisfaction.initRadarGraph(this.getView(), this.getDateSpanPO(), false);
        this.updateLegendVisible();
        this.updateAdvanceSuggestionPanelVisible();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("up_down_flex".equals(key) || "up_down_flex_2".equals(key)) {
            String suggestion_panel_on_off = "0".equals(this.getPageCache().get("advance_suggestion_panel")) ? "1" : "0";
            this.getPageCache().put("advance_suggestion_panel", suggestion_panel_on_off);
            this.updateAdvanceSuggestionPanelVisible();
        } else if ("average_color_label_on".equals(key)) {
            this.getPageCache().put("average_domain_on_off", "0");
            RadarGraphOfServiceOrgSatisfaction.initRadarGraph(this.getView(), this.getDateSpanPO(), true);
            this.updateLegendVisible();
        } else if ("average_color_label_off".equals(key)) {
            this.getPageCache().put("average_domain_on_off", "1");
            RadarGraphOfServiceOrgSatisfaction.initRadarGraph(this.getView(), this.getDateSpanPO(), true);
            this.updateLegendVisible();
        } else if ("org_color_label_on".equals(key)) {
            this.getPageCache().put("org_domain_on_off", "0");
            RadarGraphOfServiceOrgSatisfaction.initRadarGraph(this.getView(), this.getDateSpanPO(), true);
            this.updateLegendVisible();
        } else if ("org_color_label_off".equals(key)) {
            this.getPageCache().put("org_domain_on_off", "1");
            RadarGraphOfServiceOrgSatisfaction.initRadarGraph(this.getView(), this.getDateSpanPO(), true);
            this.updateLegendVisible();
        } else if ("suggestion_flex_2".equals(key)) {
            this.btnAnalyse(CardEnum.AverageAging);
        } else if ("suggestion_flex_3".equals(key)) {
            this.btnAnalyse(CardEnum.LotRejectRateCard);
        } else if ("suggestion_flex_4".equals(key)) {
            this.btnAnalyse(CardEnum.SweepRateBackCard);
        } else if ("suggestion_flex_5".equals(key)) {
            this.btnAnalyse(CardEnum.OverDueRateCard);
        } else if ("vectorap1".equals(key)) {
            PageUtils.showTip(this.getView(), ResManager.loadKDString((String)"\u670d\u52a1\u7ec4\u7ec7\u6ee1\u610f\u5ea6\u5206\u6790", (String)"SscServiceOrgSatisfactionCardPlugin_5", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u901a\u8fc7\u5206\u67905\u4e2a\u5f71\u54cd\u6ee1\u610f\u5ea6\u7684\u6307\u6807\u4e0e\u5747\u503c\u7684\u5bf9\u6bd4\uff0c\u8bc4\u4f30\u5f53\u524d\u7ec4\u7ec7\u7684\u6ee1\u610f\u5ea6", (String)"SscServiceOrgSatisfactionCardPlugin_6", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
    }

    private void updateAdvanceSuggestionPanelVisible() {
        boolean advance_suggestion_panel_off = "0".equals(this.getPageCache().get("advance_suggestion_panel"));
        if (advance_suggestion_panel_off) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"vector_up", "vector_up_2", "up_down_flex_2"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"vector_down", "vector_down_2", "up_down_flex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"suggestion_panel"});
            Label upDownLabel = (Label)this.getView().getControl("up_down_label");
            Label upDownLabel2 = (Label)this.getView().getControl("up_down_label_2");
            String label = ResManager.loadKDString((String)"\u5c55\u5f00", (String)"SscServiceOrgSatisfactionCardPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]);
            upDownLabel.setText(label);
            upDownLabel2.setText(label);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"vector_up", "vector_up_2", "up_down_flex_2"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"vector_down", "vector_down_2", "up_down_flex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"suggestion_panel"});
            Label upDownLabel = (Label)this.getView().getControl("up_down_label");
            Label upDownLabel2 = (Label)this.getView().getControl("up_down_label_2");
            String label = ResManager.loadKDString((String)"\u6536\u8d77", (String)"SscServiceOrgSatisfactionCardPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]);
            upDownLabel.setText(label);
            upDownLabel2.setText(label);
            Label suggestLabel = (Label)this.getView().getControl("labelaptitle1");
            String suggestion = "";
            DynamicObject compareOrg = (DynamicObject)this.getView().getModel().getValue("compare_org");
            if (compareOrg != null) {
                suggestion = String.format(ResManager.loadKDString((String)"%s\u6ee1\u610f\u5ea6\u5206\u6790\uff1a", (String)"SscServiceOrgSatisfactionCardPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]), compareOrg.getString("name"));
            }
            suggestLabel.setText(suggestion);
        }
    }

    private void updateLegendVisible() {
        boolean average_legend_off = "0".equals(this.getPageCache().get("average_domain_on_off"));
        boolean org_legend_off = "0".equals(this.getPageCache().get("org_domain_on_off"));
        if (average_legend_off) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"average_color_label_on"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"average_color_label_off"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"average_color_label_on"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"average_color_label_off"});
        }
        if (org_legend_off) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"org_color_label_on"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"org_color_label_off"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"org_color_label_on"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"org_color_label_off"});
        }
    }

    @Override
    protected void operationAfterSwitchDateSpan(DateSpanPO dateSpanPO) {
        super.operationAfterSwitchDateSpan(dateSpanPO);
        RadarGraphOfServiceOrgSatisfaction.initRadarGraph(this.getView(), dateSpanPO, false);
        this.updateLegendVisible();
        this.updateAdvanceSuggestionPanelVisible();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        if ("compare_org".equals(keyName)) {
            RadarGraphOfServiceOrgSatisfaction.initRadarGraph(this.getView(), this.getDateSpanPO(), false);
            this.updateLegendVisible();
            this.updateAdvanceSuggestionPanelVisible();
        }
    }

    protected void btnAnalyse(CardEnum card) {
        DynamicObject compareOrg = (DynamicObject)this.getView().getModel().getValue("compare_org");
        if (compareOrg != null) {
            AbstractDataProcess builder = card.getDataProcess();
            TransferData transferData = builder.build(this.getSscid(), -1L, this.getDateSpanPO());
            transferData.getGroupbys().add(BaseDataEnum.ORGID.getCode());
            transferData.getFilterMap().put(BaseDataEnum.ORGID.getCode(), compareOrg.getLong("id"));
            transferData.getGroupbys().add(BaseDataEnum.USERGROUP.getCode());
            DynamicTabTemplatePlugin.jumpMeBy(this.getView(), card.getCaption(), transferData);
        }
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.ServiceOrgSatisCard.getCaption());
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u4e3b\u8981\u670d\u52a1\u7ec4\u7ec7\u7684\u670d\u52a1\u80fd\u529b\u6307\u6807", (String)"SscServiceOrgSatisfactionCardPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }
}

