/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.serviceap.graph;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.chart.M;
import kd.ssc.task.mobile.formplugin.serviceap.datahelper.SscServiceOrgSatisfactionDataHelper;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.utils.DateSpanCommonUtils;

public class RadarGraphOfServiceOrgSatisfaction {
    private static final Log log = LogFactory.getLog(RadarGraphOfServiceOrgSatisfaction.class);

    public static void initRadarGraph(IFormView view, DateSpanPO dateSpanPO, boolean onlyUpdateGraph) {
        HashMap<String, Object> radarChartMap = new HashMap<String, Object>();
        Map<String, List<BigDecimal>> seriesDataListMap = RadarGraphOfServiceOrgSatisfaction.getSeriesData(view, dateSpanPO);
        if (CollectionUtils.isEmpty(seriesDataListMap)) {
            return;
        }
        radarChartMap.put("grid", M.map().kv("top", "5%").kv("right", "5%"));
        radarChartMap.put("xAxis", M.map().kv("show", Boolean.FALSE));
        radarChartMap.put("yAxis", M.map().kv("show", Boolean.FALSE));
        RadarGraphOfServiceOrgSatisfaction.setToolTip(radarChartMap);
        RadarGraphOfServiceOrgSatisfaction.setRadarAxis(radarChartMap, seriesDataListMap);
        RadarGraphOfServiceOrgSatisfaction.setSeries(radarChartMap, view, seriesDataListMap);
        ArrayList<List<Object>> functionPaths = new ArrayList<List<Object>>();
        functionPaths.add(M.arraylist("tooltip", "formatter"));
        radarChartMap.put("functions", functionPaths);
        if (!onlyUpdateGraph) {
            RadarGraphOfServiceOrgSatisfaction.showAdvanceSuggestionPanel(view, seriesDataListMap, dateSpanPO);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.setFieldProperty("satisfaction_radar_chart", "data", radarChartMap);
    }

    private static void showAdvanceSuggestionPanel(IFormView view, Map<String, List<BigDecimal>> seriesDataListMap, DateSpanPO dateSpanPO) {
        List<BigDecimal> specifiedOrgSeriesDataList = seriesDataListMap.get("org");
        BigDecimal ReceiveTaskCount = specifiedOrgSeriesDataList.get(0);
        if (ReceiveTaskCount.compareTo(BigDecimal.ZERO) == 0) {
            view.setVisible(Boolean.FALSE, new String[]{"suggestion_panel_detail"});
            view.setVisible(Boolean.TRUE, new String[]{"empty_panel"});
            Label emptyLabel = (Label)view.getControl("empty_text");
            emptyLabel.setText(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u63a5\u6536\u5230\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u5f00\u5c55\u5de5\u4f5c\u3002", (String)"RadarGraphOfServiceOrgSatisfaction_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else if (RadarGraphOfServiceOrgSatisfaction.hisTaskOfCurrentOrgIsEmpty(view, dateSpanPO)) {
            view.setVisible(Boolean.FALSE, new String[]{"suggestion_panel_detail"});
            view.setVisible(Boolean.TRUE, new String[]{"empty_panel"});
            Label emptyLabel = (Label)view.getControl("empty_text");
            emptyLabel.setText(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5c1a\u672a\u5f00\u59cb\u5904\u7406\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u5f00\u59cb\u5de5\u4f5c\u3002", (String)"RadarGraphOfServiceOrgSatisfaction_1", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"suggestion_panel_detail"});
            view.setVisible(Boolean.FALSE, new String[]{"empty_panel"});
            RadarGraphOfServiceOrgSatisfaction.updateAdvanceSuggestionPanel(view, seriesDataListMap, dateSpanPO);
        }
    }

    private static boolean hisTaskOfCurrentOrgIsEmpty(IFormView view, DateSpanPO dateSpanPO) {
        DynamicObject compareOrg = (DynamicObject)view.getModel().getValue("compare_org");
        long orgId = compareOrg.getLong("id");
        QFilter orgIdFilter = new QFilter("orgid", "=", (Object)orgId);
        QFilter userFilter = new QFilter("sscid", "=", (Object)RadarGraphOfServiceOrgSatisfaction.getSscId(view));
        QFilter createtimeFilter = DateSpanCommonUtils.timeSection("receivetime", dateSpanPO.getStartDateSpan(), dateSpanPO.getEndDateSpan());
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        DataSet dataSetTaskHis = QueryServiceHelper.queryDataSet((String)"ssc", (String)"task_taskhistory", (String)"id", (QFilter[])new QFilter[]{orgIdFilter, userFilter, createtimeFilter, notQuaCheckTask}, null);
        return dataSetTaskHis.count("id", true) == 0;
    }

    private static void setRadarAxis(Map<String, Object> radarChartMap, Map<String, List<BigDecimal>> seriesDataListMap) {
        List<BigDecimal> boundary = seriesDataListMap.get("boundary");
        radarChartMap.put("radar", M.map().kv("radius", "80%").kv("center", M.arraylist("50%", "53%")).kv("axisLine", M.map().kv("lineStyle", map -> map.kv("color", "#e5e5e5"))).kv("splitLine", M.map().kv("lineStyle", map -> map.kv("color", "#e5e5e5"))).kv("splitArea", M.map().kv("show", Boolean.FALSE)).kv("axisLabel", M.map().kv("show", Boolean.FALSE)).kv("splitNumber", 4).kv("indicator", M.arraylist(M.map().kv("name", ResManager.loadKDString((String)"\u63a5\u53d7\u4efb\u52a1\u91cf", (String)"RadarGraphOfServiceOrgSatisfaction_2", (String)"ssc-task-mobile", (Object[])new Object[0])).kv("max", boundary.get(0)).kv("color", "#999"), M.map().kv("name", ResManager.loadKDString((String)"\u6279\u9000\u7387", (String)"RadarGraphOfServiceOrgSatisfaction_3", (String)"ssc-task-mobile", (Object[])new Object[0])).kv("max", boundary.get(1)).kv("color", "#999"), M.map().kv("name", ResManager.loadKDString((String)"\u9000\u626b\u7387", (String)"RadarGraphOfServiceOrgSatisfaction_6", (String)"ssc-task-mobile", (Object[])new Object[0])).kv("max", boundary.get(2)).kv("color", "#999"), M.map().kv("name", ResManager.loadKDString((String)"\u4efb\u52a1\u8d85\u671f\u7387", (String)"RadarGraphOfServiceOrgSatisfaction_5", (String)"ssc-task-mobile", (Object[])new Object[0])).kv("max", boundary.get(3)).kv("color", "#999"), M.map().kv("name", ResManager.loadKDString((String)"\u5e73\u5747\u5904\u7406\u65f6\u957f", (String)"RadarGraphOfServiceOrgSatisfaction_4", (String)"ssc-task-mobile", (Object[])new Object[0])).kv("max", boundary.get(4)).kv("color", "#999"))));
    }

    private static void setToolTip(Map<String, Object> radarChartMap) {
        radarChartMap.put("tooltip", M.map().kv("formatter", String.format("function(params){return params.name      + '</br>' + '%1$s : ' + params.value[0].toFixed(1)       + '</br>' + '%2$s : ' + params.value[4].toFixed(1)       + '</br>' + '%3$s : ' + params.value[1].toFixed(1) + '%%'       + '</br>' + '%4$s : ' + params.value[2].toFixed(1) + '%%'       + '</br>' + '%5$s : ' + params.value[3].toFixed(1) + '%%';}", ResManager.loadKDString((String)"\u63a5\u6536\u4efb\u52a1\u91cf", (String)"RadarGraphOfServiceOrgSatisfaction_23", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e73\u5747\u5904\u7406\u65f6\u957f", (String)"RadarGraphOfServiceOrgSatisfaction_4", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6279\u9000\u7387", (String)"RadarGraphOfServiceOrgSatisfaction_3", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9000\u626b\u7387", (String)"RadarGraphOfServiceOrgSatisfaction_6", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u8d85\u671f\u7387", (String)"RadarGraphOfServiceOrgSatisfaction_5", (String)"ssc-task-mobile", (Object[])new Object[0]))).kv("show", Boolean.TRUE).kv("trigger", "item"));
    }

    private static void setSeries(Map<String, Object> radarChartMap, IFormView view, Map<String, List<BigDecimal>> seriesDataListMap) {
        BigDecimal[] orgRadarData;
        BigDecimal[] averageRadarData;
        List<BigDecimal> average;
        if ("1".equals(view.getPageCache().get("average_domain_on_off"))) {
            average = seriesDataListMap.get("average");
            averageRadarData = average.toArray(new BigDecimal[0]);
        } else {
            averageRadarData = new BigDecimal[]{new BigDecimal("0.0"), new BigDecimal("0.0"), new BigDecimal("0.0"), new BigDecimal("0.0"), new BigDecimal("0.0")};
        }
        if ("1".equals(view.getPageCache().get("org_domain_on_off"))) {
            average = seriesDataListMap.get("org");
            orgRadarData = average.toArray(new BigDecimal[0]);
        } else {
            orgRadarData = new BigDecimal[]{new BigDecimal("0.0"), new BigDecimal("0.0"), new BigDecimal("0.0"), new BigDecimal("0.0"), new BigDecimal("0.0")};
        }
        radarChartMap.put("series", M.arraylist(M.map().kv("type", "radar").kv("symbolSize", 3).kv("areaStyle", M.map().kv("normal", map -> map.kv("opacity", 0.3))).kv("data", M.arraylist(M.map().kv("name", ResManager.loadKDString((String)"\u5747\u503c", (String)"RadarGraphOfServiceOrgSatisfaction_12", (String)"ssc-task-mobile", (Object[])new Object[0])).kv("value", averageRadarData).kv("itemStyle", M.map().kv("normal", M.map().kv("color", "#73D13D"))), M.map().kv("name", ((DynamicObject)view.getModel().getValue("compare_org")).getString("name")).kv("value", orgRadarData).kv("itemStyle", M.map().kv("normal", M.map().kv("color", "#40A9FF")))))));
    }

    private static Map<String, List<BigDecimal>> getSeriesData(IFormView view, DateSpanPO dateSpanPO) {
        HashMap<String, List<BigDecimal>> seriesListMap = new HashMap<String, List<BigDecimal>>();
        List<BigDecimal> averageSeriesDataList = RadarGraphOfServiceOrgSatisfaction.getAverageSeriesDataByOrgType(view, -2L, dateSpanPO);
        seriesListMap.put("average", averageSeriesDataList);
        List<Map.Entry<Long, BigDecimal>> orderedRecTaskCountEntry = SscServiceOrgSatisfactionDataHelper.orderedRecTaskCountEntry(RadarGraphOfServiceOrgSatisfaction.getSscId(view), dateSpanPO);
        log.info("\u521d\u59cb\u5316\u56fe\u4f8b\u65f6\u5f53\u524d\u65f6\u95f4\u8303\u56f4\u7684\u4efb\u52a1\u7ec4\u7ec7:" + orderedRecTaskCountEntry.size() + " --- " + orderedRecTaskCountEntry);
        if (CollectionUtils.isEmpty(orderedRecTaskCountEntry)) {
            view.setVisible(Boolean.FALSE, new String[]{"contentflexcore"});
            view.setVisible(Boolean.TRUE, new String[]{"defaultflex"});
            view.getPageCache().put("advance_suggestion_panel", "0");
            return new HashMap<String, List<BigDecimal>>();
        }
        view.setVisible(Boolean.TRUE, new String[]{"contentflexcore"});
        view.setVisible(Boolean.FALSE, new String[]{"defaultflex"});
        DynamicObject compareOrg = (DynamicObject)view.getModel().getValue("compare_org");
        if (compareOrg == null) {
            view.setVisible(Boolean.FALSE, new String[]{"contentflexcore"});
            view.setVisible(Boolean.TRUE, new String[]{"defaultflex"});
            view.getPageCache().put("advance_suggestion_panel", "0");
            return new HashMap<String, List<BigDecimal>>();
        }
        long orgId = compareOrg.getLong("id");
        List<BigDecimal> specifiedOrgSeriesDataList = RadarGraphOfServiceOrgSatisfaction.getAverageSeriesDataByOrgType(view, orgId, dateSpanPO);
        seriesListMap.put("org", specifiedOrgSeriesDataList);
        List<BigDecimal> boundarySeriesDataList = RadarGraphOfServiceOrgSatisfaction.getBoundarySeriesData(averageSeriesDataList, specifiedOrgSeriesDataList);
        seriesListMap.put("boundary", boundarySeriesDataList);
        return seriesListMap;
    }

    private static List<BigDecimal> getAverageSeriesDataByOrgType(IFormView view, Long orgId, DateSpanPO dateSpanPO) {
        ArrayList<BigDecimal> averageDataList = new ArrayList<BigDecimal>();
        Long sscId = RadarGraphOfServiceOrgSatisfaction.getSscId(view);
        BigDecimal ReceiveTaskCount = SscServiceOrgSatisfactionDataHelper.getReceiveTaskCount(sscId, orgId, dateSpanPO);
        averageDataList.add(ReceiveTaskCount);
        BigDecimal batchReturnPercent = SscServiceOrgSatisfactionDataHelper.getBatchReturnPercent(sscId, orgId, dateSpanPO);
        averageDataList.add(batchReturnPercent);
        BigDecimal returnScanPercent = SscServiceOrgSatisfactionDataHelper.getReturnScanPercent(sscId, orgId, dateSpanPO);
        averageDataList.add(returnScanPercent);
        BigDecimal overdueTaskPercent = SscServiceOrgSatisfactionDataHelper.getOverdueTaskCount(sscId, orgId, dateSpanPO);
        averageDataList.add(overdueTaskPercent);
        BigDecimal averageAuditTime = SscServiceOrgSatisfactionDataHelper.getAverageAuditTime(sscId, orgId, dateSpanPO);
        averageDataList.add(averageAuditTime);
        return averageDataList;
    }

    private static List<BigDecimal> getBoundarySeriesData(List<BigDecimal> averageSeriesDataList, List<BigDecimal> specifiedOrgSeriesDataList) {
        ArrayList<BigDecimal> boundarySeriesDataList = new ArrayList<BigDecimal>();
        for (int i = 0; i < averageSeriesDataList.size(); ++i) {
            BigDecimal var2;
            BigDecimal max;
            BigDecimal var1 = averageSeriesDataList.get(i);
            BigDecimal bigDecimal = max = var1.compareTo(var2 = specifiedOrgSeriesDataList.get(i)) >= 0 ? var1 : var2;
            if (max.compareTo(BigDecimal.ZERO) == 0) {
                boundarySeriesDataList.add(new BigDecimal("1.0"));
                continue;
            }
            if (i == 1 || i == 2 || i == 3) {
                BigDecimal fullPercent = new BigDecimal("100.0");
                BigDecimal maxPercent = max.multiply(new BigDecimal("1.2"));
                boundarySeriesDataList.add(maxPercent.compareTo(fullPercent) >= 0 ? fullPercent : maxPercent);
                continue;
            }
            boundarySeriesDataList.add(max.multiply(new BigDecimal("1.2")));
        }
        return boundarySeriesDataList;
    }

    private static void updateAdvanceSuggestionPanel(IFormView view, Map<String, List<BigDecimal>> seriesDataListMap, DateSpanPO dateSpanPO) {
        List<BigDecimal> averageList = seriesDataListMap.get("average");
        List<BigDecimal> orgList = seriesDataListMap.get("org");
        List<Map.Entry<Long, BigDecimal>> orderedRecTaskCountEntry = SscServiceOrgSatisfactionDataHelper.orderedRecTaskCountEntry(RadarGraphOfServiceOrgSatisfaction.getSscId(view), dateSpanPO);
        BigDecimal receiveTaskCount = orgList.get(0);
        List recTaskCountList = orderedRecTaskCountEntry.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        int taskIndex = recTaskCountList.indexOf(receiveTaskCount);
        Label label_suggest1_1 = (Label)view.getControl("label_suggest1_1");
        Label label_suggest1_2 = (Label)view.getControl("label_suggest1_2");
        label_suggest1_1.setText(String.format(ResManager.loadKDString((String)"\u63a5\u6536\u4efb\u52a1\u91cf\u6392\u540d\u7b2c%s", (String)"RadarGraphOfServiceOrgSatisfaction_13", (String)"ssc-task-mobile", (Object[])new Object[0]), taskIndex + 1));
        if (taskIndex <= 4) {
            label_suggest1_2.setText(ResManager.loadKDString((String)"\u4e3a\u4e3b\u8981\u670d\u52a1\u5bf9\u8c61", (String)"RadarGraphOfServiceOrgSatisfaction_14", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            label_suggest1_2.setText(ResManager.loadKDString((String)"\u4e0d\u662f\u4e3b\u8981\u670d\u52a1\u5bf9\u8c61", (String)"RadarGraphOfServiceOrgSatisfaction_15", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        BigDecimal averageAuditTime = averageList.get(4);
        BigDecimal orgAuditTime = orgList.get(4);
        Label label_suggest2_1 = (Label)view.getControl("label_suggest2_1");
        Label label_suggest2_2 = (Label)view.getControl("label_suggest2_2");
        Label label_suggest2_3 = (Label)view.getControl("label_suggest2_3");
        label_suggest2_1.setText(ResManager.loadKDString((String)"\u5e73\u5747\u5904\u7406\u65f6\u957f", (String)"RadarGraphOfServiceOrgSatisfaction_4", (String)"ssc-task-mobile", (Object[])new Object[0]));
        if (orgAuditTime.compareTo(averageAuditTime) >= 0) {
            label_suggest2_2.setText(ResManager.loadKDString((String)"\u9ad8\u4e8e\u5e73\u5747\u503c", (String)"RadarGraphOfServiceOrgSatisfaction_17", (String)"ssc-task-mobile", (Object[])new Object[0]));
            label_suggest2_3.setText(ResManager.loadKDString((String)"\u5efa\u8bae\u5bf9\u5ba1\u6838\u4eba\u5458\u8fdb\u884c\u5ba3\u8d2f\uff0c\u63d0\u9ad8\u5904\u7406\u6548\u7387\u3002", (String)"RadarGraphOfServiceOrgSatisfaction_18", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            label_suggest2_2.setText(ResManager.loadKDString((String)"\u4f4e\u4e8e\u5e73\u5747\u503c", (String)"RadarGraphOfServiceOrgSatisfaction_19", (String)"ssc-task-mobile", (Object[])new Object[0]));
            label_suggest2_3.setText("");
        }
        BigDecimal averageBatchReturnPercent = averageList.get(1);
        BigDecimal orgBatchReturnPercent = orgList.get(1);
        Label label_suggest3_1 = (Label)view.getControl("label_suggest3_1");
        Label label_suggest3_2 = (Label)view.getControl("label_suggest3_2");
        Label label_suggest3_3 = (Label)view.getControl("label_suggest3_3");
        label_suggest3_1.setText(ResManager.loadKDString((String)"\u6279\u9000\u7387", (String)"RadarGraphOfServiceOrgSatisfaction_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
        if (orgBatchReturnPercent.compareTo(averageBatchReturnPercent) >= 0) {
            label_suggest3_2.setText(ResManager.loadKDString((String)"\u9ad8\u4e8e\u5e73\u5747\u503c", (String)"RadarGraphOfServiceOrgSatisfaction_17", (String)"ssc-task-mobile", (Object[])new Object[0]));
            label_suggest3_3.setText(ResManager.loadKDString((String)"\u5efa\u8bae\u52a0\u5f3a\u5bf9\u8be5\u7ec4\u7ec7\u7684\u63d0\u5355\u57f9\u8bad\uff0c\u4ee5\u964d\u4f4e\u6279\u9000\u7387\u3002", (String)"RadarGraphOfServiceOrgSatisfaction_20", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            label_suggest3_2.setText(ResManager.loadKDString((String)"\u4f4e\u4e8e\u5e73\u5747\u503c", (String)"RadarGraphOfServiceOrgSatisfaction_19", (String)"ssc-task-mobile", (Object[])new Object[0]));
            label_suggest3_3.setText("");
        }
        BigDecimal averageReturnScanPercent = averageList.get(2);
        BigDecimal orgReturnScanPercent = orgList.get(2);
        Label label_suggest4_1 = (Label)view.getControl("label_suggest4_1");
        Label label_suggest4_2 = (Label)view.getControl("label_suggest4_2");
        Label label_suggest4_3 = (Label)view.getControl("label_suggest4_3");
        label_suggest4_1.setText(ResManager.loadKDString((String)"\u9000\u626b\u7387", (String)"RadarGraphOfServiceOrgSatisfaction_6", (String)"ssc-task-mobile", (Object[])new Object[0]));
        if (orgReturnScanPercent.compareTo(averageReturnScanPercent) >= 0) {
            label_suggest4_2.setText(ResManager.loadKDString((String)"\u9ad8\u4e8e\u5e73\u5747\u503c", (String)"RadarGraphOfServiceOrgSatisfaction_17", (String)"ssc-task-mobile", (Object[])new Object[0]));
            label_suggest4_3.setText(ResManager.loadKDString((String)"\u5efa\u8bae\u52a0\u5f3a\u62a5\u9500\u5236\u5ea6\u57f9\u8bad\u3002", (String)"RadarGraphOfServiceOrgSatisfaction_21", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            label_suggest4_2.setText(ResManager.loadKDString((String)"\u4f4e\u4e8e\u5e73\u5747\u503c", (String)"RadarGraphOfServiceOrgSatisfaction_19", (String)"ssc-task-mobile", (Object[])new Object[0]));
            label_suggest4_3.setText("");
        }
        BigDecimal averageOverdueTaskPercent = averageList.get(3);
        BigDecimal orgOverdueTaskPercent = orgList.get(3);
        Label label_suggest5_1 = (Label)view.getControl("label_suggest5_1");
        Label label_suggest5_2 = (Label)view.getControl("label_suggest5_2");
        Label label_suggest5_3 = (Label)view.getControl("label_suggest5_3");
        label_suggest5_1.setText(ResManager.loadKDString((String)"\u8d85\u671f\u7387", (String)"RadarGraphOfServiceOrgSatisfaction_22", (String)"ssc-task-mobile", (Object[])new Object[0]));
        if (orgOverdueTaskPercent.compareTo(averageOverdueTaskPercent) >= 0) {
            label_suggest5_2.setText(ResManager.loadKDString((String)"\u9ad8\u4e8e\u5e73\u5747\u503c", (String)"RadarGraphOfServiceOrgSatisfaction_17", (String)"ssc-task-mobile", (Object[])new Object[0]));
            label_suggest5_3.setText(ResManager.loadKDString((String)"\u5efa\u8bae\u5bf9\u5ba1\u6838\u4eba\u5458\u8fdb\u884c\u5ba3\u8d2f\uff0c\u63d0\u9ad8\u5904\u7406\u6548\u7387\u3002", (String)"RadarGraphOfServiceOrgSatisfaction_18", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            label_suggest5_2.setText(ResManager.loadKDString((String)"\u4f4e\u4e8e\u5e73\u5747\u503c", (String)"RadarGraphOfServiceOrgSatisfaction_19", (String)"ssc-task-mobile", (Object[])new Object[0]));
            label_suggest5_3.setText("");
        }
    }

    public static Long getSscId(IFormView view) {
        Object sharecenter = view.getFormShowParameter().getCustomParam("sharecenter");
        if (sharecenter == null) {
            return null;
        }
        return Long.valueOf(String.valueOf(sharecenter));
    }
}

