/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.warn;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class SscWarningValueRatioPlugin
extends AbstractMobFormPlugin {
    public static final String FORMID = "ssc_warningvalue_ratio";
    public static final String KEY_WARNING_VALUE = "key_warning_value";
    public static final String KEY_WARNING_NOTICE = "key_warning_notice";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String warningValue = (String)this.getView().getFormShowParameter().getCustomParam(KEY_WARNING_VALUE);
        if (StringUtils.isBlank((CharSequence)warningValue) || "null".equals(warningValue)) {
            this.getModel().setValue("warning_value", null);
        } else {
            this.getModel().setValue("warning_value", (Object)Integer.valueOf(warningValue));
        }
        String warningNotice = (String)this.getView().getFormShowParameter().getCustomParam(KEY_WARNING_NOTICE);
        this.getModel().setValue("warning_notice_button", (Object)StringUtils.equals((CharSequence)"1", (CharSequence)warningNotice));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("confirm".equals(operateKey)) {
            Integer warningValue = (Integer)this.getModel().getValue("warning_value");
            if (warningValue == null) {
                return;
            }
            if (warningValue >= 0 && warningValue <= 100) {
                String warningNoticeValue = (Boolean)this.getModel().getValue("warning_notice_button") != false ? "1" : "0";
                HashMap<String, String> returnDataMap = new HashMap<String, String>();
                returnDataMap.put(KEY_WARNING_VALUE, String.valueOf(warningValue));
                returnDataMap.put(KEY_WARNING_NOTICE, warningNoticeValue);
                this.getView().returnDataToParent(returnDataMap);
            }
        }
    }

    public static void jumpMeBy(AbstractFormPlugin plugin, String actionId, String warningValue, String warningNotice) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> custParam = new HashMap<String, String>();
        custParam.put("position", "bottom");
        parameter.getOpenStyle().setCustParam(custParam);
        parameter.setCustomParam(KEY_WARNING_VALUE, (Object)warningValue);
        parameter.setCustomParam(KEY_WARNING_NOTICE, (Object)warningNotice);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm((FormShowParameter)parameter);
    }
}

