/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.workload.graph;

import java.time.LocalDate;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.UserParameterHelper;
import kd.ssc.task.mobile.common.chart.M;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.utils.CommonUtils;

public class TaskStockTrendGraphicHelper {
    private static final String MONTH = "month";
    private static final String DAY = "day";

    public static void initTaskStockTrendGraph(IFormView view) {
        PointLineChart taskPoolChart = (PointLineChart)view.getControl("taskstock_trend");
        taskPoolChart.clearData();
        Map<String, Object> seriesDataMap = TaskStockTrendGraphicHelper.getSeriesData(view);
        TaskStockTrendGraphicHelper.setToolTip(taskPoolChart);
        TaskStockTrendGraphicHelper.setLegend(taskPoolChart);
        TaskStockTrendGraphicHelper.setGrid(taskPoolChart);
        TaskStockTrendGraphicHelper.setXAxis(taskPoolChart, seriesDataMap);
        TaskStockTrendGraphicHelper.setYAxis(taskPoolChart);
        TaskStockTrendGraphicHelper.setSeries(taskPoolChart, view, seriesDataMap);
        view.updateView("taskstock_trend");
    }

    private static void setSeries(PointLineChart taskPoolChart, IFormView view, Map<String, Object> seriesDataMap) {
        TaskStockTrendGraphicHelper.fillTrendSeries(taskPoolChart, view, seriesDataMap);
    }

    private static void fillTrendSeries(PointLineChart taskPoolChart, IFormView view, Map<String, Object> seriesDataMap) {
        HashMap<String, Object> normalMap1 = new HashMap<String, Object>();
        normalMap1.put("width", 1);
        normalMap1.put("color", "#276FF5");
        HashMap<String, HashMap<String, Object>> lineStyleMap1 = new HashMap<String, HashMap<String, Object>>();
        lineStyleMap1.put("normal", normalMap1);
        HashMap<String, Object> normalMap2 = new HashMap<String, Object>();
        normalMap2.put("show", Boolean.TRUE);
        normalMap2.put("position", "top");
        normalMap2.put("fontSize", 14);
        normalMap2.put("color", "#276FF5");
        HashMap<String, HashMap<String, Object>> labelMap1 = new HashMap<String, HashMap<String, Object>>();
        labelMap1.put("normal", normalMap2);
        HashMap<String, String> itemNormalMap = new HashMap<String, String>();
        itemNormalMap.put("color", "#276FF5");
        HashMap<String, HashMap<String, String>> itemStyleMap = new HashMap<String, HashMap<String, String>>();
        itemStyleMap.put("normal", itemNormalMap);
        HashMap<String, String> normalMap3 = new HashMap<String, String>();
        normalMap3.put("type", "dashed");
        normalMap3.put("color", "rgba(255,153,28,1)");
        HashMap<String, HashMap<String, String>> lineStyleMap = new HashMap<String, HashMap<String, String>>();
        lineStyleMap.put("normal", normalMap3);
        HashMap<String, Object> normalMap4 = new HashMap<String, Object>();
        normalMap4.put("position", "end");
        normalMap4.put("distance", 3);
        HashMap<String, HashMap<String, Object>> labelMap2 = new HashMap<String, HashMap<String, Object>>();
        labelMap2.put("normal", normalMap4);
        HashMap<String, Object> markLineDataMap = new HashMap<String, Object>();
        markLineDataMap.put("yAxis", TaskStockTrendGraphicHelper.getWarningValue(view));
        markLineDataMap.put("size", 24);
        markLineDataMap.put("symbol", "none");
        ArrayList<HashMap<String, Object>> markLineDataList = new ArrayList<HashMap<String, Object>>();
        markLineDataList.add(markLineDataMap);
        HashMap<String, Cloneable> markLineMap = new HashMap<String, Cloneable>();
        markLineMap.put("lineStyle", lineStyleMap);
        markLineMap.put("label", labelMap2);
        markLineMap.put("data", markLineDataList);
        LineSeries lineSeries = taskPoolChart.createLineSeries(ResManager.loadKDString((String)"\u5b58\u91cf\u8d8b\u52bf", (String)"TaskStockTrendGraphicHelper_5", (String)"ssc-task-mobile", (Object[])new Object[0]));
        lineSeries.setPropValue("symbolSize", (Object)6);
        lineSeries.setPropValue("lineStyle", lineStyleMap1);
        lineSeries.setPropValue("itemStyle", itemStyleMap);
        lineSeries.setPropValue("label", labelMap1);
        lineSeries.setPropValue("markLine", markLineMap);
        lineSeries.setPropValue("data", seriesDataMap.get("YValue"));
        Integer warningValue = TaskStockTrendGraphicHelper.getWarningValue(view);
        LineSeries warningLineSeries = taskPoolChart.createLineSeries(ResManager.loadKDString((String)"\u900f\u660e\u9884\u8b66\u8f85\u52a9", (String)"TaskStockTrendGraphicHelper_8", (String)"ssc-task-mobile", (Object[])new Object[0]));
        warningLineSeries.setPropValue("symbol", (Object)"none");
        warningLineSeries.setLineColor("rgba(255,255,255,0)");
        warningLineSeries.setPropValue("data", M.arraylist(warningValue));
    }

    private static void setYAxis(PointLineChart chart) {
        Axis yAxis = chart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u5b58\u91cf", (String)"TaskStockTrendGraphicHelper_7", (String)"ssc-task-mobile", (Object[])new Object[0]), AxisType.value);
        yAxis.setPropValue("min", (Object)0);
        yAxis.setPropValue("nameLocation", (Object)"end");
        yAxis.setPropValue("nameTextStyle", (Object)M.map().kv("color", "#999").kv("fontSize", 12).kv("padding", M.arraylist(0, 0, 15, 0)).kv("align", "left"));
        yAxis.setPropValue("axisLine", M.map("show", Boolean.FALSE));
        yAxis.setPropValue("splitLine", (Object)M.map().kv("lineStyle", M.map().kv("type", "dashed").kv("color", "rgba(232,232,232,1)")));
        yAxis.setPropValue("axisTick", M.map("show", Boolean.FALSE));
        yAxis.setPropValue("axisLabel", (Object)M.map().kv("color", "#999").kv("fontSize", 12));
    }

    private static void setXAxis(PointLineChart chart, Map<String, Object> seriesDataMap) {
        List xNames = (List)seriesDataMap.get("XName");
        HashMap<String, Integer> textStyleMap = new HashMap<String, Integer>();
        textStyleMap.put("fontSize", 12);
        ArrayList<M> dataList = new ArrayList<M>(xNames.size());
        for (String xName : xNames) {
            dataList.add(M.map().kv("value", xName).kv("textStyle", textStyleMap));
        }
        Axis xAxis = chart.createXAxis("", AxisType.category);
        xAxis.setPropValue("boundaryGap", (Object)Boolean.TRUE);
        xAxis.setPropValue("data", dataList);
        xAxis.setPropValue("axisLine", (Object)M.map().kv("lineStyle", map -> map.kv("color", "#E5E5E5").kv("width", 1)));
        xAxis.setPropValue("axisLabel", (Object)M.map().kv("color", "#999").kv("fontSize", 12));
    }

    private static void setGrid(PointLineChart taskPoolChart) {
        taskPoolChart.setMargin(Position.left, "5%");
        taskPoolChart.setMargin(Position.top, "18%");
        taskPoolChart.setMargin(Position.right, "12%");
        taskPoolChart.setMargin(Position.bottom, "3%");
    }

    private static void setLegend(PointLineChart taskPoolChart) {
        ArrayList<String> dataList = new ArrayList<String>();
        String string = ResManager.loadKDString((String)"\u5b58\u91cf\u8d8b\u52bf", (String)"TaskStockTrendGraphicHelper_5", (String)"ssc-task-mobile", (Object[])new Object[0]);
        String string2 = ResManager.loadKDString((String)"\u5b58\u91cf\u9884\u8b66", (String)"TaskStockTrendGraphicHelper_6", (String)"ssc-task-mobile", (Object[])new Object[0]);
        dataList.add(string);
        dataList.add(string2);
        taskPoolChart.setLegendPropValue("data", dataList);
        taskPoolChart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
    }

    private static void setToolTip(PointLineChart taskPoolChart) {
        taskPoolChart.addTooltip("trigger", (Object)"axis");
    }

    private static Map<String, Object> getSeriesData(IFormView view) {
        String timeType;
        switch (timeType = (String)view.getModel().getValue("radiogroupfield")) {
            case "1": {
                return TaskStockTrendGraphicHelper.getSeriesDataByDate(view, 6, MONTH);
            }
            case "2": {
                return TaskStockTrendGraphicHelper.getSeriesDataByDate(view, 7, DAY);
            }
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> getSeriesDataByDate(IFormView view, int count, String DateType) {
        HashMap<String, Object> seriesDataMap = new HashMap<String, Object>();
        ArrayList<String> seriesDataXName = new ArrayList<String>();
        ArrayList<Integer> seriesData = new ArrayList<Integer>(count);
        QFilter userFilter = TaskStockTrendGraphicHelper.userFilter(TaskStockTrendGraphicHelper.getSscId(view), TaskStockTrendGraphicHelper.getGroupId(view));
        QFilter statusFilterOfProcessing = new QFilter("pooltype", "=", (Object)"1");
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        ORM orm = ORM.create();
        DataSet preTaskDataSet = orm.queryDataSet("kd.ssc.task.mobile.formplugin.workload.graph.TaskStockTrendGraphicHelper", "task_task", "id,receivetime", new QFilter[]{userFilter, statusFilterOfProcessing, notQuaCheckTask}, null);
        DataSet preHistoryTaskDataSet = orm.queryDataSet("kd.ssc.task.mobile.formplugin.workload.graph.TaskStockTrendGraphicHelper", "task_taskhistory", "id,receivetime,completetime", new QFilter[]{userFilter, notQuaCheckTask}, null);
        LocalDate startLocalDateOfCurrentPeriod = StringUtils.equals((CharSequence)DateType, (CharSequence)MONTH) ? LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()) : LocalDate.now();
        LocalDate endLocalDateOfCurrentPeriod = LocalDate.now().plusDays(1L);
        HashMap<String, Date> paramMap1 = new HashMap<String, Date>();
        paramMap1.put("time", CommonUtils.localDate2Date(endLocalDateOfCurrentPeriod));
        int currentCount = preTaskDataSet.copy().filter("receivetime < time", paramMap1).count("id", false);
        seriesData.add(currentCount);
        if (StringUtils.equals((CharSequence)DateType, (CharSequence)MONTH)) {
            seriesDataXName.add(startLocalDateOfCurrentPeriod.getMonth().getDisplayName(TextStyle.SHORT, Lang.get().getLocale()));
        } else {
            seriesDataXName.add(startLocalDateOfCurrentPeriod.getDayOfMonth() + "");
        }
        for (int i = 1; i < count; ++i) {
            Date startDateOfCurrentPeriod = CommonUtils.localDate2Date(startLocalDateOfCurrentPeriod);
            Date endDateOfCurrentPeriod = CommonUtils.localDate2Date(endLocalDateOfCurrentPeriod);
            HashMap<String, Date> paramMap2 = new HashMap<String, Date>();
            paramMap2.put("time1", startDateOfCurrentPeriod);
            paramMap2.put("time2", endDateOfCurrentPeriod);
            int decreaseCount = preHistoryTaskDataSet.copy().filter("time1 <= completetime and completetime < time2", paramMap2).count("id", false);
            HashMap<String, Date> paramMap3 = new HashMap<String, Date>();
            paramMap3.put("time1", startDateOfCurrentPeriod);
            paramMap3.put("time2", endDateOfCurrentPeriod);
            HashMap<String, Date> paramMap4 = new HashMap<String, Date>();
            paramMap4.put("time1", startDateOfCurrentPeriod);
            paramMap4.put("time2", endDateOfCurrentPeriod);
            int increaseCount = preTaskDataSet.copy().filter("time1 <= receivetime and receivetime < time2", paramMap3).count("id", false) + preHistoryTaskDataSet.copy().filter("time1 <= receivetime and receivetime < time2", paramMap4).count("id", false);
            currentCount = currentCount + decreaseCount - increaseCount;
            endLocalDateOfCurrentPeriod = startLocalDateOfCurrentPeriod;
            startLocalDateOfCurrentPeriod = StringUtils.equals((CharSequence)DateType, (CharSequence)MONTH) ? LocalDate.now().minusMonths(i).with(TemporalAdjusters.firstDayOfMonth()) : LocalDate.now().minusDays(i);
            seriesData.add(currentCount);
            if (StringUtils.equals((CharSequence)DateType, (CharSequence)MONTH)) {
                seriesDataXName.add(startLocalDateOfCurrentPeriod.getMonth().getDisplayName(TextStyle.SHORT, Lang.get().getLocale()));
                continue;
            }
            seriesDataXName.add(startLocalDateOfCurrentPeriod.getDayOfMonth() + "");
        }
        Collections.reverse(seriesDataXName);
        Collections.reverse(seriesData);
        seriesDataMap.put("XName", seriesDataXName);
        seriesDataMap.put("YValue", seriesData);
        return seriesDataMap;
    }

    private static Long getSscId(IFormView view) {
        Long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)view.getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)view.getFormShowParameter().getCustomParam("sharecenter"));
        }
        return sscId;
    }

    private static String getGroupId(IFormView view) {
        return (String)view.getFormShowParameter().getCustomParam("usergroup");
    }

    private static QFilter userFilter(Long sscId, String userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (StringUtils.isBlank((CharSequence)userGroupId) || "-1".equals(userGroupId)) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)Long.parseLong(userGroupId));
    }

    private static Integer getWarningValue(IFormView view) {
        String warningStr = null;
        IFormView parentView = view.getParentView();
        if (parentView != null) {
            warningStr = TaskStockTrendGraphicHelper.getWarningStrFromParentViewCache(parentView, "ssc_subject_card_m", CardEnum.TaskPoolCard.getFormId());
        }
        if (StringUtils.isBlank(warningStr) && parentView != null) {
            warningStr = TaskStockTrendGraphicHelper.getWarningStrFromParentViewCache(parentView, "ssc_index_m", CardEnum.TaskPoolCard.getFormId());
        }
        if (StringUtils.isBlank(warningStr)) {
            warningStr = UserParameterHelper.getKeyValue(TaskStockTrendGraphicHelper.getWarningKey(view));
        }
        String warningValueStr = null;
        if (warningStr != null) {
            warningValueStr = warningStr.split("#")[0];
        }
        return StringUtils.isBlank(warningValueStr) || Integer.parseInt(warningValueStr) == 0 ? -1 : Integer.parseInt(warningValueStr);
    }

    private static String getWarningStrFromParentViewCache(IFormView parentView, String parentViewFormid, String cardFormId) {
        IFormView taskPoolView = parentView.getView(parentView.getPageCache().get(parentViewFormid + "#" + cardFormId));
        if (taskPoolView != null) {
            return taskPoolView.getPageCache().get("warning_key");
        }
        return null;
    }

    private static String getWarningKey(IFormView view) {
        return "scc_taskpool_card_m#" + view.getFormShowParameter().getCustomParam("sharecenter") + "#" + view.getFormShowParameter().getCustomParam("usergroup");
    }
}

