/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.openapi;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.kuep.capp.model.card.DataPanelCard;
import kd.kuep.capp.sdk.DataPanelCardProxy;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.TeamLeaderApi;
import kd.ssc.task.mobile.utils.DateSpanCommonUtils;

public class TaskPoolPlugin
implements IBillWebApiPlugin {
    public static final Log logger = LogFactory.getLog(TaskPoolPlugin.class);
    private static final String DEFUALT_GROUPID = "-1";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";

    public ApiResult doCustomService(Map<String, Object> params) {
        logger.info("TaskPoolPlugin request parameters\uff1a" + params);
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        try {
            long userId = RequestContext.get().getCurrUserId();
            logger.info("the operator : " + userId);
            List<ComboItem> items = TeamLeaderApi.getSscenters(userId, "ssc_index_m");
            ComboItem item = items.stream().min((o1, o2) -> o1.getValue().compareTo(o2.getValue())).orElse(null);
            assert (item != null);
            String value = item.getValue();
            logger.info("the orgId : " + value);
            int currentCount = TaskPoolPlugin.getCurrentCount(Long.parseLong(value), DEFUALT_GROUPID, params);
            int decreaseCount = TaskPoolPlugin.getDecreaseCount(Long.parseLong(value), DEFUALT_GROUPID, params);
            int increaseCount = TaskPoolPlugin.getIncreaseCount(Long.parseLong(value), DEFUALT_GROUPID, params);
            logger.info(String.format("currentCount:%s ,decreaseCount:%s ,increaseCount:%s", currentCount, decreaseCount, increaseCount));
            DataPanelCardProxy dataPanelCardProxy = new DataPanelCardProxy();
            DataPanelCard dataPanelCard = dataPanelCardProxy.getDataPanelCard();
            dataPanelCard.setCardTitle(ResManager.loadKDString((String)"\u5171\u4eab\u4efb\u52a1\u5904\u7406\u8fdb\u5ea6", (String)"TaskPoolPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
            dataPanelCardProxy.addDataList(ResManager.loadKDString((String)"\u65b0\u589e", (String)"TaskPoolPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]), increaseCount + "", null, null, null, null, null, null);
            dataPanelCardProxy.addDataList(ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"TaskPoolPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]), decreaseCount + "", null, null, null, null, null, null);
            dataPanelCardProxy.addDataList(ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"TaskPoolPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]), currentCount + "", null, null, null, null, null, null);
            result.setData((Object)dataPanelCard);
        }
        catch (NumberFormatException e) {
            logger.error("TaskPoolPlugin handle failed ", (Throwable)e);
            result.setErrorCode("2000");
            result.setMessage("data parsing failed");
        }
        return result;
    }

    private static QFilter getCommonFilter(Map<String, Object> params, String param, boolean isCur) {
        LocalDate startLocalDate = null;
        LocalDate endLocalDate = null;
        if (!ObjectUtils.isEmpty((Object)params.get(START_DATE))) {
            startLocalDate = LocalDate.parse(params.get(START_DATE).toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        if (!ObjectUtils.isEmpty((Object)params.get(END_DATE))) {
            endLocalDate = LocalDate.parse(params.get(END_DATE).toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        if (isCur) {
            QFilter filter = DateSpanCommonUtils.timeSection(param, startLocalDate, endLocalDate);
            return notQuaCheckTask.and(filter);
        }
        return notQuaCheckTask;
    }

    /*
     * Exception decompiling
     */
    private static int getIncreaseCount(Long sscId, String userGroupId, Map<String, Object> params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int getDecreaseCount(Long sscId, String userGroupId, Map<String, Object> params) {
        QFilter userFilter = TaskPoolPlugin.userFilter(sscId, userGroupId);
        QFilter commonFilter = TaskPoolPlugin.getCommonFilter(params, "completetime", true);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ssc", (String)"task_taskhistory", (String)"id", (QFilter[])new QFilter[]{userFilter, commonFilter}, null);){
            int n = dataSet.count("id", false);
            return n;
        }
    }

    private static int getCurrentCount(Long sscId, String userGroupId, Map<String, Object> params) {
        QFilter userFilter = TaskPoolPlugin.userFilter(sscId, userGroupId);
        QFilter statusFilter = new QFilter("pooltype", "=", (Object)"1");
        QFilter commonFilter = TaskPoolPlugin.getCommonFilter(params, null, false);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ssc", (String)"task_task", (String)"id", (QFilter[])new QFilter[]{userFilter, statusFilter, commonFilter}, null);){
            int n = dataSet.count("id", false);
            return n;
        }
    }

    private static QFilter userFilter(Long sscId, String userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (userGroupId == null || "".equals(userGroupId) || DEFUALT_GROUPID.equals(userGroupId)) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)Long.valueOf(userGroupId));
    }
}

