/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template;

import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Series;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.ssc.task.mobile.common.chart.M;
import kd.ssc.task.mobile.template.ChartListTemplatePlugin;
import kd.ssc.task.mobile.template.ITemplateDataProcess;
import kd.ssc.task.mobile.template.data.GNode;
import kd.ssc.task.mobile.template.data.ItemModel;
import kd.ssc.task.mobile.template.data.ListDataModel;
import kd.ssc.task.mobile.template.data.TransferData;
import kd.ssc.task.mobile.utils.InvokeUtil;

public class CustomChartListTemplatePlugin
extends ChartListTemplatePlugin {
    protected static final String CTRL_LABELAPTITLE = "labelaptitle";
    protected static final String CTRL_COMBOFIELD = "combofield";

    @Override
    protected void initView(TransferData transferData) {
        List<String> groupbys = transferData.getGroupbys();
        ITemplateDataProcess process = (ITemplateDataProcess)InvokeUtil.getInstance(transferData.getDataProcessClassName());
        List<GNode> gNodes = process.getGroupNode(transferData.getKey()).selectSwichList(groupbys);
        List comboItems = gNodes.stream().map(gNode1 -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(gNode1.getGroupName()));
            comboItem.setValue(gNode1.getGroupby());
            return comboItem;
        }).collect(Collectors.toList());
        if (comboItems.size() > 0) {
            ComboEdit combo = (ComboEdit)this.getControl(CTRL_COMBOFIELD);
            combo.setComboItems(comboItems);
            this.getModel().setValue(CTRL_COMBOFIELD, (Object)groupbys.get(groupbys.size() - 1));
            this.getView().updateView(CTRL_COMBOFIELD);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CTRL_COMBOFIELD});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (CTRL_COMBOFIELD.equals(propertyName)) {
            Object value = this.getModel().getValue(CTRL_COMBOFIELD);
            TransferData transferData = this.getTransferData();
            transferData.getGroupbys().set(transferData.getGroupbys().size() - 1, String.valueOf(value));
            this.saveTransferData(transferData);
            this.loadData(transferData);
        }
    }

    @Override
    protected void setChart(ListDataModel data) {
        Label labelTitle = (Label)this.getView().getControl(CTRL_LABELAPTITLE);
        labelTitle.setText(data.getChartTitle());
        super.setChart(data);
    }

    @Override
    protected Axis setXAxis(Chart chart, String xName, List<ItemModel> items) {
        Axis axis = super.setXAxis(chart, xName, items);
        axis.setPropValue("axisLabel", (Object)M.map().kv("interval", 0).kv("color", "#999999").kv("formatter", " function(value){ return value.split('##').join(\"\\n\"); }"));
        chart.addFuncPath(M.arraylist("xAxis", 0, "axisLabel", "formatter"));
        return axis;
    }

    @Override
    protected Object disposeXaxisValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        return this.joinLines(value);
    }

    @Override
    protected Series createSeries(Chart chart, ListDataModel data) {
        BarSeries series = chart.createBarSeries(data.getSeriesName());
        this.setSeriesProp((Series)series, data);
        series.setBarWidth("18");
        return series;
    }

    private String joinLines(String text) {
        int col = 3;
        int length = text.length();
        boolean toolong = false;
        if (length > 9) {
            text = text.substring(0, 8);
            toolong = true;
            length = text.length();
        }
        if (length > col) {
            int lines = (int)Math.ceil((double)text.length() * 1.0 / (double)col);
            StringJoiner stringJoiner = new StringJoiner("##");
            for (int i = 0; i < lines; ++i) {
                stringJoiner.add(text.substring(3 * i, Math.min(3 * (i + 1), length)));
            }
            if (toolong) {
                return stringJoiner + "...";
            }
            return stringJoiner.toString();
        }
        return text;
    }
}

