/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Label;
import kd.ssc.task.mobile.common.chart.M;
import kd.ssc.task.mobile.template.AbstractListTemplatePlugin;
import kd.ssc.task.mobile.template.data.ItemModel;
import kd.ssc.task.mobile.template.data.ListDataModel;

public class PieChartListTemplatePlugin
extends AbstractListTemplatePlugin {
    protected static final String CTRL_CHART_AP = "piechartap";
    protected static final String[] COLORS_PIECHARTS = new String[]{"#276FF5", "#26C9C3", "#95DE64", "#FFC53D"};

    @Override
    protected void setChart(ListDataModel data) {
        Chart pieChart = this.initChart();
        this.createSeries(pieChart, data);
        this.createLegend(data.getDatas());
        pieChart.refresh();
    }

    protected Chart initChart() {
        Chart chart = (Chart)this.getControl(CTRL_CHART_AP);
        chart.clearData();
        chart.setShowTooltip(false);
        chart.setShowLegend(false);
        return chart;
    }

    protected void createSeries(Chart pieChart, ListDataModel dataModel) {
        PieSeries series = pieChart.createPieSeries("piechart");
        ArrayList<M> data = new ArrayList<M>();
        List<ItemModel> list = dataModel.getDatas();
        int n = Math.min(list.size(), 3);
        int i = 0;
        while (i < n) {
            ItemModel result = list.get(i);
            int finalI = i++;
            data.add(M.map().kv("name", result.getItemname()).kv("value", result.getValue()).kv("itemStyle", map -> map.kv("normal", M.map("color", COLORS_PIECHARTS[finalI % 4]))));
        }
        if (list.size() > 3) {
            BigDecimal totalValue = BigDecimal.ZERO;
            for (int i2 = 3; i2 < list.size(); ++i2) {
                totalValue = totalValue.add(list.get(i2).getValue());
            }
            String text = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"PieChartListTemplatePlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]);
            data.add(M.map().kv("name", text).kv("value", totalValue).kv("itemStyle", M.map("normal", M.map("color", COLORS_PIECHARTS[3]))));
        }
        series.setPropValue("data", data);
        if (StringUtils.isNotBlank((CharSequence)dataModel.getLabelText())) {
            series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("formatter", dataModel.getLabelText()).kv("rich", map1 -> map1.kv("a", map2 -> map2.kv("color", "#212121").kv("fontSize", "12")).kv("b", map2 -> map2.kv("color", "#276FF5").kv("fontSize", "24"))).kv("position", "center")).kv("show", Boolean.TRUE));
        }
        series.setPropValue("avoidLabelOverlap", (Object)Boolean.FALSE);
        series.setPropValue("silent", (Object)Boolean.FALSE);
        series.addFuncPath(M.arraylist("label", "normal", "formatter"));
        series.setRadius("48%", "80%");
        series.setPropValue("center", (Object)new Object[]{"50%", "50%"});
    }

    protected void createLegend(List<ItemModel> datas) {
        BigDecimal allNumber = BigDecimal.ZERO;
        int n = Math.min(datas.size(), 3);
        for (int i = 0; i < n; ++i) {
            ItemModel data = datas.get(i);
            ((Label)this.getControl("pieitemqplabeln" + i)).setText(data.getItemname());
            ((Label)this.getControl("pieitemqplabelv" + i)).setText(data.getItemvalue());
            allNumber = allNumber.add(data.getValue());
        }
        if (datas.size() > 3) {
            BigDecimal totalValue = BigDecimal.ZERO;
            for (int i = 3; i < datas.size(); ++i) {
                totalValue = totalValue.add(datas.get(i).getValue());
            }
            allNumber = allNumber.add(totalValue);
            BigDecimal elsePercent = totalValue.multiply(new BigDecimal("100")).divide(allNumber, 1, RoundingMode.HALF_UP);
            ((Label)this.getControl("pieitemqplabeln3")).setText(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"PieChartListTemplatePlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
            ((Label)this.getControl("pieitemqplabelv3")).setText(elsePercent + "%");
        }
    }
}

