/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template.datespan;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.ssc.task.mobile.template.datespan.DateSpanEnum;
import kd.ssc.task.mobile.template.datespan.IDateRange;

public final class DateRangePO
implements IDateRange {
    private String spanType;
    private String spanTypeDesc;
    private Date startDate;
    private String startDateStr;
    private Date endDate;
    private String endDateStr;

    public DateRangePO() {
    }

    public DateRangePO(DateSpanEnum currentMonth) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        this.spanType = currentMonth.getNumber();
        this.spanTypeDesc = currentMonth.getName();
        DateRangePO rangePO = DateSpanEnum.getDateSpanByType(this.spanType);
        this.startDate = rangePO.getStartDate();
        this.endDate = rangePO.getEndDate();
        this.startDateStr = this.startDate != null ? simpleDateFormat.format(this.startDate) : "";
        this.endDateStr = this.endDate != null ? simpleDateFormat.format(this.endDate) : "";
    }

    public DateRangePO(String spanType, Date startDate, Date endDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        this.spanType = spanType;
        this.spanTypeDesc = DateSpanEnum.getNameByNumber(spanType);
        if (DateSpanEnum.UNLIMIT.getNumber().equals(spanType)) {
            return;
        }
        this.startDate = startDate;
        this.startDateStr = simpleDateFormat.format(startDate);
        this.endDate = endDate;
        this.endDateStr = simpleDateFormat.format(endDate);
    }

    public String getSpanType() {
        return this.spanType;
    }

    public void setSpanType(String spanType) {
        this.spanType = spanType;
    }

    public String getStartDateStr() {
        return this.startDateStr;
    }

    public void setStartDateStr(String startDateStr) {
        this.startDateStr = startDateStr;
    }

    public String getEndDateStr() {
        return this.endDateStr;
    }

    public void setEndDateStr(String endDateStr) {
        this.endDateStr = endDateStr;
    }

    @Override
    public String getSpanTypeDesc() {
        if (DateSpanEnum.CUSTOM.getNumber().equals(this.getSpanType())) {
            return this.getStartDateStr() + " ~ " + this.getEndDateStr();
        }
        return this.spanTypeDesc;
    }

    public void setSpanTypeDesc(String spanTypeDesc) {
        this.spanTypeDesc = spanTypeDesc;
    }

    @Override
    public final Date getStartDate() {
        return this.startDate;
    }

    public final void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public final Date getEndDate() {
        return this.endDate;
    }

    public final void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}

