/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template.enums;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.ssc.task.mobile.common.MultiLangEnumBridge;

public enum TimeSlotEnum {
    TIME_SLOT_FIRST(new MultiLangEnumBridge("3\u5929\u4ee5\u5185", "TimeSlotEnum_0", "ssc-task-mobile")),
    TIME_SLOT_SECOND(new MultiLangEnumBridge("4-7\u5929", "TimeSlotEnum_1", "ssc-task-mobile")),
    TIME_SLOT_THREE(new MultiLangEnumBridge("8-15\u5929", "TimeSlotEnum_2", "ssc-task-mobile")),
    TIME_SLOT_FOUR(new MultiLangEnumBridge("16-30\u5929", "TimeSlotEnum_3", "ssc-task-mobile")),
    TIME_SLOT_FIVE(new MultiLangEnumBridge("30\u5929\u4ee5\u4e0a", "TimeSlotEnum_4", "ssc-task-mobile"));

    private final MultiLangEnumBridge value;

    private TimeSlotEnum(MultiLangEnumBridge value) {
        this.value = value;
    }

    public static String getTimeSlot(BigDecimal restTime) {
        double restTimeValue = restTime.abs().doubleValue();
        if (restTimeValue <= 24.0) {
            return TimeSlotEnum.TIME_SLOT_FIRST.value.loadKDString();
        }
        if (24.0 < restTimeValue && restTimeValue <= 56.0) {
            return TimeSlotEnum.TIME_SLOT_SECOND.value.loadKDString();
        }
        if (56.0 < restTimeValue && restTimeValue <= 120.0) {
            return TimeSlotEnum.TIME_SLOT_THREE.value.loadKDString();
        }
        if (120.0 < restTimeValue && restTimeValue <= 240.0) {
            return TimeSlotEnum.TIME_SLOT_FOUR.value.loadKDString();
        }
        return TimeSlotEnum.TIME_SLOT_FIVE.value.loadKDString();
    }

    public static List<String> getTimeSlotList() {
        TimeSlotEnum[] values = TimeSlotEnum.values();
        return Stream.of(values).map(v -> v.value.loadKDString()).collect(Collectors.toList());
    }
}

