/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.api.smartcs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.SelectsModel;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.ssc.mircoservice.helper.SmartCustomerServiceHelper;
import kd.ssc.mircoservice.result.ServiceResult;

public class SmartcsAISelectModelApiPlugin
extends AbstractBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(SmartcsAISelectModelApiPlugin.class);
    private static final ThreadLocal<String> command = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAICommand(AICommandEvent e) {
        String c = e.getCommand().getCommand();
        logger.info("SmartCustomerServiceApiPlugin doAICommand:{} accept a request:", (Object)JSON.toJSONString((Object)e));
        ApiResult apiResult = null;
        try {
            command.set(c);
            ServiceResult serviceResult = this.invokeService(e);
            apiResult = serviceResult.toApiResultWithoutData();
            if (apiResult.getSuccess()) {
                this.setApiResultData(apiResult, (ServiceResult<List<JSONObject>>)serviceResult);
            } else {
                this.setApiBizErrorResultData(apiResult, (ServiceResult<String>)serviceResult);
            }
        }
        catch (Exception ex) {
            apiResult = ApiResult.ex((Throwable)ex);
            logger.error("SmartCustomerServiceApiPlugin doAICommand:{} occur exception:{}", (Object)c, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
        finally {
            command.remove();
            logger.info("SmartCustomerServiceApiPlugin doAICommand:{} response result:{}", (Object)c, (Object)JSON.toJSONString((Object)apiResult));
            e.setResult(apiResult);
        }
    }

    private ServiceResult invokeService(AICommandEvent e) {
        AICommand aiCommand = e.getCommand();
        String params = JSON.toJSONString((Object)aiCommand.getParameter());
        String jsonResult = SmartCustomerServiceHelper.getGroups((String)params);
        return (ServiceResult)JSON.parseObject((String)jsonResult, ServiceResult.class);
    }

    private void setApiResultData(ApiResult apiResult, ServiceResult<List<JSONObject>> serviceResult) {
        List assistantDataList = (List)serviceResult.getData();
        if (!CollectionUtils.isEmpty((Collection)assistantDataList)) {
            SelectsModel selectsModel = this.createSelectsModel(assistantDataList);
            ResponseModel responseModel = ResponseModel.createSelectsResponse((SelectsModel)selectsModel);
            apiResult.setData((Object)responseModel);
        }
    }

    private SelectsModel createSelectsModel(List<JSONObject> assistantDataList) {
        ArrayList<SelectsModel.SelectItem> selects = new ArrayList<SelectsModel.SelectItem>(assistantDataList.size());
        for (JSONObject obj : assistantDataList) {
            SelectsModel.SelectItem item = new SelectsModel.SelectItem(obj.getString("staffIds"), obj.getString("groupName"));
            selects.add(item);
        }
        String title = ResManager.loadKDString((String)"\u5ba2\u670d\u5206\u7ec4", (String)"SmartcsAISelectModelApiPlugin_1", (String)"ssc-task-webapi", (Object[])new Object[0]);
        return new SelectsModel(title, selects);
    }

    private void setApiBizErrorResultData(ApiResult apiResult, ServiceResult<String> serviceResult) {
        String message = serviceResult.getMessage();
        logger.info("SmartcsAITextModelApiPlugin data:{} from microservice", (Object)message);
        if (message != null) {
            ResponseModel content = ResponseModel.createTextResponse((String)message);
            apiResult.setData((Object)content);
            apiResult.setSuccess(true);
            apiResult.setErrorCode("success");
        }
    }
}

