/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.api.workcalendar;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.workcalendar.SscTimeOp;
import kd.ssc.task.common.workcalendar.WorkCalendarServiceHelper;
import kd.ssc.task.util.DateUtil;
import org.hibernate.validator.constraints.Length;

@ApiController(value="ssc", desc="\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\u670d\u52a1\u63a5\u53e3")
@ApiMapping(value="/workcalendar")
public class WorkCalendarApiController {
    private static final List<String> timeOpTypes = Arrays.asList(SscTimeOp.ASKFORLEAVE.getValue(), SscTimeOp.CANCLELEAVE.getValue(), SscTimeOp.OVERTIME.getValue(), SscTimeOp.CANCLEOVERTIME.getValue());
    private String errCode;
    private String errMessage;

    @ApiPostMapping(value="/updateUserWorkTime", desc="\u5de5\u4f5c\u65e5\u5386\u8bf7\u5047&\u52a0\u73ed\u63a5\u53e3")
    @ApiErrorCodes(value={@ApiErrorCode(code="001", desc="\u53c2\u6570\u4e0d\u5408\u6cd5")})
    public CustomApiResult<?> updateUserWorkTime(@NotNull @Positive @ApiParam(value="\u5171\u4eab\u4e2d\u5fc3id", required=true) @NotNull @Positive @ApiParam(value="\u5171\u4eab\u4e2d\u5fc3id", required=true) Long sscid, @NotNull @Positive @ApiParam(value="\u7528\u6237\u7ec4id", required=true) @NotNull @Positive @ApiParam(value="\u7528\u6237\u7ec4id", required=true) Long userGroupId, @NotNull @Positive @ApiParam(value="\u7528\u6237id", required=true) @NotNull @Positive @ApiParam(value="\u7528\u6237id", required=true) Long userId, @NotNull @ApiParam(value="\u8d77\u59cb\u65e5\u671f\uff0c\u683c\u5f0fyyyy-MM-dd", required=true, example="2022-11-20") @NotNull @ApiParam(value="\u8d77\u59cb\u65e5\u671f\uff0c\u683c\u5f0fyyyy-MM-dd", required=true, example="2022-11-20") Date startDate, @NotNull @ApiParam(value="\u7ed3\u675f\u65e5\u671f\uff0c\u683c\u5f0fyyyy-MM-dd", required=true, example="2022-11-25") @NotNull @ApiParam(value="\u7ed3\u675f\u65e5\u671f\uff0c\u683c\u5f0fyyyy-MM-dd", required=true, example="2022-11-25") Date endDate, @NotEmpty @Length(max=1) @ApiParam(value="\u65f6\u95f4\u6bb5\u7c7b\u578b\uff0c'1'\u8bf7\u5047\uff0c'2'\u9500\u5047\uff0c'3'\u52a0\u73ed\uff0c'4'\u53d6\u6d88\u52a0\u73ed", required=true, example="3") @NotEmpty @Length(max=1) @ApiParam(value="\u65f6\u95f4\u6bb5\u7c7b\u578b\uff0c'1'\u8bf7\u5047\uff0c'2'\u9500\u5047\uff0c'3'\u52a0\u73ed\uff0c'4'\u53d6\u6d88\u52a0\u73ed", required=true, example="3") String timeOpType, @NotNull @ApiParam(value="\u65f6\u95f4\u6bb5\u96c6\u5408\uff0c[\"19:00-21:00\"]\uff0c\u82e5timeOpType='1'\uff0c\u5219\u8868\u793a\u4ecestartDate\u81f3endDate\u7684\u6bcf\u592919:00-21:00\u52a0\u73ed", required=true) @NotNull @ApiParam(value="\u65f6\u95f4\u6bb5\u96c6\u5408\uff0c[\"19:00-21:00\"]\uff0c\u82e5timeOpType='1'\uff0c\u5219\u8868\u793a\u4ecestartDate\u81f3endDate\u7684\u6bcf\u592919:00-21:00\u52a0\u73ed", required=true) List<String> timeIntervals) {
        Date endDate_;
        Date startDate_;
        try {
            startDate_ = DateUtil.getCurDateForm((Date)startDate, (boolean)true);
            endDate_ = DateUtil.getCurDateForm((Date)endDate, (boolean)true);
        }
        catch (ParseException e) {
            return CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"WorkCalendarApiController_0", (String)"ssc-task-webapi", (Object[])new Object[0]));
        }
        if (!this.validate(sscid, userGroupId, userId, startDate_, endDate_, timeOpType, timeIntervals)) {
            return CustomApiResult.fail((String)this.errCode, (String)this.errMessage);
        }
        WorkCalendarServiceHelper.updateUserWorkTime((Long)sscid, (Long)userGroupId, (Long)userId, (Date)startDate_, (Date)endDate_, (SscTimeOp)SscTimeOp.getSscTimeOp((String)timeOpType), timeIntervals);
        CustomApiResult result = new CustomApiResult();
        result.setStatus(true);
        result.setMessage(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u5386\u66f4\u65b0\u6210\u529f\u3002", (String)"WorkCalendarApiController_7", (String)"ssc-task-webapi", (Object[])new Object[0]));
        return result;
    }

    private boolean validate(Long sscid, Long userGroupId, Long userId, Date startDate, Date endDate, String timeOpType, List<String> timeIntervals) {
        return this.validateUser(sscid, userGroupId, userId) && this.validateDateRange(startDate, endDate) && this.validateTimeOpType(timeOpType) && this.validateTimeIntervals(timeIntervals);
    }

    private boolean validateUser(Long sscid, Long userGroupId, Long userId) {
        QFilter idFil = new QFilter("id", "=", (Object)userGroupId);
        QFilter sscidFil = new QFilter("createorg", "=", (Object)sscid);
        QFilter userIdFil = new QFilter("entryentity.userfield", "=", (Object)userId);
        boolean isExist = QueryServiceHelper.exists((String)"task_usergroup", (QFilter[])new QFilter[]{idFil, sscidFil, userIdFil});
        if (!isExist) {
            this.errCode = "001";
            this.errMessage = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5171\u4eab\u4e2d\u5fc3\u7528\u6237\u7ec4\u7684\u4eba\u5458\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u201csscid\u201d\uff0c\u201cuserGroupId\u201d\uff0c\u201cuserId\u201d\u3002", (String)"WorkCalendarApiController_1", (String)"ssc-task-webapi", (Object[])new Object[0]);
        }
        return isExist;
    }

    private boolean validateDateRange(Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            this.errCode = "001";
            this.errMessage = ResManager.loadKDString((String)"\u201cstartDate\u201d\u5e94\u4e0d\u665a\u4e8e\u201cendDate\u201d\u3002", (String)"WorkCalendarApiController_2", (String)"ssc-task-webapi", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateTimeOpType(String timeOpType) {
        if (!timeOpTypes.contains(timeOpType)) {
            this.errCode = "001";
            this.errMessage = ResManager.loadKDString((String)"\u53c2\u6570\u201ctimeOpType\u201d\u9519\u8bef\uff0c\u4ec5\u652f\u6301\u201c1\u201d\u3001\u201c2\u201d\u3001\u201c3\u201d\u3001\u201c4\u201d\u3002", (String)"WorkCalendarApiController_3", (String)"ssc-task-webapi", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateTimeIntervals(List<String> timeIntervals) {
        Pattern p = Pattern.compile("^\\d{1,2}:\\d{2}-\\d{2}:\\d{2}$");
        for (String interval : timeIntervals) {
            Matcher matcher = p.matcher(interval);
            if (!matcher.matches()) {
                this.errCode = "001";
                this.errMessage = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201ctimeIntervals\u201d\u683c\u5f0f\u6821\u9a8c\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"WorkCalendarApiController_4", (String)"ssc-task-webapi", (Object[])new Object[0]), interval);
                return false;
            }
            String[] timeArr = interval.split("-");
            String[] beginArr = timeArr[0].split(":");
            String[] endArr = timeArr[1].split(":");
            int beginMinutes = Integer.parseInt(beginArr[0]) * 60 + Integer.parseInt(beginArr[1]);
            int endMinutes = Integer.parseInt(endArr[0]) * 60 + Integer.parseInt(endArr[1]);
            if (endMinutes > 1439) {
                this.errCode = "001";
                this.errMessage = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201ctimeIntervals\u201d\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff1a\u201c%s\u201d\u3002\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc723:59\u3002", (String)"WorkCalendarApiController_5", (String)"ssc-task-webapi", (Object[])new Object[0]), interval);
                return false;
            }
            if (beginMinutes < endMinutes) continue;
            this.errCode = "001";
            this.errMessage = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201ctimeIntervals\u201d\u7684\u65f6\u95f4\u533a\u95f4\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"WorkCalendarApiController_6", (String)"ssc-task-webapi", (Object[])new Object[0]), interval);
            return false;
        }
        return true;
    }
}

