/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.util.TaskParamControlUtil;

public class CreditBaseDataUpgradeServiceImpl
implements IUpgradeService {
    private static final String UPDATE_CREFILES = "update t_tk_creditfiles set fstatus = 'D' where fid = ?";
    private static final String UPDATE_SCORELIMIT = "update t_tk_creditscorelimit set fstatus = 'D' where fid = ?";
    private static final String UPDATE_ADDSCORERULE = "update t_tk_creditcommrule set fstatus = 'D' where fid = ?";
    private static final String UPDATE_IMAGESUBSCORERULE = "update t_tk_creditbyimage set fstatus = 'D' where fid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String upgradeParam = TaskParamControlUtil.querySscParam((String)"isUpgradeCreditData");
        if (StringUtils.isEmpty((String)upgradeParam)) {
            return this.buildUpgradeResultAndWriteBackParam(result, ResManager.loadKDString((String)"\u4fe1\u7528\u57fa\u7840\u6570\u636e\u5347\u7ea7\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u6267\u884c\u5931\u8d25", (String)"CreditBaseDataUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]), false);
        }
        if ("true".equals(upgradeParam)) {
            return this.buildUpgradeResultAndWriteBackParam(result, ResManager.loadKDString((String)"\u4fe1\u7528\u57fa\u7840\u6570\u636e\u5df2\u5b8c\u6210\u5347\u7ea7\uff0c\u4e0d\u518d\u91cd\u590d\u6267\u884c", (String)"CreditBaseDataUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]), true);
        }
        Long createOrgid = 0L;
        BigDecimal maxValue = BigDecimal.ZERO;
        DynamicObject[] creditLevels = this.getCreditLevels();
        if (creditLevels == null || creditLevels.length <= 0) {
            return this.buildUpgradeResultAndWriteBackParam(result, ResManager.loadKDString((String)"\u6ca1\u6709\u4fe1\u7528\u57fa\u7840\u6570\u636e\u9700\u8981\u5347\u7ea7", (String)"CreditBaseDataUpgradeServiceImpl_2", (String)"ssc-task-upgradeservice", (Object[])new Object[0]), true);
        }
        createOrgid = creditLevels[0].getLong("createorg.id");
        maxValue = creditLevels[0].getBigDecimal("maxvalue");
        boolean hasOtherSsc = this.upgradeLevel(createOrgid, maxValue, creditLevels);
        if (!hasOtherSsc) {
            SaveServiceHelper.save((DynamicObject[])creditLevels);
            return this.buildUpgradeResultAndWriteBackParam(result, ResManager.loadKDString((String)"\u4fe1\u7528\u7b49\u7ea7\u6570\u636e\u5df2\u5347\u7ea7\uff08\u4e0d\u5b58\u5728\u591a\u5171\u4eab\u4e2d\u5fc3\u7684\u6570\u636e\uff09\uff0c\u5347\u7ea7\u6210\u529f", (String)"CreditBaseDataUpgradeServiceImpl_3", (String)"ssc-task-upgradeservice", (Object[])new Object[0]), true);
        }
        try (TXHandle h = TX.requiresNew((String)"fircm_creditBaseDataUpgrade");){
            try {
                SaveServiceHelper.save((DynamicObject[])creditLevels);
                this.upgradeScoreLimit(createOrgid);
                this.upgradeCreditFiles(createOrgid);
                this.upgradeAddScoreRule(createOrgid);
                this.upgradeImageSubScoreRule(createOrgid);
            }
            catch (Throwable e) {
                h.markRollback();
                result.setErrorInfo(e.getMessage());
                result.setLog(ResManager.loadKDString((String)"\u4fe1\u7528\u57fa\u7840\u6570\u636e\u5347\u7ea7\u5931\u8d25", (String)"CreditBaseDataUpgradeServiceImpl_5", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                result.setSuccess(false);
                UpgradeResult upgradeResult = result;
                if (h != null) {
                    if (var12_12 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var12_12.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        return this.buildUpgradeResultAndWriteBackParam(result, ResManager.loadKDString((String)"\u4fe1\u7528\u57fa\u7840\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"CreditBaseDataUpgradeServiceImpl_4", (String)"ssc-task-upgradeservice", (Object[])new Object[0]), true);
    }

    private UpgradeResult buildUpgradeResultAndWriteBackParam(UpgradeResult result, String log, boolean isSuccess) {
        if (isSuccess) {
            TaskParamControlUtil.writeBackParam((String)"isUpgradeCreditData", (String)"true");
        }
        result.setLog(log);
        result.setSuccess(isSuccess);
        return result;
    }

    private DynamicObject[] getCreditLevels() {
        QFilter[] qfilters = new QFilter[]{new QFilter("createorg", "!=", (Object)0L), new QFilter("status", "!=", (Object)Character.valueOf('D'))};
        String orderBy = "createorg.id asc, maxvalue desc";
        return BusinessDataServiceHelper.load((String)"task_creditlevel", (String)"id, createorg.id, minvalue, maxvalue, status", (QFilter[])qfilters, (String)orderBy);
    }

    private boolean upgradeLevel(Long createOrgid, BigDecimal maxValue, DynamicObject[] creditLevels) {
        boolean hasOtherSsc = false;
        for (DynamicObject level : creditLevels) {
            if (createOrgid.longValue() == level.getLong("createorg.id")) {
                BigDecimal perMaxVal = level.getBigDecimal("maxvalue");
                if (maxValue.compareTo(perMaxVal) <= 0) continue;
                level.set("maxvalue", (Object)perMaxVal.add(BigDecimal.ONE));
                continue;
            }
            level.set("status", (Object)Character.valueOf('D'));
            hasOtherSsc = true;
        }
        return hasOtherSsc;
    }

    private void upgradeCreditFiles(Long createOrgid) {
        this.discardData("task_creditfiles", createOrgid, UPDATE_CREFILES);
    }

    private void upgradeScoreLimit(Long createOrgid) {
        this.discardData("task_creditscorelimit", createOrgid, UPDATE_SCORELIMIT);
    }

    private void upgradeAddScoreRule(Long createOrgid) {
        this.discardData("task_credit_commonrule", createOrgid, UPDATE_ADDSCORERULE);
    }

    private void upgradeImageSubScoreRule(Long createOrgid) {
        this.discardData("task_creditbyimagenew", createOrgid, UPDATE_IMAGESUBSCORERULE);
    }

    private void discardData(String entityName, Long createOrgid, String executeSql) {
        String algoKey = this.getClass() + ".discardData()";
        QFilter[] qfilters = new QFilter[]{new QFilter("createorg", "!=", (Object)createOrgid), new QFilter("status", "!=", (Object)Character.valueOf('D'))};
        ArrayList<Object[]> params = new ArrayList<Object[]>(32);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id, status", (QFilter[])qfilters, null);){
            for (Row row : ds) {
                Object[] paramArr = new Object[]{row.getLong("id")};
                params.add(paramArr);
                if (params.size() != 1000) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)executeSql, params);
                params.clear();
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)executeSql, params);
        }
    }
}

